/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.IOException;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;

public class SyntaxDebug {
    public static final String NO_STATE_ASSIGNED = "NO STATE ASSIGNED";
    public static final String NULL_STATE = "NULL STATE";
    public static final String NULL_SYNTAX_MARK = "NULL SYNTAX MARK";
    public Syntax syntax;

    public SyntaxDebug(Syntax syntax) {
        this.syntax = syntax;
    }

    public int parseFile(String string) throws IOException {
        char[] cArray = Analyzer.loadFile(string);
        this.syntax.load(null, cArray, 0, cArray.length, true, 0);
        int n = this.debugScan();
        return n;
    }

    public int debugScan() {
        int n = 0;
        while (true) {
            TokenID tokenID;
            if ((tokenID = this.syntax.nextToken()) == null) {
                System.out.println("EOT at offset=" + this.syntax.getTokenOffset());
                return n;
            }
            ++n;
            System.out.println(tokenID.getName() + " in " + this.syntax.getTokenContextPath() + ": TEXT='" + EditorDebug.debugChars(this.syntax.getBuffer(), this.syntax.getTokenOffset(), this.syntax.getTokenLength()) + "', offset=" + this.syntax.getTokenOffset() + ", len=" + this.syntax.getTokenLength());
        }
    }
}

