/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.i18n.I18nSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryRegistry {
    private static Lookup.Result<I18nSupport.Factory> result;
    private static final Set<Class> cache;
    private static final Set<Class> ncache;

    private FactoryRegistry() {
    }

    private static Lookup.Result<I18nSupport.Factory> getSupports() {
        if (result == null) {
            result = Lookup.getDefault().lookupResult(I18nSupport.Factory.class);
            result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    cache.clear();
                    ncache.clear();
                }
            });
        }
        return result;
    }

    public static I18nSupport.Factory getFactory(Class clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        for (Object object : FactoryRegistry.getSupports().allInstances()) {
            Object object2 = ((I18nSupport.Factory)object).getDataObjectClass();
            if (object2 == null || !((Class)object2).isAssignableFrom(clazz)) continue;
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (I18nSupport.Factory)arrayList.get(0);
        }
        Object object = null;
        for (Object object2 : arrayList) {
            if (object == null) {
                object = object2;
                continue;
            }
            if (!((I18nSupport.Factory)object).getDataObjectClass().isAssignableFrom(((I18nSupport.Factory)object2).getDataObjectClass())) continue;
            object = object2;
        }
        return object;
    }

    public static boolean hasFactory(Class clazz) {
        if (cache.contains(clazz)) {
            return true;
        }
        if (ncache.contains(clazz)) {
            return false;
        }
        for (I18nSupport.Factory factory : FactoryRegistry.getSupports().allInstances()) {
            Class clazz2 = factory.getDataObjectClass();
            if (clazz2 == null || !clazz2.isAssignableFrom(clazz)) continue;
            cache.add(clazz);
            return true;
        }
        ncache.add(clazz);
        return false;
    }

    static {
        cache = Collections.synchronizedSet(new HashSet(5));
        ncache = Collections.synchronizedSet(new HashSet(50));
    }
}

