/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;

public class GsfReformatTask
implements ReformatTask {
    private static final Logger LOG = Logger.getLogger(GsfReformatTask.class.getName());
    private final Context context;
    private final Source source;
    private Formatter formatter;
    private String mimeType;

    GsfReformatTask(Source source, Context context) {
        this.context = context;
        this.source = source;
    }

    private synchronized Formatter getFormatter() {
        if (this.formatter == null) {
            MimePath mimePath = MimePath.parse((String)this.context.mimePath());
            this.mimeType = mimePath.size() > 1 ? mimePath.getMimeType(mimePath.size() - 1) : mimePath.getPath();
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(this.mimeType);
            this.formatter = language.getFormatter();
        }
        return this.formatter;
    }

    public void reformat() throws BadLocationException {
        final Formatter formatter = this.getFormatter();
        if (formatter != null) {
            if (formatter.needsParserResult()) {
                try {
                    ParserManager.parse(Collections.singleton(this.source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws ParseException {
                            if (resultIterator.getSnapshot().getMimeType().equals(GsfReformatTask.this.mimeType)) {
                                Object object = (ParserResult)resultIterator.getParserResult();
                                if (!(object instanceof ParserResult)) {
                                    return;
                                }
                                formatter.reformat(GsfReformatTask.this.context, (ParserResult)((Object)object));
                            }
                            for (Embedding embedding : resultIterator.getEmbeddings()) {
                                if (!embedding.getMimeType().equals(GsfReformatTask.this.mimeType)) continue;
                                this.run(resultIterator.getResultIterator(embedding));
                            }
                        }
                    });
                }
                catch (ParseException parseException) {
                    LOG.log(Level.WARNING, null, parseException);
                }
            } else {
                formatter.reformat(this.context, null);
            }
        }
    }

    public ExtraLock reformatLock() {
        Formatter formatter = this.getFormatter();
        if (formatter != null && formatter.needsParserResult()) {
            return new Lock();
        }
        return null;
    }

    private class Lock
    implements ExtraLock {
        private Lock() {
        }

        public void lock() {
            Utilities.acquireParserLock();
        }

        public void unlock() {
            Utilities.releaseParserLock();
        }
    }
}

