/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesDataContainer;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesDescriptorAccessor;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphPainter {
    private static final Stroke BALL_STROKE = new BasicStroke(1.0f);
    private static final Stroke LINE_STROKE = new BasicStroke(DLightUIPrefs.getFloat((String)"indicator.line.thickness"));
    private static final Color H_AXIS_FONT_COLOR = DLightUIPrefs.getColor((String)"indicator.x_axis.font_color");
    private static final Color V_AXIS_FONT_COLOR = DLightUIPrefs.getColor((String)"indicator.y_axis.font_color");
    private final List<TimeSeriesDescriptor> descriptors;
    private final int seriesCount;
    private TimeSeriesDataContainer data;

    public GraphPainter(List<TimeSeriesDescriptor> list, TimeSeriesDataContainer timeSeriesDataContainer) {
        this.descriptors = list;
        this.seriesCount = list.size();
        this.data = timeSeriesDataContainer;
    }

    public int calculateUpperLimit(float ... fArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        block4: for (int i = 0; i < fArray.length; ++i) {
            float f3 = fArray[i];
            TimeSeriesDescriptor timeSeriesDescriptor = this.descriptors.get(i);
            switch (TimeSeriesDescriptorAccessor.getDefault().getKind(timeSeriesDescriptor)) {
                case ABS_SURFACE: 
                case LINE: {
                    f = Math.max(f, f3);
                    continue block4;
                }
                case REL_SURFACE: {
                    f2 += f3;
                }
            }
        }
        return (int)Math.max(f, f2);
    }

    public void paint(Graphics graphics, int n, List<AxisMark> list, int n2, int n3, List<AxisMark> list2, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        GraphPainter.paintGradient(graphics, n6, n7, n8, n9);
        if (0 < n8 && 0 < n9) {
            this.paintGraph(graphics, n, n2, n3, n6, n7, n8, n9);
            GraphPainter.paintGrid(graphics, n6, n7, n8, n9, list2, list, bl);
            this.dimInactiveRegions(graphics, n2, n3, n4, n5, n6, n7, n8, n9);
        }
    }

    private static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = DLightUIPrefs.getColor((String)"indicator.graph.bgcolor_top");
        Color color2 = DLightUIPrefs.getColor((String)"indicator.graph.bgcolor_bottom");
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n4, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(paint);
    }

    private static void paintGrid(Graphics graphics, int n, int n2, int n3, int n4, List<AxisMark> list, List<AxisMark> list2, boolean bl) {
        Color color = DLightUIPrefs.getColor((String)"indicator.grid.color");
        Color color2 = DLightUIPrefs.getColor((String)"indicator.border.color");
        for (AxisMark axisMark : list) {
            graphics.setColor(GraphPainter.adjustAlpha(color, axisMark.getMarkOpacity()));
            graphics.drawLine(n + axisMark.getPosition(), n2, n + axisMark.getPosition(), n2 + n4 - 1);
        }
        if (bl) {
            for (AxisMark axisMark : list) {
                graphics.setColor(GraphPainter.adjustAlpha(color2, axisMark.getMarkOpacity()));
                graphics.drawLine(n + axisMark.getPosition(), n2 + n4 - 5, n + axisMark.getPosition(), n2 + n4 - 1);
            }
        }
        for (AxisMark axisMark : list2) {
            graphics.setColor(GraphPainter.adjustAlpha(color, axisMark.getMarkOpacity()));
            graphics.drawLine(n, n2 + n4 - 1 - axisMark.getPosition(), n + n3 - 1, n2 + n4 - 1 - axisMark.getPosition());
        }
        if (bl) {
            for (AxisMark axisMark : list2) {
                graphics.setColor(GraphPainter.adjustAlpha(color2, axisMark.getMarkOpacity()));
                graphics.drawLine(n, n2 + n4 - 1 - axisMark.getPosition(), n + 5, n2 + n4 - 1 - axisMark.getPosition());
            }
        }
    }

    private void paintGraph(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        TimeSeriesDescriptorAccessor timeSeriesDescriptorAccessor = TimeSeriesDescriptorAccessor.getDefault();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke stroke = graphics2D.getStroke();
        int n8 = Math.min(n3 + 1, this.data.size()) - n2;
        if (0 < n8) {
            int[] nArray = new int[n8 + 2];
            int[] nArray2 = new int[n8 + 2];
            Font font = DLightUIPrefs.getFont((String)"indicator.y_axis.font");
            int n9 = n7 - 2 - font.getSize() / 2;
            int n10 = DLightUIPrefs.getInt((String)"indicator.ball.size");
            block4: for (int i = 0; i < this.seriesCount; ++i) {
                int n11 = 0;
                int n12 = 0;
                for (int j = 0; j < n8; ++j) {
                    int n13;
                    float[] fArray = this.data.get(n2 + j);
                    float f = fArray[i];
                    int n14 = 0;
                    if (timeSeriesDescriptorAccessor.getKind(this.descriptors.get(i)) == TimeSeriesDescriptor.Kind.REL_SURFACE) {
                        for (n13 = i + 1; n13 < this.seriesCount; ++n13) {
                            if (timeSeriesDescriptorAccessor.getKind(this.descriptors.get(n13)) != TimeSeriesDescriptor.Kind.REL_SURFACE) continue;
                            f += fArray[n13];
                        }
                    } else if (timeSeriesDescriptorAccessor.getKind(this.descriptors.get(i)) == TimeSeriesDescriptor.Kind.ABS_SURFACE) {
                        for (n13 = i + 1; n13 < this.seriesCount; ++n13) {
                            if (timeSeriesDescriptorAccessor.getKind(this.descriptors.get(n13)) != TimeSeriesDescriptor.Kind.ABS_SURFACE) continue;
                            n14 += 2;
                        }
                    }
                    nArray[j] = n11 = DLightMath.map((int)(n2 + j), (int)n2, (int)n3, (int)n4, (int)(n4 + n6));
                    nArray2[j] = n12 = (int)((float)(n5 + n7 - 2) - f * (float)n9 / (float)n) - n14;
                }
                graphics2D.setColor(timeSeriesDescriptorAccessor.getColor(this.descriptors.get(i)));
                switch (timeSeriesDescriptorAccessor.getKind(this.descriptors.get(i))) {
                    case LINE: {
                        graphics2D.setStroke(LINE_STROKE);
                        graphics2D.drawPolyline(nArray, nArray2, n8);
                        graphics2D.setStroke(BALL_STROKE);
                        graphics2D.setColor(Color.WHITE);
                        graphics2D.fillOval(n11 - n10 / 2, n12 - n10 / 2, n10 - 1, n10 - 1);
                        graphics2D.setColor(timeSeriesDescriptorAccessor.getColor(this.descriptors.get(i)));
                        graphics2D.drawOval(n11 - n10 / 2, n12 - n10 / 2, n10 - 1, n10 - 1);
                        continue block4;
                    }
                    case ABS_SURFACE: 
                    case REL_SURFACE: {
                        nArray[n8] = n11;
                        nArray[n8 + 1] = n4;
                        int n15 = n5 + n7;
                        nArray2[n8 + 1] = n15;
                        nArray2[n8] = n15;
                        graphics2D.fillPolygon(nArray, nArray2, n8 + 2);
                        continue block4;
                    }
                    default: {
                        System.err.println("Uknown graph kind: " + (Object)((Object)timeSeriesDescriptorAccessor.getKind(this.descriptors.get(i))));
                    }
                }
            }
        }
        graphics2D.setStroke(stroke);
    }

    private void dimInactiveRegions(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(DLightUIPrefs.getColor((String)"indicator.graph.filter.color"));
        if (n <= n3) {
            n9 = DLightMath.map((int)n3, (int)n, (int)n2, (int)0, (int)n7);
            graphics2D.fillRect(n5, n6, n9, n8);
        }
        if (n4 <= n2) {
            n9 = DLightMath.map((int)n4, (int)n, (int)n2, (int)0, (int)n7);
            graphics2D.fillRect(n5 + n9, n6, n7 - n9, n8);
        }
    }

    public void paintHorizontalAxis(Graphics graphics, int n, int n2, int n3, int n4, List<AxisMark> list, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (AxisMark axisMark : list) {
            if (axisMark.getText() == null) continue;
            int n5 = fontMetrics.stringWidth(axisMark.getText());
            graphics.setColor(GraphPainter.adjustAlpha(H_AXIS_FONT_COLOR, axisMark.getTextOpacity()));
            graphics.drawString(axisMark.getText(), n + axisMark.getPosition() - n5 / 2, n2 + fontMetrics.getAscent());
        }
    }

    public void paintVerticalAxis(Graphics graphics, int n, int n2, int n3, int n4, List<AxisMark> list, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(DLightUIPrefs.getFont((String)"indicator.y_axis.font"));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (AxisMark axisMark : list) {
            if (axisMark.getText() == null) continue;
            int n5 = fontMetrics.stringWidth(axisMark.getText());
            graphics.setColor(GraphPainter.adjustAlpha(V_AXIS_FONT_COLOR, axisMark.getTextOpacity()));
            graphics.drawString(axisMark.getText(), n + n3 - n5 - fontMetrics.getAscent() / 2, n2 + n4 - 1 - axisMark.getPosition() + fontMetrics.getAscent() / 2);
        }
    }

    private static Color adjustAlpha(Color color, int n) {
        if (n == 255) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * n / 255);
    }
}

