/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.Property;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyModel {
    private static PropertyModel instance;
    private Map<String, Property> properties;
    private int group_index;

    public static synchronized PropertyModel instance() {
        if (instance == null) {
            instance = new PropertyModel("org/netbeans/modules/css/resources/css_property_table");
        }
        return instance;
    }

    private PropertyModel(String string) {
        this.parseSource(string);
    }

    public Collection<Property> properties() {
        return this.properties.values();
    }

    public Property getProperty(String string) {
        return this.properties.get(string.toLowerCase());
    }

    private void parseSource(String string) {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
        this.properties = new HashMap<String, Property>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            String string3 = resourceBundle.getString(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken().trim();
            String string6 = stringTokenizer.nextToken().trim();
            boolean bl = Boolean.parseBoolean(stringTokenizer.nextToken());
            String string7 = stringTokenizer.nextToken().trim();
            String string8 = stringTokenizer.nextToken();
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string8, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                arrayList.add(stringTokenizer2.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                Logger.global.warning("Error in source for css properties model for property: " + string2);
            }
            StringTokenizer stringTokenizer3 = new StringTokenizer(string2, ";");
            while (stringTokenizer3.hasMoreTokens()) {
                String string9 = stringTokenizer3.nextToken().trim();
                Property property = new Property(string9, string5, string4, string6, bl, string7, arrayList);
                this.properties.put(string9, property);
            }
        }
    }

    GroupElement parse(String string) {
        return this.parse(string, null);
    }

    GroupElement parse(String string, String string2) {
        this.group_index = 0;
        GroupElement groupElement = new GroupElement(null, this.group_index, string2);
        ParserInput parserInput = new ParserInput(string);
        this.group_index = 0;
        this.parseElements(parserInput, groupElement, false);
        return groupElement;
    }

    private void parseElements(ParserInput parserInput, GroupElement groupElement, boolean bl) {
        Element element = null;
        char c;
        block13: while ((c = parserInput.read()) != '\uffff') {
            StringBuffer stringBuffer;
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block13;
                }
                case '[': {
                    element = new GroupElement(groupElement, ++this.group_index);
                    this.parseElements(parserInput, (GroupElement)element, false);
                    groupElement.addElement(element);
                    continue block13;
                }
                case '|': {
                    char c2 = parserInput.read();
                    if (c2 != '|') continue block13;
                    groupElement.setIsList(true);
                    continue block13;
                }
                case '>': {
                    groupElement.setIsSequence(true);
                    continue block13;
                }
                case ']': {
                    return;
                }
                case '\'': {
                    stringBuffer = new StringBuffer();
                    while ((c = parserInput.read()) != '\'') {
                        stringBuffer.append(c);
                    }
                    String string = stringBuffer.toString();
                    Property property = this.getProperty(string);
                    if (property == null) {
                        throw new IllegalStateException("no referred element '" + string + "' found!");
                    }
                    element = new GroupElement(groupElement, ++this.group_index, string);
                    ParserInput parserInput2 = new ParserInput(property.valuesText());
                    this.parseElements(parserInput2, (GroupElement)element, true);
                    groupElement.addElement(element);
                    continue block13;
                }
                case '!': {
                    stringBuffer = new StringBuffer();
                    while ((c = parserInput.read()) != '\uffff') {
                        if (PropertyModel.isEndOfValueChar(c)) {
                            parserInput.backup(1);
                            break;
                        }
                        stringBuffer.append(c);
                    }
                    element = new ValueElement(groupElement);
                    ((ValueElement)element).setValue(stringBuffer.toString());
                    ((ValueElement)element).setIsUnit(true);
                    groupElement.addElement(element);
                    continue block13;
                }
                case '{': {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while ((c = parserInput.read()) != '}') {
                        stringBuffer2.append(c);
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer2.toString(), ",");
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    element.setMinimumOccurances(n);
                    element.setMaximumOccurances(n2);
                    continue block13;
                }
                case '+': {
                    element.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block13;
                }
                case '*': {
                    element.setMinimumOccurances(0);
                    element.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block13;
                }
                case '?': {
                    element.setMinimumOccurances(0);
                    element.setMaximumOccurances(1);
                    continue block13;
                }
            }
            stringBuffer = new StringBuffer();
            while (c != '\uffff') {
                if (PropertyModel.isEndOfValueChar(c)) {
                    parserInput.backup(1);
                    break;
                }
                stringBuffer.append(c);
                c = parserInput.read();
            }
            String string = stringBuffer.toString();
            if (bl && "inherit".equalsIgnoreCase(string)) continue;
            element = new ValueElement(groupElement);
            ((ValueElement)element).setValue(string);
            ((ValueElement)element).setIsUnit(false);
            groupElement.addElement(element);
        }
        return;
    }

    private static boolean isEndOfValueChar(char c) {
        return c == ' ' || c == '+' || c == '?' || c == '{' || c == '[' || c == ']' || c == '|';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupElement
    extends Element {
        private int index;
        private String referenceName = null;
        private List<Element> elements = new ArrayList<Element>(5);
        private boolean list = false;
        private boolean sequence = false;

        private GroupElement(GroupElement groupElement, int n, String string) {
            this(groupElement, n);
            this.referenceName = string;
        }

        private GroupElement(GroupElement groupElement, int n) {
            super(groupElement);
            this.index = n;
        }

        public boolean isList() {
            return this.list;
        }

        public boolean isSequence() {
            return this.sequence;
        }

        void setIsList(boolean bl) {
            this.list = bl;
        }

        void setIsSequence(boolean bl) {
            this.sequence = bl;
        }

        public List<Element> elements() {
            return this.elements;
        }

        void addElement(Element element) {
            this.elements.add(element);
        }

        public List<Element> getAllPossibleValues() {
            ArrayList<Element> arrayList = new ArrayList<Element>(10);
            if (this.isSequence()) {
                Element element = this.elements.get(0);
                if (element instanceof GroupElement) {
                    arrayList.addAll(((GroupElement)element).getAllPossibleValues());
                } else {
                    arrayList.add(element);
                }
            } else {
                for (Element element : this.elements()) {
                    if (element instanceof GroupElement) {
                        arrayList.addAll(((GroupElement)element).getAllPossibleValues());
                        continue;
                    }
                    arrayList.add(element);
                }
            }
            return arrayList;
        }

        @Override
        public String toString2(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.indentString(n) + "[G" + this.index + " ");
            if (this.referenceName != null) {
                stringBuilder.append("(" + this.referenceName + ") ");
            }
            if (this.sequence) {
                stringBuilder.append("SEQUENCE");
            } else if (this.list) {
                stringBuilder.append("ANY: ");
            } else {
                stringBuilder.append("ONE: ");
            }
            stringBuilder.append('\n');
            for (Element element : this.elements()) {
                stringBuilder.append(element.toString2(n + 1));
                stringBuilder.append('\n');
            }
            stringBuilder.append(this.indentString(n));
            stringBuilder.append(']');
            stringBuilder.append(super.toString());
            return stringBuilder.toString();
        }

        @Override
        public String toString() {
            return "[G" + this.index + "]";
        }
    }

    public static class ValueElement
    extends Element {
        private boolean isUnit = false;
        private String value = null;

        public ValueElement(GroupElement groupElement) {
            super(groupElement);
        }

        public boolean isUnit() {
            return this.isUnit;
        }

        void setIsUnit(boolean bl) {
            this.isUnit = bl;
        }

        public String value() {
            return this.value;
        }

        void setValue(String string) {
            this.value = string;
        }

        public String toString() {
            return (this.isUnit() ? "!" : "") + this.value() + super.toString();
        }
    }

    public static abstract class Element {
        private GroupElement parent;
        private int minimum_occurances = 1;
        private int maximum_occurances = 1;

        public Element(GroupElement groupElement) {
            this.parent = groupElement;
        }

        void setMinimumOccurances(int n) {
            this.minimum_occurances = n;
        }

        void setMaximumOccurances(int n) {
            this.maximum_occurances = n;
        }

        public int getMaximumOccurances() {
            return this.maximum_occurances;
        }

        public int getMinimumOccurances() {
            return this.minimum_occurances;
        }

        public GroupElement parent() {
            return this.parent;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Element)) {
                return false;
            }
            Element element = (Element)object;
            return this.path().equalsIgnoreCase(element.path());
        }

        public String origin() {
            for (GroupElement groupElement = this.parent; groupElement != null; groupElement = groupElement.parent()) {
                if (groupElement.referenceName == null) continue;
                return groupElement.referenceName;
            }
            return null;
        }

        public String path() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.parent() != null) {
                stringBuffer.append(this.parent().path());
                stringBuffer.append('/');
            }
            stringBuffer.append(this.toString());
            return stringBuffer.toString();
        }

        public String toString() {
            if (this.getMinimumOccurances() != 1 || this.getMaximumOccurances() != 1) {
                return "{" + this.getMinimumOccurances() + "," + (this.getMaximumOccurances() == Integer.MAX_VALUE ? "inf" : Integer.valueOf(this.getMaximumOccurances())) + "}";
            }
            return "";
        }

        public String toString2(int n) {
            return this.indentString(n) + this.toString();
        }

        protected String indentString(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('\t');
            }
            return stringBuffer.toString();
        }
    }

    private static class ParserInput {
        CharSequence text;
        private int pos = 0;

        private ParserInput(CharSequence charSequence) {
            this.text = charSequence;
        }

        public char read() {
            if (this.pos == this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(this.pos++);
        }

        public void backup(int n) {
            this.pos -= n;
        }
    }
}

