/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public abstract class Query
extends Prepared {
    protected Expression limit;
    protected Expression offset;
    protected int sampleSize;
    private int lastLimit;
    private long lastEvaluated;
    private LocalResult lastResult;
    private Value[] lastParameters;

    public Query(Session session) {
        super(session);
    }

    protected abstract LocalResult queryWithoutCache(int var1) throws SQLException;

    public abstract void init() throws SQLException;

    public abstract ObjectArray getExpressions();

    public abstract double getCost();

    public abstract HashSet getTables();

    public abstract void setOrder(ObjectArray var1);

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2) throws SQLException;

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3) throws SQLException;

    public abstract void setDistinct(boolean var1);

    public abstract String getFirstColumnAlias(Session var1);

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract void updateAggregate(Session var1) throws SQLException;

    public boolean isQuery() {
        return true;
    }

    public boolean isTransactional() {
        return true;
    }

    private boolean sameResultAsLast(Session session, Value[] valueArray, Value[] valueArray2, long l) throws SQLException {
        Database database = session.getDatabase();
        for (int i = 0; i < valueArray.length; ++i) {
            if (database.areEqual(valueArray2[i], valueArray[i])) continue;
            return false;
        }
        if (!this.isEverything(2) || !this.isEverything(0)) {
            return false;
        }
        return database.getModificationDataId() <= l || this.getMaxDataModificationId() <= l;
    }

    public final Value[] getParameterValues() {
        ObjectArray objectArray = this.getParameters();
        if (objectArray == null) {
            objectArray = new ObjectArray();
        }
        Value[] valueArray = new Value[objectArray.size()];
        for (int i = 0; i < objectArray.size(); ++i) {
            Value value;
            valueArray[i] = value = ((Parameter)objectArray.get(i)).getParamValue();
        }
        return valueArray;
    }

    public LocalResult query(int n) throws SQLException {
        if (!this.session.getDatabase().getOptimizeReuseResults()) {
            return this.queryWithoutCache(n);
        }
        Value[] valueArray = this.getParameterValues();
        long l = this.session.getDatabase().getModificationDataId();
        if (this.lastResult != null && !this.lastResult.isClosed() && n == this.lastLimit && this.sameResultAsLast(this.session, valueArray, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = valueArray;
        this.closeLastResult();
        this.lastResult = this.queryWithoutCache(n);
        this.lastEvaluated = l;
        this.lastLimit = n;
        return this.lastResult;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    void initOrder(ObjectArray objectArray, ObjectArray objectArray2, ObjectArray objectArray3, int n, boolean bl) throws SQLException {
        for (int i = 0; i < objectArray3.size(); ++i) {
            String string;
            Object object;
            SelectOrderBy selectOrderBy = (SelectOrderBy)objectArray3.get(i);
            Expression expression = selectOrderBy.expression;
            if (expression == null) continue;
            boolean bl2 = false;
            int n2 = objectArray.size();
            if (expression instanceof ExpressionColumn) {
                object = (ExpressionColumn)expression;
                String string2 = ((ExpressionColumn)object).getOriginalTableAliasName();
                string = ((ExpressionColumn)object).getOriginalColumnName();
                for (int j = 0; j < n; ++j) {
                    Object object2;
                    Expression expression2;
                    boolean bl3 = false;
                    Expression expression3 = (Expression)objectArray.get(j);
                    if (expression3 instanceof ExpressionColumn) {
                        expression2 = (ExpressionColumn)expression3;
                        bl3 = string.equals(((ExpressionColumn)expression2).getColumnName());
                        if (string2 != null && bl3 && (object2 = ((ExpressionColumn)expression2).getOriginalTableAliasName()) != null) {
                            bl3 = string2.equals(object2);
                        }
                    } else {
                        if (!(expression3 instanceof Alias)) continue;
                        if (string2 == null && string.equals(expression3.getAlias())) {
                            bl3 = true;
                        } else {
                            expression2 = expression3.getNonAliasExpression();
                            if (expression2 instanceof ExpressionColumn) {
                                object2 = expression2;
                                String string3 = ((ExpressionColumn)object).getSQL();
                                String string4 = ((ExpressionColumn)object2).getSQL();
                                bl3 = string.equals(((ExpressionColumn)object2).getColumnName());
                                if (!StringUtils.equals(string3, string4)) {
                                    bl3 = false;
                                }
                            }
                        }
                    }
                    if (!bl3) continue;
                    n2 = j;
                    bl2 = true;
                    break;
                }
            } else {
                object = expression.getSQL();
                for (int j = 0; objectArray2 != null && j < objectArray2.size(); ++j) {
                    string = (String)objectArray2.get(j);
                    if (!string.equals(object)) continue;
                    n2 = j;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                if (bl) {
                    throw Message.getSQLException(90068, expression.getSQL());
                }
                objectArray.add(expression);
            }
            selectOrderBy.expression = null;
            selectOrderBy.columnIndexExpr = ValueExpression.get(ValueInt.get(n2 + 1));
        }
    }

    public SortOrder prepareOrder(ObjectArray objectArray, int n) throws SQLException {
        int[] nArray = new int[objectArray.size()];
        int[] nArray2 = new int[objectArray.size()];
        for (int i = 0; i < objectArray.size(); ++i) {
            int n2;
            int n3;
            SelectOrderBy selectOrderBy = (SelectOrderBy)objectArray.get(i);
            boolean bl = false;
            if (selectOrderBy.expression != null) {
                throw Message.getInternalError();
            }
            Expression expression = selectOrderBy.columnIndexExpr;
            Value value = expression.getValue(null);
            if (value == ValueNull.INSTANCE) {
                n3 = 0;
            } else {
                n3 = value.getInt();
                if (n3 < 0) {
                    bl = true;
                    n3 = -n3;
                }
                if (--n3 < 0 || n3 >= n) {
                    throw Message.getSQLException(90068, "" + (n3 + 1));
                }
            }
            nArray[i] = n3;
            boolean bl2 = selectOrderBy.descending;
            if (bl) {
                bl2 = !bl2;
            }
            int n4 = n2 = bl2 ? 1 : 0;
            if (selectOrderBy.nullsFirst) {
                n2 += 2;
            } else if (selectOrderBy.nullsLast) {
                n2 += 4;
            }
            nArray2[i] = n2;
        }
        return new SortOrder(this.session.getDatabase(), nArray, nArray2);
    }

    public void setOffset(Expression expression) {
        this.offset = expression;
    }

    public void setLimit(Expression expression) {
        this.limit = expression;
    }

    void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ObjectArray();
        }
        this.parameters.add(parameter);
    }

    public void setSampleSize(int n) {
        this.sampleSize = n;
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(4);
        this.isEverything(expressionVisitor);
        return expressionVisitor.getMaxDataModificationId();
    }

    public final boolean isEverything(int n) {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(n);
        return this.isEverything(expressionVisitor);
    }
}

