/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.Interp;
import org.netbeans.lib.terminalemulator.Ops;

public abstract class AbstractInterp
implements Interp {
    public Ops ops;
    public State state;
    private static final int max_numbers = 5;
    private int numberx = 0;
    private String[] number = new String[5];

    protected AbstractInterp(Ops ops) {
        this.ops = ops;
    }

    public void reset() {
    }

    protected void resetNumber() {
        for (int i = 0; i < 5; ++i) {
            this.number[i] = "";
        }
        this.numberx = 0;
    }

    protected void remember_digit(char c) {
        int n = this.numberx;
        this.number[n] = this.number[n] + c;
    }

    protected boolean pushNumber() {
        ++this.numberx;
        return this.numberx < 5;
    }

    protected boolean noNumber() {
        return this.number[0].equals("");
    }

    protected int numberAt(int n) {
        if (n > this.numberx) {
            return 1;
        }
        return Integer.parseInt(this.number[n]);
    }

    protected int nNumbers() {
        return this.numberx;
    }

    protected static class State {
        Actor act_error = new Actor(){

            public String action(AbstractInterp abstractInterp, char c) {
                return "generic error";
            }
        };
        private String name;
        private Action[] action = new Action[128];
        private Action action_regular = new Action();

        public String name() {
            return this.name;
        }

        public State(String string) {
            this.name = string;
            for (int i = 0; i < this.action.length; ++i) {
                this.action[i] = new Action();
            }
            this.action_regular.actor = null;
            this.action_regular.new_state = null;
        }

        public void setRegular(State state, Actor actor) {
            this.action_regular.actor = actor;
            this.action_regular.new_state = state;
        }

        public void setAction(char c, State state, Actor actor) {
            if (c > '\u007f') {
                return;
            }
            this.action[c].actor = actor;
            this.action[c].new_state = state;
        }

        Action getAction(char c) {
            if (c > '\u007f') {
                return this.action_regular;
            }
            return this.action[c];
        }

        class Action {
            public State new_state = null;
            public Actor actor;

            Action() {
                this.actor = State.this.act_error;
            }
        }
    }

    protected static interface Actor {
        public String action(AbstractInterp var1, char var2);
    }
}

