/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.j2d.Transform;
import java.awt.Rectangle;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.ScreenManager;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedTransformableElement;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public final class SVGObject {
    private final SceneManager m_sceneMgr;
    private final SVGLocatableElement m_elem;
    private Transform m_initialTransform;
    private SVGObjectOutline m_outline = null;
    private boolean m_isDeleted = false;
    private float m_translateDx = 0.0f;
    private float m_translateDy = 0.0f;
    private float m_skewX = 0.0f;
    private float m_skewY = 0.0f;
    private float m_scaleX = 1.0f;
    private float m_scaleY = 1.0f;
    private float m_rotate = 0.0f;
    private ScalePivotPoint m_scalePivot = null;
    private boolean m_lanscapeUpdate = false;

    public SVGObject(SceneManager sceneManager, SVGLocatableElement sVGLocatableElement) {
        assert (sceneManager != null);
        assert (sVGLocatableElement != null);
        this.m_sceneMgr = sceneManager;
        this.m_elem = sVGLocatableElement;
        this.m_initialTransform = new Transform(this.m_elem instanceof PatchedTransformableElement ? ((PatchedTransformableElement)this.m_elem).getTransform() : null);
        SceneManager.log(Level.FINE, "SVGObject created: " + this.m_elem);
    }

    public SceneManager getSceneManager() {
        return this.m_sceneMgr;
    }

    public ScreenManager getScreenManager() {
        return this.m_sceneMgr.getScreenManager();
    }

    public SVGLocatableElement getSVGElement() {
        return this.m_elem;
    }

    public String getElementId() {
        String string = this.m_elem.getId();
        assert (string != null) : "Null ID of SVGElement " + this.m_elem;
        return string;
    }

    public SVGRect getSafeBBox() {
        return PerseusController.getSafeBBox(this.m_elem);
    }

    public Rectangle getScreenBBox() {
        return this.getOutline().getScreenBoundingBox();
    }

    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    public void repaint() {
        this.repaint(0);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.m_sceneMgr.getScreenManager().repaint(n, n2, n3, n4);
    }

    public void repaint(int n) {
        if (!this.m_isDeleted) {
            Rectangle rectangle = this.getScreenBBox();
            assert (rectangle != null);
            this.m_sceneMgr.getScreenManager().repaint(rectangle, n);
        }
    }

    public synchronized SVGObjectOutline getOutline() {
        if (this.m_outline == null) {
            this.m_outline = new SVGObjectOutline(this);
        }
        return this.m_outline;
    }

    public SVGMatrix getParentTransformation() {
        return PerseusController.getParentTransformation(this.m_elem.getParentNode());
    }

    public void translate(final float f, final float f2, final boolean bl) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            public void run() {
                float f3 = f;
                float f22 = f2;
                try {
                    Transform transform = (Transform)SVGObject.this.getParentTransformation();
                    if (transform != null) {
                        transform = (Transform)transform.inverse();
                        float[] fArray = new float[2];
                        transform.transformPoint(new float[]{f, f2}, fArray);
                        f3 = fArray[0] - transform.getComponent(4);
                        f22 = fArray[1] - transform.getComponent(5);
                    }
                    if (bl) {
                        SVGObject.this.m_translateDx += f3;
                        SVGObject.this.m_translateDy += f22;
                    } else {
                        SVGObject.this.m_translateDx = f3;
                        SVGObject.this.m_translateDy = f22;
                    }
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception exception) {
                    SceneManager.error("Translate operation failed!", exception);
                }
            }
        });
    }

    public void scale(final float f, final float f2, final ScalePivotPoint scalePivotPoint) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            public void run() {
                try {
                    SVGObject.this.m_scaleX = f;
                    SVGObject.this.m_scaleY = f2;
                    SVGObject.this.m_scalePivot = scalePivotPoint;
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception exception) {
                    SceneManager.error("Scale operation failed!", exception);
                }
            }
        });
    }

    public void setLandscape(int n, float[] fArray) {
        this.m_lanscapeUpdate = true;
        this.rotate(n);
        this.translate(fArray[0], fArray[1], true);
    }

    public void rotate(final float f) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            public void run() {
                try {
                    SVGObject.this.m_rotate = f;
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception exception) {
                    SceneManager.error("Rotate operation failed!", exception);
                }
            }
        });
    }

    public void skew(final float f, final float f2) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            public void run() {
                try {
                    SVGObject.this.m_skewX = f;
                    SVGObject.this.m_skewY = f2;
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception exception) {
                    SceneManager.error("Skew operation failed!", exception);
                }
            }
        });
    }

    public void moveToTop() {
        String string = this.getElementId();
        this.getPerseusController().moveToTop(this.m_elem);
        this.getFileModel().moveToTop(string);
        this.repaint();
    }

    public void moveToBottom() {
        String string = this.getElementId();
        this.getPerseusController().moveToBottom(this.m_elem);
        this.getFileModel().moveToBottom(string);
        this.repaint();
    }

    public void moveForward() {
        String string = this.getElementId();
        this.getPerseusController().moveForward(this.m_elem);
        this.getFileModel().moveForward(string);
        this.repaint();
    }

    public void moveBackward() {
        String string = this.getElementId();
        this.getPerseusController().moveBackward(this.m_elem);
        this.getFileModel().moveBackward(string);
        this.repaint();
    }

    public void delete() {
        if (!this.m_isDeleted) {
            String string = this.getElementId();
            this.getFileModel().deleteElement(string, new SVGFileModel.TransactionCommand(){

                public Object execute(Object object) {
                    SVGObject.this.repaint(5);
                    SVGObject.this.m_isDeleted = true;
                    PerseusController perseusController = SVGObject.this.getPerseusController();
                    for (String string : (List)object) {
                        SVGElement sVGElement = perseusController.getElementById(string);
                        SVGObject.this.getPerseusController().delete(sVGElement);
                    }
                    return null;
                }
            });
        } else {
            SceneManager.log(Level.SEVERE, "SVGObject is already deleted.");
        }
    }

    public void applyTextChanges() {
        SVGFileModel sVGFileModel = this.m_sceneMgr.getDataObject().getModel();
        String[] stringArray = this.prepareTextChanges();
        if (stringArray != null) {
            sVGFileModel.setAttributes(this.getElementId(), stringArray);
        }
    }

    public String[] prepareTextChanges() {
        PatchedTransformableElement patchedTransformableElement;
        String[] stringArray = null;
        if (this.m_elem != null && this.m_elem instanceof PatchedTransformableElement && (stringArray = (patchedTransformableElement = (PatchedTransformableElement)this.m_elem).optimizeTransform()) == null) {
            String string = SVGObject.getTransformAsText((SVGMatrix)patchedTransformableElement.getTransform());
            stringArray = new String[]{"transform", string};
        }
        return stringArray;
    }

    public void commitChanges() {
        this.applyUserTransform(true);
        this.m_translateDx = 0.0f;
        this.m_translateDy = 0.0f;
        this.m_skewX = 0.0f;
        this.m_skewY = 0.0f;
        this.m_scaleX = 1.0f;
        this.m_scaleY = 1.0f;
        this.m_scalePivot = null;
        this.m_rotate = 0.0f;
        this.m_lanscapeUpdate = false;
        this.repaint(5);
    }

    public float[] getCurrentTranslate() {
        return new float[]{this.getCurrentTranslateX(), this.getCurrentTranslateY()};
    }

    public float getCurrentTranslateX() {
        return this.m_translateDx;
    }

    public float getCurrentTranslateY() {
        return this.m_translateDy;
    }

    public float getCurrentScaleX() {
        return this.m_scaleX;
    }

    public float getCurrentScaleY() {
        return this.m_scaleY;
    }

    public ScalePivotPoint getCurrentScalePivot() {
        return this.m_scalePivot != null ? this.m_scalePivot : ScalePivotPoint.NW_CORNER;
    }

    public float getCurrentRotate() {
        return this.m_rotate % 360.0f;
    }

    public float getCurrentSkewX() {
        return this.m_skewX;
    }

    public float getCurrentSkewY() {
        return this.m_skewY;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SVGObject( tag=");
        stringBuilder.append(this.m_elem.getLocalName());
        stringBuilder.append(" id=");
        stringBuilder.append(this.m_elem.getId());
        stringBuilder.append(" isDeleted=");
        stringBuilder.append(this.m_isDeleted);
        stringBuilder.append(" translateX=");
        stringBuilder.append(this.m_translateDx);
        stringBuilder.append(" translateY=");
        stringBuilder.append(this.m_translateDy);
        stringBuilder.append(" skewX=");
        stringBuilder.append(this.m_skewX);
        stringBuilder.append(" skewY=");
        stringBuilder.append(this.m_skewY);
        stringBuilder.append(" scaleX=");
        stringBuilder.append(this.m_scaleX);
        stringBuilder.append(" scaleY=");
        stringBuilder.append(this.m_scaleY);
        stringBuilder.append(" scalePivot=");
        stringBuilder.append((Object)this.m_scalePivot);
        stringBuilder.append(" rotate=");
        stringBuilder.append(this.m_rotate);
        stringBuilder.append(" lanscapeUpdate=");
        stringBuilder.append(this.m_lanscapeUpdate);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected void applyUserTransform() {
        this.applyUserTransform(false);
    }

    protected void applyUserTransform(boolean bl) {
        if (this.m_elem instanceof PatchedTransformableElement) {
            this.getScreenManager().incrementChangeTicker();
            PatchedTransformableElement patchedTransformableElement = (PatchedTransformableElement)this.m_elem;
            SVGRect sVGRect = PerseusController.getSafeBBox(this.m_elem);
            if (sVGRect != null) {
                Transform transform;
                float[] fArray = this.prepareRotatePivot(sVGRect);
                float[] fArray2 = this.prepareScalePivot(sVGRect);
                Transform transform2 = new Transform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                transform2.mTranslate(this.getCurrentTranslateX() + fArray[0], this.getCurrentTranslateY() + fArray[1]);
                float f = this.getCurrentSkewX();
                if (f != 0.0f && f > -90.0f && f < 90.0f) {
                    transform = new Transform(1.0f, 0.0f, (float)Math.tan(Math.toRadians(f)), 1.0f, 0.0f, 0.0f);
                    transform2.mMultiply((SVGMatrix)transform);
                }
                if ((f = this.getCurrentSkewY()) != 0.0f && f > -90.0f && f < 90.0f) {
                    transform = new Transform(1.0f, (float)Math.tan(Math.toRadians(f)), 0.0f, 1.0f, 0.0f, 0.0f);
                    transform2.mMultiply((SVGMatrix)transform);
                }
                transform2.mRotate(this.getCurrentRotate());
                transform2.mTranslate(-fArray[0], -fArray[1]);
                transform2.mTranslate(fArray2[0], fArray2[1]);
                transform2.mScale(this.getCurrentScaleX(), this.getCurrentScaleY());
                transform2.mTranslate(-fArray2[0], -fArray2[1]);
                transform2.mMultiply((SVGMatrix)this.m_initialTransform);
                patchedTransformableElement.setTransform(transform2);
                if (bl) {
                    this.m_initialTransform = transform2;
                }
            } else {
                SceneManager.log(Level.SEVERE, "Null BBox for " + patchedTransformableElement);
            }
        }
    }

    private float[] prepareRotatePivot(SVGRect sVGRect) {
        if (!this.m_lanscapeUpdate) {
            float[] fArray = new float[]{sVGRect.getX() + sVGRect.getWidth() / 2.0f, sVGRect.getY() + sVGRect.getHeight() / 2.0f};
            float[] fArray2 = new float[2];
            this.m_initialTransform.transformPoint(fArray, fArray2);
            return fArray2;
        }
        return new float[]{0.0f, 0.0f};
    }

    private float[] prepareScalePivot(SVGRect sVGRect) {
        float[] fArray;
        if (this.getCurrentScalePivot().isNWCorner()) {
            float[] fArray2 = new float[2];
            fArray2[0] = sVGRect.getX();
            fArray = fArray2;
            fArray2[1] = sVGRect.getY();
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = sVGRect.getX() + sVGRect.getWidth();
            fArray = fArray3;
            fArray3[1] = sVGRect.getY() + sVGRect.getHeight();
        }
        float[] fArray4 = fArray;
        float[] fArray5 = new float[2];
        this.m_initialTransform.transformPoint(fArray4, fArray5);
        return fArray5;
    }

    protected final PerseusController getPerseusController() {
        return this.m_sceneMgr.getPerseusController();
    }

    protected final SVGFileModel getFileModel() {
        return this.m_sceneMgr.getDataObject().getModel();
    }

    public static boolean areSame(SVGObject[] sVGObjectArray, SVGObject[] sVGObjectArray2) {
        if (sVGObjectArray == sVGObjectArray2) {
            return true;
        }
        if (sVGObjectArray == null || sVGObjectArray2 == null) {
            return false;
        }
        if (sVGObjectArray.length != sVGObjectArray2.length) {
            return false;
        }
        for (int i = 0; i < sVGObjectArray.length; ++i) {
            if (sVGObjectArray[i] == sVGObjectArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static String getTransformAsText(SVGMatrix sVGMatrix) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sVGMatrix != null) {
            if (PerseusController.isIdentityTransform(sVGMatrix, true)) {
                stringBuilder.append("translate(");
                stringBuilder.append(sVGMatrix.getComponent(4));
                stringBuilder.append(',');
                stringBuilder.append(sVGMatrix.getComponent(5));
                stringBuilder.append(")");
            } else {
                stringBuilder.append("matrix(");
                for (int i = 0; i < 5; ++i) {
                    stringBuilder.append(sVGMatrix.getComponent(i));
                    stringBuilder.append(',');
                }
                stringBuilder.append(sVGMatrix.getComponent(5));
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScalePivotPoint {
        NW_CORNER,
        SE_CORNER;


        public boolean isSECorner() {
            switch (this) {
                case SE_CORNER: {
                    return true;
                }
            }
            return false;
        }

        public boolean isNWCorner() {
            switch (this) {
                case NW_CORNER: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            switch (this) {
                case NW_CORNER: {
                    return "NW_CORNER";
                }
                case SE_CORNER: {
                    return "SE_CORNER";
                }
            }
            return "Unsupported";
        }
    }
}

