/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YieldNode
extends Node {
    private final Node argsNode;
    private final boolean expandedArguments;

    public YieldNode(ISourcePosition position, Node argsNode, boolean expandedArguments) {
        super(position);
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.expandedArguments = expandedArguments;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.YIELDNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitYieldNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    @Deprecated
    public boolean getCheckState() {
        return this.expandedArguments;
    }

    public boolean getExpandArguments() {
        return this.expandedArguments;
    }

    @Override
    public List<Node> childNodes() {
        return YieldNode.createList(this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.expandedArguments) {
            return context.getCurrentFrame().getBlock().yield(context, this.argsNode.interpret(runtime2, context, self, aBlock), null, null, true);
        }
        return context.getCurrentFrame().getBlock().yield(context, this.argsNode.interpret(runtime2, context, self, aBlock));
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return aBlock.isGiven() ? "yield" : null;
    }
}

