/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Pointer;
import com.kenai.jffi.MemoryIO;

public class JFFIPointer
extends Number
implements Pointer {
    static final MemoryIO IO = MemoryIO.getInstance();
    final long address;

    JFFIPointer(long address2) {
        this.address = address2;
    }

    public final byte getByte(long offset2) {
        return IO.getByte(this.address + offset2);
    }

    public final short getShort(long offset2) {
        return IO.getShort(this.address + offset2);
    }

    public final int getInt(long offset2) {
        return IO.getInt(this.address + offset2);
    }

    public final long getLong(long offset2) {
        return IO.getLong(this.address + offset2);
    }

    public final float getFloat(long offset2) {
        return IO.getFloat(this.address + offset2);
    }

    public final double getDouble(long offset2) {
        return IO.getDouble(this.address + offset2);
    }

    public final void putByte(long offset2, byte value2) {
        IO.putByte(this.address + offset2, value2);
    }

    public final void putShort(long offset2, short value2) {
        IO.putShort(this.address + offset2, value2);
    }

    public final void putInt(long offset2, int value2) {
        IO.putInt(this.address + offset2, value2);
    }

    public final void putLong(long offset2, long value2) {
        IO.putLong(this.address + offset2, value2);
    }

    public final void putFloat(long offset2, float value2) {
        IO.putFloat(this.address + offset2, value2);
    }

    public final void putDouble(long offset2, double value2) {
        IO.putDouble(this.address + offset2, value2);
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        IO.getByteArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, byte[] src, int off, int len) {
        IO.putByteArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        IO.getShortArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, short[] src, int off, int len) {
        IO.putShortArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        IO.getIntArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, int[] src, int off, int len) {
        IO.putIntArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        IO.getLongArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, long[] src, int off, int len) {
        IO.putLongArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        IO.getFloatArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, float[] src, int off, int len) {
        IO.putFloatArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        IO.getDoubleArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, double[] src, int off, int len) {
        IO.putDoubleArray(this.address + offset2, src, off, len);
    }

    public Pointer getPointer(long offset2) {
        long ptr = IO.getAddress(this.address + offset2);
        return ptr != 0L ? new JFFIPointer(ptr) : null;
    }

    public void putPointer(long offset2, Pointer value2) {
        if (value2 == null) {
            IO.putAddress(this.address + offset2, 0L);
        } else if (value2 instanceof JFFIPointer) {
            IO.putAddress(this.address + offset2, ((JFFIPointer)value2).address);
        }
        throw new IllegalArgumentException("Invalid Pointer");
    }

    public String getString(long offset2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int intValue() {
        return (int)this.address;
    }

    public long longValue() {
        return this.address;
    }

    public float floatValue() {
        return this.address;
    }

    public double doubleValue() {
        return this.address;
    }
}

