/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilterSupport;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricsFactory;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.core.stack.storage.impl.SnapshotImpl;
import org.netbeans.modules.dlight.core.stack.storage.impl.ThreadDumpImpl;
import org.netbeans.modules.dlight.core.stack.utils.FunctionNameUtils;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.Util;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStackDataStorage
implements ProxyDataStorage,
StackDataStorage,
ThreadDumpProvider {
    private SQLDataStorage sqlStorage;
    private final List<DataTableMetadata> tableMetadatas = new ArrayList<DataTableMetadata>();
    private final Map<String, PreparedStatement> stmtCache;
    private CppSymbolDemangler demangler = null;
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private final Map<CharSequence, Long> funcCache = new HashMap<CharSequence, Long>();
    private final Map<NodeCacheKey, Long> nodeCache = new HashMap<NodeCacheKey, Long>();
    private long funcIdSequence = 0L;
    private long nodeIdSequence = 0L;
    private final ExecutorThread executor = new ExecutorThread();
    private boolean isRunning = true;
    private static final int MAX_STRING_LENGTH = 16384;

    public SQLStackDataStorage() {
        this.executor.setPriority(1);
        this.executor.start();
        this.stmtCache = new ConcurrentHashMap<String, PreparedStatement>();
    }

    public final void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoDataStorage = serviceInfoDataStorage;
        CppSymbolDemanglerFactory cppSymbolDemanglerFactory = (CppSymbolDemanglerFactory)Lookup.getDefault().lookup(CppSymbolDemanglerFactory.class);
        this.demangler = cppSymbolDemanglerFactory != null ? cppSymbolDemanglerFactory.getForCurrentSession(serviceInfoDataStorage.getInfo()) : null;
    }

    public DataStorageType getBackendDataStorageType() {
        return DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    }

    public List<DataTableMetadata> getBackendTablesMetadata() {
        return Collections.emptyList();
    }

    public void attachTo(DataStorage dataStorage) {
        this.sqlStorage = (SQLDataStorage)dataStorage;
        try {
            this.initTables();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private final <T extends DataFilter> Collection<T> getDataFilters(List<DataFilter> list, Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (DataFilter dataFilter : list) {
            if (dataFilter.getClass() != clazz) continue;
            arrayList.add(clazz.cast(dataFilter));
        }
        return arrayList;
    }

    public boolean hasData(DataTableMetadata dataTableMetadata) {
        return dataTableMetadata.isProvidedBy(this.tableMetadatas);
    }

    public void addData(String string, List<DataRow> list) {
    }

    public Collection<DataStorageType> getStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType("stack"));
    }

    public boolean supportsType(DataStorageType dataStorageType) {
        return this.getStorageTypes().contains(dataStorageType);
    }

    public void createTables(List<DataTableMetadata> list) {
        this.tableMetadatas.addAll(list);
    }

    public boolean shutdown() {
        this.isRunning = false;
        this.funcCache.clear();
        this.nodeCache.clear();
        for (PreparedStatement preparedStatement : this.stmtCache.values()) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
        this.stmtCache.clear();
        return true;
    }

    private synchronized PreparedStatement getPreparedStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.stmtCache.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.sqlStorage.prepareStatement(string);
            this.stmtCache.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTables() throws SQLException, IOException {
        InputStream inputStream = SQLStackDataStorage.class.getClassLoader().getResourceAsStream("org/netbeans/modules/dlight/core/stack/resources/schema.sql");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("-- ")) continue;
                stringBuilder.append(string);
                if (!string.endsWith(";")) continue;
                String string2 = stringBuilder.toString();
                stringBuilder.setLength(0);
                String string3 = string2.substring(0, string2.length() - 1);
                this.sqlStorage.executeUpdate(string3);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    @Override
    public long putStack(List<CharSequence> list) {
        return this.putSample(list, -1L, -1L);
    }

    @Override
    public long putSample(List<CharSequence> list, long l, long l2) {
        long l3 = 0L;
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i = 0; i < list.size(); ++i) {
            boolean bl = i + 1 == list.size();
            CharSequence charSequence = list.get(i);
            long l4 = this.generateFuncId(charSequence);
            this.updateMetrics(l4, false, l, l2, !hashSet.contains(l4), bl);
            hashSet.add(l4);
            long l5 = this.generateNodeId(l3, l4, this.getOffset(charSequence));
            this.updateMetrics(l5, true, l, l2, true, bl);
            l3 = l5;
        }
        return l3;
    }

    public void flush() {
        try {
            this.executor.flush();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public List<FunctionMetric> getMetricsList() {
        return METRICS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3, boolean bl) {
        try {
            ArrayList<FunctionCallWithMetric> arrayList = new ArrayList<FunctionCallWithMetric>();
            ResultSet resultSet = this.sqlStorage.select(null, null, this.prepareCallersSelect(list));
            try {
                while (resultSet.next()) {
                    HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
                    hashMap.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(resultSet.getLong(4)));
                    hashMap.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(resultSet.getLong(5)));
                    String string = resultSet.getString(2);
                    arrayList.add(new FunctionCallImpl((Function)new FunctionImpl(resultSet.getInt(1), string, resultSet.getString(3)), hashMap));
                }
            }
            finally {
                resultSet.close();
            }
            this.demangle(arrayList);
            return arrayList;
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3, boolean bl) {
        try {
            ArrayList<FunctionCallWithMetric> arrayList = new ArrayList<FunctionCallWithMetric>();
            ResultSet resultSet = this.sqlStorage.select(null, null, this.prepareCalleesSelect(list));
            try {
                while (resultSet.next()) {
                    HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
                    hashMap.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(resultSet.getLong(4)));
                    hashMap.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(resultSet.getLong(5)));
                    String string = resultSet.getString(2);
                    arrayList.add(new FunctionCallImpl((Function)new FunctionImpl(resultSet.getInt(1), string, resultSet.getString(3)), hashMap));
                }
            }
            finally {
                resultSet.close();
            }
            this.demangle(arrayList);
            return arrayList;
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getHotSpotFunctions(FunctionMetric functionMetric, List<DataFilter> list, int n) {
        try {
            ArrayList<FunctionCallWithMetric> arrayList = new ArrayList<FunctionCallWithMetric>();
            TimeIntervalDataFilter timeIntervalDataFilter = (TimeIntervalDataFilter)Util.firstInstanceOf(TimeIntervalDataFilter.class, list);
            PreparedStatement preparedStatement = this.getPreparedStatement("SELECT Func.func_id, Func.func_name, Func.func_full_name, SUM(FuncMetricAggr.time_incl) AS time_incl, SUM(FuncMetricAggr.time_excl) AS time_excl FROM Func LEFT JOIN FuncMetricAggr ON Func.func_id = FuncMetricAggr.func_id " + (timeIntervalDataFilter != null ? "WHERE ? <= FuncMetricAggr.bucket_id AND FuncMetricAggr.bucket_id < ? " : "") + "GROUP BY Func.func_id, Func.func_name, Func.func_full_name " + "ORDER BY " + functionMetric.getMetricID() + " DESC");
            if (timeIntervalDataFilter != null) {
                preparedStatement.setLong(1, SQLStackDataStorage.timeToBucketId((Long)timeIntervalDataFilter.getInterval().getStart()));
                preparedStatement.setLong(2, SQLStackDataStorage.timeToBucketId((Long)timeIntervalDataFilter.getInterval().getEnd()));
            }
            preparedStatement.setMaxRows(n);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                while (resultSet.next()) {
                    HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
                    hashMap.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(resultSet.getLong(4)));
                    hashMap.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(resultSet.getLong(5)));
                    String string = resultSet.getString(2);
                    arrayList.add(new FunctionCallImpl((Function)new FunctionImpl(resultSet.getInt(1), string, resultSet.getString(3)), hashMap));
                }
            }
            finally {
                resultSet.close();
            }
            this.demangle(arrayList);
            return arrayList;
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getFunctionsList(DataTableMetadata dataTableMetadata, List<DataTableMetadata.Column> list, FunctionDatatableDescription functionDatatableDescription, List<DataFilter> list2) {
        try {
            Object object;
            Object object222;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object222 : list) {
                object = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetric.FunctionMetricConfiguration(object222.getColumnName(), object222.getColumnUName(), object222.getColumnClass()));
                arrayList.add(object);
            }
            String string = functionDatatableDescription.getNameColumn();
            object222 = functionDatatableDescription.getOffsetColumn();
            object = functionDatatableDescription.getUniqueColumnName();
            ArrayList<FunctionCallWithMetric> arrayList2 = new ArrayList<FunctionCallWithMetric>();
            Collection<TimeIntervalDataFilter> collection = this.getDataFilters(list2, TimeIntervalDataFilter.class);
            ArrayList arrayList3 = new ArrayList();
            DataTableMetadataFilterSupport dataTableMetadataFilterSupport = DataTableMetadataFilterSupport.getInstance();
            for (TimeIntervalDataFilter object3 : collection) {
                arrayList3.addAll(dataTableMetadataFilterSupport.createFilters(dataTableMetadata, object3));
            }
            ResultSet resultSet = this.sqlStorage.select(dataTableMetadata, arrayList3);
            try {
                while (resultSet.next()) {
                    HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
                    for (FunctionMetric functionMetric : arrayList) {
                        try {
                            resultSet.findColumn(functionMetric.getMetricID());
                            Object object2 = resultSet.getObject(functionMetric.getMetricID());
                            if (functionMetric.getMetricValueClass() == Time.class && object2 != null) {
                                object2 = new Time(Long.valueOf(object2 + "").longValue());
                            }
                            hashMap.put(functionMetric, object2);
                        }
                        catch (SQLException sQLException) {
                            Exceptions.printStackTrace((Throwable)sQLException);
                        }
                    }
                    String string2 = resultSet.getString(string);
                    arrayList2.add(new FunctionCallImpl(new FunctionImpl(resultSet.getInt((String)object), string2, string2), object222 != null ? resultSet.getLong((String)object222) : -1L, hashMap));
                }
            }
            finally {
                resultSet.close();
            }
            this.demangle(arrayList2);
            return arrayList2;
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return Collections.emptyList();
        }
    }

    private void updateMetrics(long l, boolean bl, long l2, long l3, boolean bl2, boolean bl3) {
        if (0L < l3) {
            UpdateMetrics updateMetrics = new UpdateMetrics();
            updateMetrics.objId = l;
            updateMetrics.bucketId = SQLStackDataStorage.timeToBucketId(l2);
            updateMetrics.funcOrNode = bl;
            if (bl2) {
                updateMetrics.cpuTimeInclusive = l3;
            }
            if (bl3) {
                updateMetrics.cpuTimeExclusive = l3;
            }
            this.executor.submitCommand(updateMetrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateNodeId(long l, long l2, long l3) {
        Map<NodeCacheKey, Long> map = this.nodeCache;
        synchronized (map) {
            NodeCacheKey nodeCacheKey = new NodeCacheKey(l, l2, l3);
            Long l4 = this.nodeCache.get(nodeCacheKey);
            if (l4 == null) {
                l4 = ++this.nodeIdSequence;
                AddNode addNode = new AddNode();
                addNode.id = l4;
                addNode.callerId = l;
                addNode.funcId = l2;
                addNode.offset = l3;
                this.executor.submitCommand(addNode);
                this.nodeCache.put(nodeCacheKey, l4);
            }
            return l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateFuncId(CharSequence charSequence) {
        String string = ((Object)charSequence).toString();
        int n = this.lastIndexOf(string, '+');
        if (0 <= n) {
            string = string.substring(0, n);
        }
        Map<CharSequence, Long> map = this.funcCache;
        synchronized (map) {
            Long l = this.funcCache.get(string);
            if (l == null) {
                l = ++this.funcIdSequence;
                AddFunction addFunction = new AddFunction();
                addFunction.id = l;
                addFunction.name = string;
                this.executor.submitCommand(addFunction);
                this.funcCache.put(string, l);
            }
            return l;
        }
    }

    private long getOffset(CharSequence charSequence) {
        int n = this.lastIndexOf(charSequence, '+');
        if (0 <= n) {
            try {
                return Long.parseLong(((Object)charSequence.subSequence(n + 3, charSequence.length())).toString(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private int lastIndexOf(CharSequence charSequence, char c) {
        for (int i = charSequence.length() - 1; 0 <= i; --i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private String prepareCallersSelect(List<FunctionCallWithMetric> list) throws SQLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        stringBuilder.append(" SELECT F.func_id, F.func_name, F.func_full_name, SUM(N.time_incl), SUM(N.time_excl) FROM Node AS N ");
        stringBuilder.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id ");
        stringBuilder.append(" INNER JOIN Node N1 ON N.node_id = N1.caller_id ");
        for (n = 1; n < n2; ++n) {
            stringBuilder.append(" INNER JOIN Node AS N").append(n + 1);
            stringBuilder.append(" ON N").append(n).append(".node_id = N").append(n + 1).append(".caller_id ");
        }
        stringBuilder.append(" WHERE ");
        for (n = 0; n < n2; ++n) {
            if (0 < n) {
                stringBuilder.append("AND ");
            }
            stringBuilder.append("N").append(n + 1).append(".func_id = ");
            stringBuilder.append(((FunctionImpl)list.get(n).getFunction()).getId());
        }
        stringBuilder.append(" GROUP BY F.func_id, F.func_name, F.func_full_name");
        return stringBuilder.toString();
    }

    private String prepareCalleesSelect(List<FunctionCallWithMetric> list) throws SQLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        stringBuilder.append("SELECT F.func_id, F.func_name, F.func_full_name, SUM(N.time_incl), SUM(N.time_excl) FROM Node AS N1 ");
        for (n = 1; n < n2; ++n) {
            stringBuilder.append(" INNER JOIN Node AS N").append(n + 1);
            stringBuilder.append(" ON N").append(n).append(".node_id = N").append(n + 1).append(".caller_id ");
        }
        stringBuilder.append(" INNER JOIN Node N ON N").append(n2).append(".node_id = N.caller_id ");
        stringBuilder.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id WHERE ");
        for (n = 0; n < n2; ++n) {
            if (0 < n) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(" N").append(n + 1).append(".func_id = ");
            stringBuilder.append(((FunctionImpl)list.get(n).getFunction()).getId());
        }
        stringBuilder.append(" GROUP BY F.func_id, F.func_name, F.func_full_name");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadSnapshot fetchSnapshot(int n, long l, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement("SELECT leaf_id, mstate FROM CallStack WHERE thread_id = ? AND time_stamp = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            if (resultSet.next()) {
                SnapshotImpl snapshotImpl = new SnapshotImpl(this, l, n, resultSet.getInt(1), ThreadState.MSAState.fromCode(resultSet.getInt(2), bl));
                return snapshotImpl;
            }
            ThreadSnapshot threadSnapshot = null;
            return threadSnapshot;
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadSnapshot> getThreadSnapshots(ThreadSnapshotQuery threadSnapshotQuery) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>(3);
        ThreadSnapshotQuery.ThreadFilter threadFilter = (ThreadSnapshotQuery.ThreadFilter)Util.firstInstanceOf(ThreadSnapshotQuery.ThreadFilter.class, threadSnapshotQuery.getFilters());
        if (threadFilter != null) {
            object2 = new StringBuilder("thread_id IN (");
            boolean bl = true;
            object = threadFilter.getThreadIds().iterator();
            while (object.hasNext()) {
                int n = object.next();
                if (bl) {
                    bl = false;
                } else {
                    ((StringBuilder)object2).append(',');
                }
                ((StringBuilder)object2).append(n);
            }
            ((StringBuilder)object2).append(')');
            arrayList.add(((StringBuilder)object2).toString());
        }
        if ((object2 = (ThreadSnapshotQuery.TimeFilter)Util.firstInstanceOf(ThreadSnapshotQuery.TimeFilter.class, threadSnapshotQuery.getFilters())) != null) {
            if (0L <= ((ThreadSnapshotQuery.TimeFilter)object2).getStartTime()) {
                arrayList.add(((ThreadSnapshotQuery.TimeFilter)object2).getStartTime() + " <= time_stamp");
            }
            if (0L <= ((ThreadSnapshotQuery.TimeFilter)object2).getEndTime()) {
                arrayList.add("time_stamp <= " + ((ThreadSnapshotQuery.TimeFilter)object2).getEndTime());
            }
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT thread_id, ");
        if (object2 != null) {
            switch (((ThreadSnapshotQuery.TimeFilter)object2).getMode()) {
                case FIRST: {
                    stringBuilder.append("MIN(time_stamp) ");
                    break;
                }
                case LAST: {
                    stringBuilder.append("MAX(time_stamp) ");
                    break;
                }
                default: {
                    stringBuilder.append("time_stamp ");
                    break;
                }
            }
        } else {
            stringBuilder.append("time_stamp ");
        }
        stringBuilder.append("FROM CallStack ");
        if (!arrayList.isEmpty()) {
            stringBuilder.append("WHERE ");
            boolean bl = true;
            for (String object3 : arrayList) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("AND ");
                }
                stringBuilder.append(object3).append(' ');
            }
        }
        if (object2 != null && ((ThreadSnapshotQuery.TimeFilter)object2).getMode() != ThreadSnapshotQuery.TimeFilter.Mode.ALL) {
            stringBuilder.append("GROUP BY thread_id");
        }
        try {
            object = new ArrayList();
            ResultSet resultSet = this.sqlStorage.select(null, null, stringBuilder.toString());
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        ThreadSnapshot threadSnapshot = this.fetchSnapshot(resultSet.getInt(1), resultSet.getLong(2), threadSnapshotQuery.isFullMSA());
                        if (threadSnapshot == null) continue;
                        object.add(threadSnapshot);
                    }
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            return object;
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return Collections.emptyList();
        }
    }

    @Override
    public ThreadDump getThreadDump(ThreadDumpQuery threadDumpQuery) {
        ThreadDump threadDump = this._getThreadDump(threadDumpQuery);
        if (threadDump == null) {
            return null;
        }
        ThreadDumpImpl threadDumpImpl = new ThreadDumpImpl(threadDump.getTimestamp());
        block0: for (Integer n : threadDumpQuery.getShowThreads()) {
            for (ThreadSnapshot threadSnapshot : threadDump.getThreadStates()) {
                if (threadSnapshot.getThreadInfo().getThreadId() != n.intValue()) continue;
                threadDumpImpl.addStack(threadSnapshot);
                continue block0;
            }
        }
        return threadDumpImpl;
    }

    private ThreadState.MSAState getTrueState(ThreadSnapshot threadSnapshot, ThreadDumpQuery threadDumpQuery) {
        ThreadState.MSAState mSAState = threadSnapshot.getState();
        return mSAState;
    }

    private ThreadDump _getThreadDump(ThreadDumpQuery threadDumpQuery) {
        ThreadSnapshot threadSnapshot2;
        Object object;
        long l = threadDumpQuery.getThreadState().getTimeStamp();
        long l2 = threadDumpQuery.getThreadState().getTimeStamp() + threadDumpQuery.getThreadState().getMSASamplePeriod() / 2L;
        long l3 = threadDumpQuery.getThreadState().getTimeStamp() + threadDumpQuery.getThreadState().getMSASamplePeriod();
        ThreadSnapshotQuery.TimeFilter timeFilter = new ThreadSnapshotQuery.TimeFilter(l, l3, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
        ThreadSnapshotQuery.ThreadFilter threadFilter = new ThreadSnapshotQuery.ThreadFilter(threadDumpQuery.getShowThreads());
        Collection collection = this.getThreadSnapshots(new ThreadSnapshotQuery(threadDumpQuery.isFullMode(), timeFilter, threadFilter));
        Object object2 = null;
        long l4 = -1L;
        for (HashSet<Integer> hashSet : collection) {
            if (threadDumpQuery.getThreadID() != (long)hashSet.getThreadInfo().getThreadId() || threadDumpQuery.getPreferredState() != this.getTrueState((ThreadSnapshot)((Object)hashSet), threadDumpQuery)) continue;
            object2 = hashSet;
            l4 = object2.getTimestamp();
            break;
        }
        if (object2 == null) {
            timeFilter = new ThreadSnapshotQuery.TimeFilter(0L, l2, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
            threadFilter = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)threadDumpQuery.getThreadID()));
            object = this.getThreadSnapshots(new ThreadSnapshotQuery(threadDumpQuery.isFullMode(), timeFilter, threadFilter));
            long l5 = -1L;
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                threadSnapshot2 = (ThreadSnapshot)iterator.next();
                l5 = threadSnapshot2.getTimestamp();
                if (threadDumpQuery.getThreadID() != (long)threadSnapshot2.getThreadInfo().getThreadId() || threadDumpQuery.getPreferredState() != this.getTrueState(threadSnapshot2, threadDumpQuery)) continue;
                object2 = threadSnapshot2;
                l4 = l2;
                break;
            }
            if (object2 == null && l5 > 0L) {
                timeFilter = new ThreadSnapshotQuery.TimeFilter(l5 - 1000000L, l5 + 1L, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
                threadFilter = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)threadDumpQuery.getThreadID()));
                object = this.getThreadSnapshots(new ThreadSnapshotQuery(threadDumpQuery.isFullMode(), timeFilter, threadFilter));
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    threadSnapshot2 = (ThreadSnapshot)iterator.next();
                    l5 = threadSnapshot2.getTimestamp();
                    if (threadDumpQuery.getThreadID() != (long)threadSnapshot2.getThreadInfo().getThreadId() || threadDumpQuery.getPreferredState() != this.getTrueState(threadSnapshot2, threadDumpQuery)) continue;
                    object2 = threadSnapshot2;
                    l4 = l2;
                    break;
                }
                if (object2 == null) {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        threadSnapshot2 = (ThreadSnapshot)iterator.next();
                        l5 = threadSnapshot2.getTimestamp();
                        if (threadDumpQuery.getThreadID() != (long)threadSnapshot2.getThreadInfo().getThreadId()) continue;
                        object2 = threadSnapshot2;
                        l4 = l2;
                        break;
                    }
                }
            }
        }
        if (object2 != null) {
            Object object32;
            HashSet<Integer> hashSet;
            object = new HashMap();
            ((HashMap)object).put(object2.getThreadInfo().getThreadId(), object2);
            for (Object object32 : collection) {
                if (object32.getThreadInfo().getThreadId() == object2.getThreadInfo().getThreadId()) continue;
                int n = object32.getThreadInfo().getThreadId();
                threadSnapshot2 = (ThreadSnapshot)((HashMap)object).get(n);
                if (threadSnapshot2 == null) {
                    ((HashMap)object).put(n, object32);
                    continue;
                }
                if (Math.abs(threadSnapshot2.getTimestamp() - l4) <= Math.abs(object32.getTimestamp() - l4)) continue;
                ((HashMap)object).put(n, object32);
            }
            hashSet = new HashSet<Integer>(threadDumpQuery.getShowThreads());
            object32 = new ThreadDumpImpl(l4);
            for (ThreadSnapshot threadSnapshot2 : ((HashMap)object).values()) {
                hashSet.remove(threadSnapshot2.getThreadInfo().getThreadId());
                ((ThreadDumpImpl)object32).addStack(threadSnapshot2);
            }
            if (!hashSet.isEmpty()) {
                timeFilter = new ThreadSnapshotQuery.TimeFilter(0L, l4, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
                threadFilter = new ThreadSnapshotQuery.ThreadFilter(hashSet);
                collection = this.getThreadSnapshots(new ThreadSnapshotQuery(threadDumpQuery.isFullMode(), timeFilter, threadFilter));
                for (ThreadSnapshot threadSnapshot2 : collection) {
                    ((ThreadDumpImpl)object32).addStack(threadSnapshot2);
                }
            }
            return object32;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<FunctionCall> getCallStack(long l) {
        ArrayList<FunctionCall> arrayList = new ArrayList<FunctionCall>();
        try {
            long l2 = l;
            while (0L < l2) {
                PreparedStatement preparedStatement = this.getPreparedStatement("SELECT Node.node_id, Node.caller_id, Node.func_id, Node.offset, Func.func_name FROM Node LEFT JOIN Func ON Node.func_id = Func.func_id WHERE node_id = ?");
                preparedStatement.setLong(1, l2);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString(5);
                        FunctionImpl functionImpl = new FunctionImpl(resultSet.getInt(3), string, string);
                        arrayList.add(new FunctionCallImpl(functionImpl, resultSet.getLong(4), new HashMap<FunctionMetric, Object>()));
                        l2 = resultSet.getInt(2);
                        continue;
                    }
                    break;
                }
                finally {
                    resultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        this.demangle(arrayList);
        Collections.reverse(arrayList);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void demangle(List<? extends FunctionCall> list) {
        if (this.demangler != null) {
            void var4_6;
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (FunctionCall functionCall : list) {
                arrayList.add(functionCall.getFunction().getName());
            }
            List list2 = this.demangler.demangle(arrayList);
            boolean i = false;
            while (var4_6 < list.size()) {
                ((FunctionImpl)list.get((int)var4_6).getFunction()).setName((String)list2.get((int)var4_6));
                ++var4_6;
            }
        }
    }

    private static long timeToBucketId(long l) {
        return l / 1000L / 1000L / 1000L;
    }

    private static String truncateString(String string) {
        if (string.length() <= 16384) {
            return string;
        }
        return string.substring(0, 16381) + "...";
    }

    private class ExecutorThread
    extends Thread {
        private static final int MAX_COMMANDS = 5000;
        private static final long SLEEP_INTERVAL = 200L;
        private final LinkedBlockingQueue<Object> queue;

        public ExecutorThread() {
            this.setName("DLIGTH: SQLStackStorage executor thread");
            this.queue = new LinkedBlockingQueue();
        }

        public void submitCommand(Object object) {
            this.queue.offer(object);
        }

        public synchronized void flush() throws InterruptedException {
            while (!this.queue.isEmpty()) {
                this.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                LinkedList linkedList = new LinkedList();
                while (SQLStackDataStorage.this.isRunning) {
                    ExecutorThread executorThread = this;
                    synchronized (executorThread) {
                        Object object;
                        HashMap hashMap3;
                        Object object22;
                        Object object3;
                        this.queue.drainTo(linkedList, 5000);
                        Iterator iterator = linkedList.iterator();
                        while (iterator.hasNext()) {
                            if (!SQLStackDataStorage.this.isRunning) {
                                return;
                            }
                            object3 = iterator.next();
                            if (!(object3 instanceof UpdateMetrics)) continue;
                            object22 = (UpdateMetrics)object3;
                            hashMap3 = ((UpdateMetrics)object22).funcOrNode ? hashMap2 : hashMap;
                            object = (UpdateMetrics)hashMap3.get(((UpdateMetrics)object22).objId);
                            if (object == null) {
                                hashMap3.put(((UpdateMetrics)object22).objId, object22);
                            } else {
                                ((UpdateMetrics)object).add((UpdateMetrics)object22);
                            }
                            iterator.remove();
                        }
                        iterator = linkedList.iterator();
                        while (iterator.hasNext()) {
                            if (!SQLStackDataStorage.this.isRunning) {
                                return;
                            }
                            object3 = iterator.next();
                            try {
                                if (object3 instanceof AddFunction) {
                                    object22 = (AddFunction)object3;
                                    hashMap3 = SQLStackDataStorage.this.getPreparedStatement("INSERT INTO Func (func_id, func_full_name, func_name) VALUES (?, ?, ?)");
                                    hashMap3.setLong(1, ((AddFunction)object22).id);
                                    hashMap3.setString(2, SQLStackDataStorage.truncateString(((Object)((AddFunction)object22).name).toString()));
                                    hashMap3.setString(3, SQLStackDataStorage.truncateString(((Object)((AddFunction)object22).name).toString()));
                                    hashMap3.executeUpdate();
                                    continue;
                                }
                                if (!(object3 instanceof AddNode)) continue;
                                object22 = (AddNode)object3;
                                hashMap3 = SQLStackDataStorage.this.getPreparedStatement("INSERT INTO Node (node_id, caller_id, func_id, offset, time_incl, time_excl) VALUES (?, ?, ?, ?, ?, ?)");
                                hashMap3.setLong(1, ((AddNode)object22).id);
                                hashMap3.setLong(2, ((AddNode)object22).callerId);
                                hashMap3.setLong(3, ((AddNode)object22).funcId);
                                hashMap3.setLong(4, ((AddNode)object22).offset);
                                object = (UpdateMetrics)hashMap2.remove(((AddNode)object22).id);
                                if (object == null) {
                                    hashMap3.setLong(5, 0L);
                                    hashMap3.setLong(6, 0L);
                                } else {
                                    hashMap3.setLong(5, ((UpdateMetrics)object).cpuTimeInclusive);
                                    hashMap3.setLong(6, ((UpdateMetrics)object).cpuTimeExclusive);
                                }
                                hashMap3.executeUpdate();
                            }
                            catch (SQLException sQLException) {
                                Exceptions.printStackTrace((Throwable)sQLException);
                            }
                        }
                        linkedList.clear();
                        for (Object object22 : hashMap.values()) {
                            try {
                                hashMap3 = SQLStackDataStorage.this.getPreparedStatement("SELECT func_id, bucket_id, time_incl, time_excl FROM FuncMetricAggr WHERE func_id = ? AND bucket_id = ? FOR UPDATE");
                                hashMap3.setLong(1, ((UpdateMetrics)object22).objId);
                                hashMap3.setLong(2, ((UpdateMetrics)object22).bucketId);
                                object = hashMap3.executeQuery();
                                try {
                                    if (object.next()) {
                                        object.updateLong(3, object.getLong(3) + ((UpdateMetrics)object22).cpuTimeInclusive);
                                        object.updateLong(4, object.getLong(4) + ((UpdateMetrics)object22).cpuTimeExclusive);
                                        object.updateRow();
                                        continue;
                                    }
                                    object.moveToInsertRow();
                                    object.updateLong(1, ((UpdateMetrics)object22).objId);
                                    object.updateLong(2, ((UpdateMetrics)object22).bucketId);
                                    object.updateLong(3, ((UpdateMetrics)object22).cpuTimeInclusive);
                                    object.updateLong(4, ((UpdateMetrics)object22).cpuTimeExclusive);
                                    object.insertRow();
                                }
                                finally {
                                    object.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                Exceptions.printStackTrace((Throwable)sQLException);
                            }
                        }
                        hashMap.clear();
                        for (Object object22 : hashMap2.values()) {
                            try {
                                hashMap3 = SQLStackDataStorage.this.getPreparedStatement("UPDATE Node SET time_incl = time_incl + ?, time_excl = time_excl + ? WHERE node_id = ?");
                                hashMap3.setLong(1, ((UpdateMetrics)object22).cpuTimeInclusive);
                                hashMap3.setLong(2, ((UpdateMetrics)object22).cpuTimeExclusive);
                                hashMap3.setLong(3, ((UpdateMetrics)object22).objId);
                                hashMap3.executeUpdate();
                            }
                            catch (SQLException sQLException) {
                                Exceptions.printStackTrace((Throwable)sQLException);
                            }
                        }
                        hashMap2.clear();
                        this.notifyAll();
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private static class UpdateMetrics {
        public boolean funcOrNode;
        public long objId;
        public long bucketId;
        public long cpuTimeInclusive;
        public long cpuTimeExclusive;

        private UpdateMetrics() {
        }

        public void add(UpdateMetrics updateMetrics) {
            this.cpuTimeInclusive += updateMetrics.cpuTimeInclusive;
            this.cpuTimeExclusive += updateMetrics.cpuTimeExclusive;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.funcOrNode ? "func" : "node");
            stringBuilder.append(" id=").append(this.objId);
            stringBuilder.append(": time_incl+=").append(this.cpuTimeInclusive);
            stringBuilder.append(", time_excl+=").append(this.cpuTimeExclusive);
            return stringBuilder.toString();
        }
    }

    private static class AddNode {
        public long id;
        public long callerId;
        public long funcId;
        public long offset;

        private AddNode() {
        }
    }

    private static class AddFunction {
        public long id;
        public CharSequence name;

        private AddFunction() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FunctionCallImpl
    extends FunctionCallWithMetric {
        private final Map<FunctionMetric, Object> metrics;

        FunctionCallImpl(Function function, long l, Map<FunctionMetric, Object> map) {
            super(function, l);
            this.metrics = map;
        }

        FunctionCallImpl(Function function, Map<FunctionMetric, Object> map) {
            this(function, 0L, map);
        }

        @Override
        public String getDisplayedName() {
            return this.getFunction().getName() + (this.hasOffset() ? "+0x" + Long.toHexString(this.getOffset()) : "");
        }

        @Override
        public Object getMetricValue(FunctionMetric functionMetric) {
            return this.metrics.get(functionMetric);
        }

        @Override
        public Object getMetricValue(String string) {
            for (FunctionMetric functionMetric : this.metrics.keySet()) {
                if (!functionMetric.getMetricID().equals(string)) continue;
                return this.metrics.get(functionMetric);
            }
            return null;
        }

        @Override
        public boolean hasMetric(String string) {
            for (FunctionMetric functionMetric : this.metrics.keySet()) {
                if (!functionMetric.getMetricID().equals(string)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FunctionCall{ function=").append(this.getFunction());
            stringBuilder.append(", metrics=").append(this.metrics).append(" }");
            return stringBuilder.toString();
        }
    }

    protected static class FunctionImpl
    implements Function {
        private final long id;
        private String name;
        private final String quilifiedName;

        public FunctionImpl(long l, String string, String string2) {
            this.id = l;
            this.name = string;
            this.quilifiedName = string2;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String string) {
            this.name = string;
        }

        public String getSignature() {
            return this.quilifiedName;
        }

        public String toString() {
            return this.name;
        }

        public String getQuilifiedName() {
            return FunctionNameUtils.getFunctionQName(this.name);
        }
    }

    private static class NodeCacheKey {
        private final long callerId;
        private final long funcId;
        private final long offset;

        public NodeCacheKey(long l, long l2, long l3) {
            this.callerId = l;
            this.funcId = l2;
            this.offset = l3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NodeCacheKey)) {
                return false;
            }
            NodeCacheKey nodeCacheKey = (NodeCacheKey)object;
            return this.callerId == nodeCacheKey.callerId && this.funcId == nodeCacheKey.funcId && this.offset == nodeCacheKey.offset;
        }

        public int hashCode() {
            return 13 * ((int)(this.callerId >> 32) | (int)this.callerId) + 17 * ((int)(this.funcId >> 32) | (int)this.funcId) + ((int)(this.offset >> 32) | (int)this.offset);
        }
    }
}

