/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy.synchronous;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemsModel;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;

public class SynchronousXYItemsModel
extends ItemsModel.Abstract {
    private final ArrayList<SynchronousXYItem> items = new ArrayList();
    private final Timeline timeline;

    public SynchronousXYItemsModel(Timeline timeline) {
        this.timeline = timeline;
    }

    public SynchronousXYItemsModel(Timeline timeline, SynchronousXYItem[] synchronousXYItemArray) {
        this(timeline);
        if (synchronousXYItemArray == null) {
            throw new IllegalArgumentException("Items cannot be null");
        }
        if (synchronousXYItemArray.length == 0) {
            throw new IllegalArgumentException("Items cannot be empty");
        }
        this.addItems(synchronousXYItemArray);
    }

    public void addItems(SynchronousXYItem[] synchronousXYItemArray) {
        for (int i = 0; i < synchronousXYItemArray.length; ++i) {
            synchronousXYItemArray[i].setTimeline(this.timeline);
            this.items.add(synchronousXYItemArray[i]);
        }
        this.fireItemsAdded(Arrays.asList((ChartItem[])synchronousXYItemArray));
        if (this.timeline.getTimestampsCount() > 0) {
            this.valuesAdded();
        }
    }

    public void removeItems(SynchronousXYItem[] synchronousXYItemArray) {
        for (SynchronousXYItem synchronousXYItem : synchronousXYItemArray) {
            this.items.remove(synchronousXYItem);
        }
        this.fireItemsRemoved(Arrays.asList((ChartItem[])synchronousXYItemArray));
    }

    public final void valuesAdded() {
        long l;
        ArrayList<ChartItemChange> arrayList = new ArrayList<ChartItemChange>(this.items.size());
        for (SynchronousXYItem synchronousXYItem : this.items) {
            arrayList.add(synchronousXYItem.valuesChanged());
        }
        this.fireItemsChanged(arrayList);
        int n = this.timeline.getTimestampsCount() - 1;
        long l2 = this.timeline.getTimestamp(n);
        long l3 = l = n == 0 ? -1L : this.timeline.getTimestamp(n - 1);
        if (l != -1L && l >= l2) {
            System.err.println("WARNING [" + SynchronousXYItemsModel.class.getName() + "]: ProfilerXYItemsModel: new timestamp " + l2 + " not greater than previous " + l + ", skipping the values.");
        }
    }

    public final void valuesReset() {
        ArrayList<ChartItemChange> arrayList = new ArrayList<ChartItemChange>(this.items.size());
        for (SynchronousXYItem synchronousXYItem : this.items) {
            arrayList.add(synchronousXYItem.valuesChanged());
        }
        this.fireItemsChanged(arrayList);
    }

    public final Timeline getTimeline() {
        return this.timeline;
    }

    public final int getItemsCount() {
        return this.items.size();
    }

    public final SynchronousXYItem getItem(int n) {
        return this.items.get(n);
    }
}

