/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.nodes;

import java.awt.Point;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.OutlineOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class OutlineNode {
    private OutlineOperator _outline;
    private TreePath _treePath;

    public OutlineNode(OutlineOperator outlineOperator, TreePath treePath) {
        if (outlineOperator == null) {
            throw new IllegalArgumentException("OutlineOperator argument cannot be null.");
        }
        if (treePath == null) {
            throw new IllegalArgumentException("TreePath argument cannot be null.");
        }
        this._outline = outlineOperator;
        this._treePath = treePath;
    }

    public OutlineNode(OutlineNode outlineNode, String string) {
        this._outline = outlineNode.getOutline();
        this._treePath = this.getOutline().findPath(outlineNode.getTreePath(), string);
    }

    public OutlineNode(OutlineOperator outlineOperator, String string) {
        this._outline = outlineOperator;
        this._treePath = this.getOutline().findPath(string);
    }

    public OutlineOperator getOutline() {
        return this._outline;
    }

    public TreePath getTreePath() {
        return this._treePath;
    }

    public JPopupMenuOperator callPopup() {
        Point point = this.getOutline().getLocationForPath(this.getTreePath());
        return new JPopupMenuOperator(this.getOutline().callPopupOnCell(point.y, point.x));
    }

    public void expand() {
        this.getOutline().expandPath(this.getTreePath());
        this.getOutline().waitExpanded(this.getTreePath());
    }

    public void select() {
        this.getOutline().selectPath(this.getTreePath());
    }

    public boolean isLeaf() {
        Object object = this.getTreePath().getLastPathComponent();
        return this.getOutline().getOutline().getOutlineModel().getChildCount(object) < 1;
    }

    public void performMenuAction(String string) {
        new Action(string, null).performMenu(this);
    }

    public void performPopupAction(String string) {
        new Action(null, string).performPopup(this);
    }

    public void performAPIAction(String string) {
        new Action(null, null, string).performAPI(this);
    }

    public void performMenuActionNoBlock(String string) {
        new ActionNoBlock(string, null).performMenu(this);
    }

    public void performPopupActionNoBlock(String string) {
        new ActionNoBlock(null, string).performPopup(this);
    }

    public void performAPIActionNoBlock(String string) {
        new ActionNoBlock(null, null, string).performAPI(this);
    }
}

