/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.util.MissingResourceException;
import java.util.jar.Manifest;
import org.netbeans.jemmy.JemmyProperties;

public class JellyVersion {
    private static boolean jemmyVersionChecked = false;

    public static void main(String[] stringArray) {
        System.out.println("Jellytools version : " + JellyVersion.getVersion() + " (Build " + JellyVersion.getBuild() + " on " + JellyVersion.getIDEVersion() + " and Jemmy " + JellyVersion.getJemmyVersion() + ")");
    }

    public static synchronized void checkJemmyVersion() {
        if (!jemmyVersionChecked) {
            jemmyVersionChecked = true;
            String string = null;
            try {
                string = JemmyProperties.getVersion();
            }
            catch (Exception exception) {
                return;
            }
            String string2 = JellyVersion.getJemmyVersion();
            if (string.compareTo(string2) < 0) {
                String string3 = "\n##############################################\n";
                String string4 = "Need to upgrade Jemmy to version: " + string2 + "\nCurrent Jemmy version: " + string;
                JemmyProperties.getCurrentOutput().printError(string3 + string4 + string3);
            }
        }
    }

    private static Manifest getManifest() {
        String string = "org/netbeans/jellytools/version_info";
        try {
            return new Manifest(new JellyVersion().getClass().getClassLoader().getResourceAsStream(string));
        }
        catch (Exception exception) {
            throw new MissingResourceException("Version info not available.", null, null);
        }
    }

    public static String getMajorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-MajorVersion");
    }

    public static String getMinorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-MinorVersion");
    }

    public static String getVersion() {
        return JellyVersion.getMajorVersion() + "." + JellyVersion.getMinorVersion();
    }

    public static String getBuild() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-Build");
    }

    public static String getIDEVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-IDEVersion");
    }

    public static String getJemmyMajorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jemmy-MajorVersion");
    }

    public static String getJemmyMinorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jemmy-MinorVersion");
    }

    public static String getJemmyVersion() {
        return JellyVersion.getJemmyMajorVersion() + "." + JellyVersion.getJemmyMinorVersion();
    }
}

