/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.api.J2SEPlatformCreator;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.Importer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPlatformSupport {
    private List<JavaPlatform> justCreatedPlatforms = new ArrayList<JavaPlatform>();
    private File defaultNetBeansPlatformFile = null;
    private static JavaPlatformSupport inst;

    private JavaPlatformSupport() {
        JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        Collection collection = javaPlatform.getInstallFolders();
        if (!collection.isEmpty()) {
            this.defaultNetBeansPlatformFile = FileUtil.toFile((FileObject)((FileObject)collection.toArray()[0]));
        }
    }

    public static synchronized JavaPlatformSupport getJavaPlatformSupport() {
        if (inst == null) {
            inst = new JavaPlatformSupport();
        }
        return inst;
    }

    private List<JavaPlatform> getAllPlatforms() {
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>(this.justCreatedPlatforms);
        arrayList.addAll(Arrays.asList(JavaPlatformManager.getDefault().getInstalledPlatforms()));
        return arrayList;
    }

    public JavaPlatform getJavaPlatform(EclipseProject eclipseProject, List<String> list) {
        JavaPlatform[] javaPlatformArray;
        String string = eclipseProject.getJDKDirectory();
        if (string == null) {
            return null;
        }
        File file = FileUtil.normalizeFile((File)new File(string));
        if (this.defaultNetBeansPlatformFile != null && file.equals(this.defaultNetBeansPlatformFile)) {
            return null;
        }
        JavaPlatform javaPlatform = null;
        for (JavaPlatform javaPlatform2 : this.getAllPlatforms()) {
            File file2;
            javaPlatformArray = javaPlatform2.getInstallFolders();
            if (javaPlatformArray.isEmpty() || !(file2 = FileUtil.toFile((FileObject)((FileObject)javaPlatformArray.iterator().next()))).equals(file)) continue;
            javaPlatform = javaPlatform2;
            break;
        }
        if (javaPlatform != null) {
            return javaPlatform;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                JavaPlatform javaPlatform2;
                javaPlatform2 = J2SEPlatformCreator.createJ2SEPlatform((FileObject)fileObject);
                javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(javaPlatform2.getDisplayName(), null);
                if (javaPlatformArray.length > 0) {
                    return javaPlatformArray[0];
                }
                if (javaPlatform2.findTool("javac") != null) {
                    this.justCreatedPlatforms.add(javaPlatform2);
                    return javaPlatform2;
                }
                list.add(NbBundle.getMessage(Importer.class, (String)"MSG_JRECannotBeUsed", (Object)eclipseProject.getName()));
                return null;
            }
            catch (IOException iOException) {
                list.add("Cannot create J2SE platform for '" + file + "'. " + "Default platform will be used instead.");
                return null;
            }
        }
        list.add(NbBundle.getMessage(Importer.class, (String)"MSG_JDKDoesnExistUseDefault", (Object)eclipseProject.getName(), (Object)file.getAbsolutePath()));
        return null;
    }
}

