/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringUtilities {
    private static final String SPRING_CLASS_NAME = "org.springframework.core.SpringVersion";
    private static final String JSTL_CLASS_NAME = "javax.servlet.jsp.jstl.core.Config";
    private static final String SPRING_WEBMVC_CLASS_NAME = "org.springframework.web.servlet.DispatcherServlet";

    private SpringUtilities() {
    }

    public static Library findSpringLibrary() {
        return SpringUtilities.getLibrary(SPRING_CLASS_NAME);
    }

    public static Library findJSTLibrary() {
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!library.getName().startsWith("jstl")) continue;
            return library;
        }
        return SpringUtilities.getLibrary(JSTL_CLASS_NAME);
    }

    public static Library findSpringWebMVCLibrary() {
        return SpringUtilities.getLibrary(SPRING_WEBMVC_CLASS_NAME);
    }

    public static boolean isSpringLibrary(Library library) {
        return SpringUtilities.containsClass(library, SPRING_CLASS_NAME);
    }

    public static boolean containsSpring(ClassPath classPath) {
        return SpringUtilities.containsClass(classPath, SPRING_CLASS_NAME);
    }

    private static Library getLibrary(String string) {
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!SpringUtilities.containsClass(library, string)) continue;
            return library;
        }
        return null;
    }

    private static boolean containsClass(Library library, String string) {
        List list = library.getContent("classpath");
        return SpringUtilities.containsClass(SpringUtilities.createClassPath(list), string);
    }

    private static boolean containsClass(ClassPath classPath, String string) {
        String string2 = string.replace('.', '/') + ".class";
        return classPath.findResource(string2) != null;
    }

    private static ClassPath createClassPath(List<URL> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : list) {
            if (FileUtil.getArchiveFile((URL)uRL) == null) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            }
            arrayList.add(uRL);
        }
        return ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
    }
}

