/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.licensing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.netbeans.modules.mobility.licensing.LicensePanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class AcceptLicense
extends ModuleInstall {
    private static JDialog d;
    private static String command;

    public void validate() throws IllegalStateException {
        FileObject fileObject = FileUtil.getConfigFile((String)"LICENSE.txt");
        if (fileObject == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = fileObject.getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new IllegalStateException(fileStateInvalidException);
        }
        LicensePanel licensePanel = new LicensePanel(uRL);
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)AcceptLicense.class);
        String string = resourceBundle.getString("MSG_LicenseYesButton");
        String string2 = resourceBundle.getString("MSG_LicenseNoButton");
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        AcceptLicense.setLocalizedText(jButton, string);
        AcceptLicense.setLocalizedText(jButton2, string2);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                command = actionEvent.getActionCommand();
                d.setVisible(false);
                d = null;
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton.setActionCommand("yes");
        jButton2.setActionCommand("no");
        jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_AcceptButton"));
        jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_AcceptButton"));
        jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_RejectButton"));
        jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_RejectButton"));
        Dimension dimension = jButton.getPreferredSize();
        Dimension dimension2 = jButton2.getPreferredSize();
        int n = Math.max(jButton.getPreferredSize().width, jButton2.getPreferredSize().width);
        int n2 = Math.max(jButton.getPreferredSize().height, jButton2.getPreferredSize().height);
        jButton.setPreferredSize(new Dimension(n, n2));
        jButton2.setPreferredSize(new Dimension(n, n2));
        d = new JDialog((Frame)null, resourceBundle.getString("MSG_LicenseDlgTitle"), true);
        d.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_LicenseDlg"));
        d.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LicenseDlg"));
        d.getContentPane().add((Component)licensePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(17, 12, 11, 11));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        d.getContentPane().add((Component)jPanel, "South");
        d.setSize(new Dimension(600, 600));
        d.setDefaultCloseOperation(2);
        d.setModal(true);
        d.setResizable(true);
        d.setLocationRelativeTo(null);
        d.setVisible(true);
        if ("yes".equals(command)) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        } else {
            throw new IllegalStateException(resourceBundle.getString("MSG_LicenseRejected"));
        }
    }

    private static void setLocalizedText(AbstractButton abstractButton, String string) {
        if (string == null) {
            abstractButton.setText(null);
            return;
        }
        int n = AcceptLicense.findMnemonicAmpersand(string);
        if (n < 0) {
            abstractButton.setText(string);
            abstractButton.setMnemonic(0);
        } else {
            abstractButton.setText(string.substring(0, n) + string.substring(n + 1));
            if (Utilities.getOperatingSystem() == 4096) {
                return;
            }
            char c = string.charAt(n + 1);
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static int findMnemonicAmpersand(String string) {
        int n = -1;
        do {
            if ((n = string.indexOf(38, n + 1)) < 0 || n + 1 >= string.length() || string.charAt(n + 1) == ' ' || string.charAt(n + 1) == '\'' && n > 0 && string.charAt(n - 1) == '\'') continue;
            return n;
        } while (n >= 0);
        return -1;
    }
}

