/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmAbstractHyperlinkProvider
implements HyperlinkProviderExt {
    private TokenItem<CppTokenId> jumpToken = null;
    private Cancellable hyperLinkTask;

    protected CsmAbstractHyperlinkProvider() {
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.setMagicCaretPosition(null);
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION, HyperlinkType.ALT_HYPERLINK);
    }

    protected abstract void performAction(Document var1, JTextComponent var2, int var3, HyperlinkType var4);

    public void performClickAction(Document document, final int n, final HyperlinkType hyperlinkType) {
        if (document == null) {
            return;
        }
        final Document document2 = document;
        final JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null || jTextComponent.getDocument() != document2) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (hyperlinkType == HyperlinkType.ALT_HYPERLINK) {
                    CsmMacroExpansion.showMacroExpansionView((Document)document2, (int)n);
                } else {
                    CsmAbstractHyperlinkProvider.this.performAction(document2, jTextComponent, n, hyperlinkType);
                }
            }
        };
        if (this.hyperLinkTask != null) {
            this.hyperLinkTask.cancel();
        }
        this.hyperLinkTask = CsmModelAccessor.getModel().enqueue(runnable, (CharSequence)"Following hyperlink");
    }

    public boolean isHyperlinkPoint(Document document, int n, HyperlinkType hyperlinkType) {
        TokenItem<CppTokenId> tokenItem = CsmAbstractHyperlinkProvider.getToken(document, n);
        return this.isValidToken(tokenItem, hyperlinkType);
    }

    protected abstract boolean isValidToken(TokenItem<CppTokenId> var1, HyperlinkType var2);

    public int[] getHyperlinkSpan(Document document, int n, HyperlinkType hyperlinkType) {
        int[] nArray;
        TokenItem<CppTokenId> tokenItem = CsmAbstractHyperlinkProvider.getToken(document, n);
        if (hyperlinkType == HyperlinkType.ALT_HYPERLINK && (nArray = CsmMacroExpansion.getMacroExpansionSpan((Document)document, (int)n, (boolean)false)) != null && nArray[0] != nArray[1]) {
            return nArray;
        }
        if (this.isValidToken(tokenItem, hyperlinkType)) {
            this.jumpToken = tokenItem;
            return new int[]{tokenItem.offset(), tokenItem.offset() + tokenItem.length()};
        }
        return null;
    }

    protected boolean preJump(Document document, JTextComponent jTextComponent, int n, String string, HyperlinkType hyperlinkType) {
        if (document == null || jTextComponent == null || n < 0 || n > document.getLength()) {
            return false;
        }
        this.jumpToken = CsmAbstractHyperlinkProvider.getToken(document, n);
        if (!this.isValidToken(this.jumpToken, hyperlinkType)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder(this.jumpToken.text());
        String string2 = stringBuilder.toString();
        String string3 = NbBundle.getBundle(CsmCompletionUtils.class).getString(string);
        string3 = MessageFormat.format(string3, string2);
        StatusDisplayer.getDefault().setStatusText(string3);
        return true;
    }

    protected boolean postJump(CsmOffsetable csmOffsetable, String string, String string2) {
        if (this.jumpToken == null) {
            return false;
        }
        if (csmOffsetable == null || !CsmUtilities.openSource((CsmObject)csmOffsetable)) {
            CharSequence charSequence;
            String string3;
            String string4;
            Toolkit.getDefaultToolkit().beep();
            String string5 = CsmUtilities.getElementJumpName((CsmObject)csmOffsetable);
            if (string5 != null && string5.length() > 0) {
                string4 = "goto_source_source_not_found";
                string3 = string5;
            } else {
                string4 = "cannot-open-csm-element";
                charSequence = new StringBuilder(this.jumpToken.text());
                string3 = charSequence.toString();
            }
            charSequence = NbBundle.getBundle(CsmCompletionUtils.class).getString(string4);
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format((String)charSequence, string3));
            return false;
        }
        return true;
    }

    protected TokenItem<CppTokenId> getJumpToken() {
        return this.jumpToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TokenItem<CppTokenId> getToken(Document document, int n) {
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            TokenItem tokenItem = CndTokenUtilities.getTokenCheckPrev((Document)document, (int)n);
            return tokenItem;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    public String getTooltipText(Document document, int n, HyperlinkType hyperlinkType) {
        Object object;
        if (document == null || n < 0 || n > document.getLength()) {
            return null;
        }
        if (hyperlinkType == HyperlinkType.ALT_HYPERLINK && (object = (Object)CsmMacroExpansion.getMacroExpansionSpan((Document)document, (int)n, (boolean)true)) != null && object[0] != object[1]) {
            return this.getMacroExpandedText(document, (int)object[0], (int)object[1]);
        }
        object = this.jumpToken;
        if (object == null || object.offset() > n || object.offset() + object.length() < n) {
            object = CsmAbstractHyperlinkProvider.getToken(document, n);
        }
        if (!this.isValidToken((TokenItem<CppTokenId>)object, hyperlinkType)) {
            return null;
        }
        return this.getTooltipText(document, (TokenItem<CppTokenId>)object, n, hyperlinkType);
    }

    protected abstract String getTooltipText(Document var1, TokenItem<CppTokenId> var2, int var3, HyperlinkType var4);

    private String getMacroExpandedText(final Document document, final int n, final int n2) {
        String string = CsmMacroExpansion.expand((Document)document, (int)n, (int)n2);
        final StringBuilder stringBuilder = new StringBuilder();
        document.render(new Runnable(){

            public void run() {
                try {
                    stringBuilder.append(document.getText(n, n2 - n));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return NbBundle.getMessage(CsmAbstractHyperlinkProvider.class, (String)"MacroExpansion", (Object)CsmDisplayUtilities.htmlize((CharSequence)stringBuilder), (Object)CsmDisplayUtilities.htmlize((CharSequence)string));
    }

    protected final CharSequence getAlternativeHyperlinkTip(Document document, String string, CharSequence charSequence) {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)NbEditorUtilities.getMimeType((Document)document)).lookup(Preferences.class);
        int n = preferences.getInt("alt-hyperlink-activation-modifiers", 640);
        return NbBundle.getMessage(CsmAbstractHyperlinkProvider.class, (String)string, (Object)charSequence, (Object)InputEvent.getModifiersExText(n));
    }
}

