/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteCommand
extends Command {
    private static final char SEP_CHAR = '=';
    private static final int MAX_TYPE_SIZE = RemoteCommand.getFileTypeLabelMaxSize() + 2;
    private static final Color COLOR_SUCCESS = Color.GREEN.darker().darker();
    private static final Color COLOR_IGNORE = Color.ORANGE.darker();
    private static final RequestProcessor RP = new RequestProcessor("Remote connection", 1);
    private static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        public void run() {
            Runnable runnable = (Runnable)RUNNABLES.poll();
            while (runnable != null) {
                runnable.run();
                runnable = (Runnable)RUNNABLES.poll();
            }
        }
    }, true);

    public RemoteCommand(PhpProject phpProject) {
        super(phpProject);
    }

    @Override
    public boolean isFileSensitive() {
        return true;
    }

    @Override
    public final void invokeAction(Lookup lookup) {
        if (!this.getConfigAction().isValid(false)) {
            return;
        }
        RUNNABLES.add(this.getContextRunnable(lookup));
        TASK.schedule(0);
    }

    @Override
    public final boolean isActionEnabled(Lookup lookup) {
        return this.isRemoteConfigSelected() && TASK.isFinished();
    }

    protected abstract Runnable getContextRunnable(Lookup var1);

    @Override
    public final boolean asyncCallRequired() {
        return false;
    }

    public static InputOutput getRemoteLog(String string) {
        return RemoteCommand.getRemoteLog(string, true);
    }

    public static InputOutput getRemoteLog(String string, boolean bl) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(Command.class, (String)"LBL_RemoteLog", (Object)string), false);
        if (bl) {
            inputOutput.select();
        }
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return inputOutput;
    }

    protected RemoteClient getRemoteClient(InputOutput inputOutput, RemoteClient.OperationMonitor operationMonitor) {
        return new RemoteClient(this.getRemoteConfiguration(), new RemoteClient.AdvancedProperties().setInputOutput(inputOutput).setOperationMonitor(operationMonitor).setAdditionalInitialSubdirectory(this.getRemoteDirectory()).setPreservePermissions(ProjectPropertiesSupport.areRemotePermissionsPreserved(this.getProject())).setUploadDirectly(ProjectPropertiesSupport.isRemoteUploadDirectly(this.getProject())).setPhpVisibilityQuery(PhpVisibilityQuery.forProject(this.getProject())));
    }

    protected RemoteConfiguration getRemoteConfiguration() {
        String string = this.getRemoteConfigurationName();
        assert (string != null && string.length() > 0) : "Remote configuration name must be selected";
        return RemoteConnections.get().remoteConfigurationForName(string);
    }

    protected boolean isRemoteConfigSelected() {
        PhpProjectProperties.RunAsType runAsType = ProjectPropertiesSupport.getRunAs(this.getProject());
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)runAsType);
    }

    protected String getRemoteConfigurationName() {
        return ProjectPropertiesSupport.getRemoteConnection(this.getProject());
    }

    protected String getRemoteDirectory() {
        return ProjectPropertiesSupport.getRemoteDirectory(this.getProject());
    }

    public static void processRemoteException(RemoteException remoteException) {
        String string = NbBundle.getMessage(Command.class, (String)"LBL_RemoteError");
        StringBuilder stringBuilder = new StringBuilder(remoteException.getMessage());
        String string2 = remoteException.getRemoteServerAnswer();
        Throwable throwable = remoteException.getCause();
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(NbBundle.getMessage(Command.class, (String)"MSG_RemoteErrorReason", (Object)string2));
        } else if (throwable != null) {
            stringBuilder.append(NbBundle.getMessage(Command.class, (String)"MSG_RemoteErrorReason", (Object)throwable.getMessage()));
        }
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)stringBuilder.toString(), string, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    protected static void processTransferInfo(TransferInfo transferInfo, InputOutput inputOutput) {
        int n;
        OutputWriter outputWriter = inputOutput.getOut();
        OutputWriter outputWriter2 = inputOutput.getErr();
        outputWriter.println();
        outputWriter.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSummary"));
        StringBuilder stringBuilder = new StringBuilder(20);
        for (n = 0; n < stringBuilder.capacity(); ++n) {
            stringBuilder.append('=');
        }
        outputWriter.println(stringBuilder.toString());
        n = RemoteCommand.getRelativePathMaxSize(transferInfo);
        long l = 0L;
        int n2 = 0;
        if (transferInfo.hasAnyTransfered()) {
            RemoteCommand.printSuccess(inputOutput, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSucceeded"));
            for (TransferFile object : transferInfo.getTransfered()) {
                RemoteCommand.printSuccess(inputOutput, n, object);
                if (!object.isFile()) continue;
                l += object.getSize();
                ++n2;
            }
        }
        if (transferInfo.hasAnyFailed()) {
            outputWriter2.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteFailed"));
            for (Map.Entry entry : transferInfo.getFailed().entrySet()) {
                RemoteCommand.printError(outputWriter2, n, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyPartiallyFailed()) {
            outputWriter2.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemotePartiallyFailed"));
            for (Map.Entry entry : transferInfo.getPartiallyFailed().entrySet()) {
                RemoteCommand.printError(outputWriter2, n, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyIgnored()) {
            RemoteCommand.printIgnore(inputOutput, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteIgnored"));
            for (Map.Entry entry : transferInfo.getIgnored().entrySet()) {
                RemoteCommand.printIgnore(inputOutput, n, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        long l2 = transferInfo.getRuntime();
        String string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitMilisecond");
        if (l2 > 1000L) {
            l2 /= 1000L;
            string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitSecond");
        }
        double d = (double)l / 1024.0;
        String string2 = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitKilobyte");
        if (d > 1024.0) {
            d /= 1024.0;
            string2 = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitMegabyte");
        }
        Object[] objectArray = new Object[]{l2, string, n2, d, string2};
        outputWriter.println(NbBundle.getMessage(RemoteCommand.class, (String)"MSG_RemoteRuntimeAndSize", (Object[])objectArray));
    }

    private static void print(InputOutput inputOutput, String string, Color color) {
        try {
            IOColorLines.println((InputOutput)inputOutput, (CharSequence)string, (Color)color);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void printSuccess(InputOutput inputOutput, String string) {
        RemoteCommand.print(inputOutput, string, COLOR_SUCCESS);
    }

    private static void printSuccess(InputOutput inputOutput, int n, TransferFile transferFile) {
        String string = String.format("%-" + MAX_TYPE_SIZE + "s %-" + n + "s", RemoteCommand.getFileTypeLabel(transferFile), transferFile.getRelativePath());
        RemoteCommand.printSuccess(inputOutput, string);
    }

    private static void printError(OutputWriter outputWriter, int n, TransferFile transferFile, String string) {
        String string2 = String.format("%-" + MAX_TYPE_SIZE + "s %-" + n + "s   %s", RemoteCommand.getFileTypeLabel(transferFile), transferFile.getRelativePath(), string);
        outputWriter.println(string2);
    }

    private static void printIgnore(InputOutput inputOutput, String string) {
        RemoteCommand.print(inputOutput, string, COLOR_IGNORE);
    }

    private static void printIgnore(InputOutput inputOutput, int n, TransferFile transferFile, String string) {
        String string2 = String.format("%-" + MAX_TYPE_SIZE + "s %-" + n + "s   %s", RemoteCommand.getFileTypeLabel(transferFile), transferFile.getRelativePath(), string);
        RemoteCommand.printIgnore(inputOutput, string2);
    }

    private static String getFileTypeLabel(TransferFile transferFile) {
        String string = null;
        string = transferFile.isDirectory() ? "LBL_TypeDirectory" : (transferFile.isFile() ? "LBL_TypeFile" : "LBL_TypeUnknown");
        return NbBundle.getMessage(RemoteCommand.class, (String)string);
    }

    private static int getFileTypeLabelMaxSize() {
        String string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeDirectory");
        int n = string.length();
        if (n < (string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeFile")).length()) {
            n = string.length();
        }
        if (n < (string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeUnknown")).length()) {
            n = string.length();
        }
        return n;
    }

    private static int getRelativePathMaxSize(TransferInfo transferInfo) {
        int n = RemoteCommand.getRelativePathMaxSize(transferInfo.getTransfered());
        int n2 = RemoteCommand.getRelativePathMaxSize(transferInfo.getFailed().keySet());
        if (n2 > n) {
            n = n2;
        }
        if ((n2 = RemoteCommand.getRelativePathMaxSize(transferInfo.getPartiallyFailed().keySet())) > n) {
            n = n2;
        }
        if ((n2 = RemoteCommand.getRelativePathMaxSize(transferInfo.getIgnored().keySet())) > n) {
            n = n2;
        }
        return n + 2;
    }

    private static int getRelativePathMaxSize(Collection<TransferFile> collection) {
        int n = 0;
        for (TransferFile transferFile : collection) {
            int n2 = transferFile.getRelativePath().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected final boolean sourcesFilesOnly(FileObject fileObject, FileObject[] fileObjectArray) {
        for (FileObject fileObject2 : fileObjectArray) {
            if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject.equals(fileObject2)) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoteCommand.class, (String)"MSG_TransferSourcesOnly"), 0));
            return false;
        }
        return true;
    }

    protected static int getWorkUnits(Set<TransferFile> set) {
        int n = 0;
        for (TransferFile transferFile : set) {
            n = (int)((long)n + transferFile.getSize());
        }
        return n / 1024;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DefaultOperationMonitor
    implements RemoteClient.OperationMonitor {
        private final String processMessageKey;
        int progressSize = 0;
        ProgressHandle progressHandle = null;

        public DefaultOperationMonitor(String string) {
            assert (string != null);
            this.processMessageKey = string;
        }

        @Override
        public void operationStart(RemoteClient.Operation operation, Collection<TransferFile> collection) {
        }

        @Override
        public void operationProcess(RemoteClient.Operation operation, TransferFile transferFile) {
            long l = transferFile.getSize();
            if (l > 0L) {
                assert (this.progressHandle != null);
                this.progressHandle.progress(NbBundle.getMessage(DefaultOperationMonitor.class, (String)this.processMessageKey, (Object)transferFile.getName()), this.progressSize);
                this.progressSize = (int)((long)this.progressSize + l / 1024L);
            }
        }

        @Override
        public void operationFinish(RemoteClient.Operation operation, Collection<TransferFile> collection) {
        }
    }
}

