/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.connections.ui.NewRemoteConnectionPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConnectionsPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -286975118754121236L;
    private static final RequestProcessor TEST_CONNECTION_RP = new RequestProcessor("Test Remote Connection", 1);
    private final ConfigListModel configListModel = new ConfigListModel();
    private final RemoteConnections remoteConnections;
    private final ConfigManager configManager;
    private RemoteConfigurationPanel configurationPanel = new EmptyConfigurationPanel();
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport notificationLineSupport = null;
    private RequestProcessor.Task testConnectionTask = null;
    private JButton addButton;
    private JList configList;
    private JScrollPane configScrollPane;
    private JPanel configurationPanelHolder;
    private JScrollPane configurationPanelScrollPane;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton removeButton;
    private JSeparator separator;
    private JButton testConnectionButton;

    public RemoteConnectionsPanel(RemoteConnections remoteConnections, ConfigManager configManager) {
        this.remoteConnections = remoteConnections;
        this.configManager = configManager;
        this.initComponents();
        this.configList.setModel(this.configListModel);
        this.configList.setCellRenderer(new ConfigListRenderer());
        this.setEnabledRemoveButton();
        this.registerListeners();
    }

    public void setConfigurations(List<ConfigManager.Configuration> list) {
        this.configListModel.setElements(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(final RemoteConfiguration remoteConfiguration) {
        this.testConnectionTask = TEST_CONNECTION_RP.create(new Runnable(){

            public void run() {
                RemoteConnectionsPanel.this.testConnection();
            }
        }, true);
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_ManageRemoteConnections"), true, 2, NotifyDescriptor.OK_OPTION, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        this.testConnectionTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                RemoteConnectionsPanel.this.enableTestConnection();
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (RemoteConnectionsPanel.this.getConfigurations().isEmpty()) {
                        RemoteConnectionsPanel.this.addConfig();
                    } else if (remoteConfiguration != null) {
                        RemoteConnectionsPanel.this.selectConfiguration(remoteConfiguration.getName());
                    } else {
                        RemoteConnectionsPanel.this.selectConfiguration(0);
                    }
                }
            });
            dialog.setVisible(true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            dialog.dispose();
            throw throwable;
        }
        dialog.dispose();
        return this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
    }

    private void registerListeners() {
        this.configList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RemoteConnectionsPanel.this.setEnabledRemoveButton();
                RemoteConnectionsPanel.this.selectCurrentConfig();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnectionsPanel.this.addConfig();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnectionsPanel.this.removeConfig();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void testConnection() {
        RemoteException remoteException;
        String string;
        block13: {
            this.testConnectionButton.setEnabled(false);
            ConfigManager.Configuration configuration = this.getSelectedConfiguration();
            assert (configuration != null);
            RemoteConfiguration remoteConfiguration = this.remoteConnections.getRemoteConfiguration(configuration);
            assert (remoteConfiguration != null) : "Cannot find remote configuration for config manager configuration " + configuration.getName();
            string = configuration.getDisplayName();
            String string2 = NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestingConnection", (Object)string);
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
            RemoteClient remoteClient = new RemoteClient(remoteConfiguration);
            remoteException = null;
            progressHandle.start();
            remoteClient.connect();
            Object var10_8 = null;
            try {
                remoteClient.disconnect();
            }
            catch (RemoteException remoteException2) {
                // empty catch block
            }
            progressHandle.finish();
            {
                break block13;
                catch (RemoteException remoteException3) {
                    remoteException = remoteException3;
                    Object var10_9 = null;
                    try {
                        remoteClient.disconnect();
                    }
                    catch (RemoteException remoteException4) {
                        // empty catch block
                    }
                    progressHandle.finish();
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    remoteClient.disconnect();
                }
                catch (RemoteException remoteException5) {
                    // empty catch block
                }
                progressHandle.finish();
                throw throwable;
            }
        }
        String string3 = null;
        int n = 0;
        if (remoteException != null) {
            string3 = remoteException.getRemoteServerAnswer() != null ? NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestConnectionFailedServerAnswer", (Object)remoteException.getMessage(), (Object)remoteException.getRemoteServerAnswer()) : (remoteException.getCause() != null ? NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestConnectionFailedCause", (Object)remoteException.getMessage(), (Object)remoteException.getCause().getMessage()) : remoteException.getMessage());
            n = 0;
        } else {
            string3 = NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestConnectionSucceeded");
            n = 1;
        }
        DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string3, string, 2, n, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
    }

    void enableTestConnection() {
        assert (this.testConnectionTask != null);
        ConfigManager.Configuration configuration = this.getSelectedConfiguration();
        this.testConnectionButton.setEnabled(this.testConnectionTask.isFinished() && configuration != null && configuration.isValid());
    }

    private void addConfiguration(ConfigManager.Configuration configuration) {
        this.addConfiguration(configuration, true);
    }

    private void addConfiguration(ConfigManager.Configuration configuration, boolean bl) {
        assert (this.configListModel.indexOf(configuration) == -1) : "Configuration already in the list: " + configuration;
        this.configListModel.addElement(configuration);
        if (bl) {
            this.configList.setSelectedValue(configuration, true);
            this.switchConfigurationPanel();
            this.descriptor.setValid(false);
        }
    }

    private void selectConfiguration(int n) {
        this.configList.setSelectedIndex(n);
        this.switchConfigurationPanel();
    }

    private void selectConfiguration(String string) {
        this.configList.setSelectedValue(this.configListModel.getElement(string), true);
        this.switchConfigurationPanel();
    }

    private void readActiveConfig(ConfigManager.Configuration configuration) {
        this.configurationPanel.read(configuration);
    }

    private void storeActiveConfig(ConfigManager.Configuration configuration) {
        this.configurationPanel.store(configuration);
    }

    private void switchConfigurationPanel() {
        this.configurationPanel.removeChangeListener(this);
        String string = null;
        String string2 = null;
        ConfigManager.Configuration configuration = (ConfigManager.Configuration)this.configList.getSelectedValue();
        if (configuration != null) {
            string2 = this.remoteConnections.getConfigurationType(configuration);
            string = configuration.getDisplayName();
            this.configurationPanel = this.remoteConnections.getConfigurationPanel(configuration);
            assert (this.configurationPanel != null) : "Panel must be provided for configuration " + configuration.getName();
            this.readActiveConfig(configuration);
            this.configManager.markAsCurrentConfiguration(configuration.getName());
        } else {
            this.configurationPanel = new EmptyConfigurationPanel();
        }
        this.configurationPanel.addChangeListener(this);
        this.resetFields();
        if (configuration != null) {
            assert (string != null) : "Name must be found for config " + configuration.getDisplayName();
            assert (string2 != null) : "Type must be found for config " + configuration.getDisplayName();
            this.nameTextField.setText(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"TXT_NameType", (Object)string, (Object)string2));
        }
        this.configurationPanelHolder.add((Component)this.configurationPanel.getComponent(), "Center");
        this.configurationPanelHolder.revalidate();
        this.configurationPanelHolder.repaint();
    }

    private ConfigManager.Configuration getSelectedConfiguration() {
        return (ConfigManager.Configuration)this.configList.getSelectedValue();
    }

    private List<ConfigManager.Configuration> getConfigurations() {
        return this.configListModel.getElements();
    }

    private void removeConfiguration(ConfigManager.Configuration configuration) {
        assert (this.configListModel.indexOf(configuration) != -1) : "Configuration not in the list: " + configuration;
        int n = -1;
        int n2 = this.configListModel.indexOf(configuration);
        if (n2 + 1 < this.configListModel.getSize()) {
            n = n2;
        } else if (this.configListModel.getSize() > 1) {
            n = n2 - 1;
        }
        this.configListModel.removeElement(configuration);
        if (n != -1) {
            this.configList.setSelectedIndex(n);
            this.switchConfigurationPanel();
        }
    }

    private void resetFields() {
        this.nameTextField.setText(" ");
        this.configurationPanelHolder.removeAll();
        this.configurationPanelHolder.revalidate();
        this.configurationPanelHolder.repaint();
        this.setError(null);
        this.setWarning(null);
    }

    private boolean isValidConfiguration() {
        return this.configurationPanel.isValidConfiguration();
    }

    private String getError() {
        return this.configurationPanel.getError();
    }

    private String getWarning() {
        return this.configurationPanel.getWarning();
    }

    private void setError(String string) {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        if (StringUtils.hasText((String)string)) {
            this.notificationLineSupport.setErrorMessage(string);
            this.descriptor.setValid(false);
        } else {
            this.notificationLineSupport.clearMessages();
            this.descriptor.setValid(true);
        }
        this.enableTestConnection();
    }

    private void setWarning(String string) {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        if (StringUtils.hasText((String)string)) {
            this.notificationLineSupport.setWarningMessage(string);
        }
    }

    private void refreshConfigList() {
        this.configList.repaint();
    }

    void setEnabledRemoveButton() {
        this.setEnabledRemoveButton(this.configList.getSelectedIndex() != -1);
    }

    private void setEnabledRemoveButton(boolean bl) {
        this.removeButton.setEnabled(bl);
    }

    void validateActiveConfig() {
        boolean bl = this.isValidConfiguration();
        String string = this.getError();
        ConfigManager.Configuration configuration = this.getSelectedConfiguration();
        configuration.setErrorMessage(string);
        this.setError(string);
        if (!bl) {
            return;
        }
        this.setWarning(this.getWarning());
        this.checkAllConfigs();
    }

    private void checkAllConfigs() {
        for (ConfigManager.Configuration configuration : this.getConfigurations()) {
            assert (configuration != null);
            if (configuration.isValid()) continue;
            this.setError(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_InvalidConfiguration", (Object)configuration.getDisplayName()));
            assert (this.descriptor != null);
            this.descriptor.setValid(false);
            return;
        }
    }

    void addConfig() {
        NewRemoteConnectionPanel newRemoteConnectionPanel = new NewRemoteConnectionPanel(this.configManager);
        if (newRemoteConnectionPanel.open()) {
            String string = newRemoteConnectionPanel.getConfigName();
            String string2 = newRemoteConnectionPanel.getConnectionName();
            String string3 = newRemoteConnectionPanel.getConnectionType();
            assert (string != null);
            assert (string2 != null);
            assert (string3 != null);
            ConfigManager.Configuration configuration = this.configManager.createNew(string, string2);
            RemoteConfiguration remoteConfiguration = this.remoteConnections.createRemoteConfiguration(string3, configuration);
            assert (remoteConfiguration != null) : "No remote configuration created for type: " + string3;
            this.addConfiguration(configuration);
            this.configManager.markAsCurrentConfiguration(string);
        }
    }

    void removeConfig() {
        ConfigManager.Configuration configuration = this.getSelectedConfiguration();
        assert (configuration != null);
        this.configManager.configurationFor(configuration.getName()).delete();
        this.removeConfiguration(configuration);
    }

    void selectCurrentConfig() {
        ConfigManager.Configuration configuration = this.getSelectedConfiguration();
        if (configuration != null) {
            this.switchConfigurationPanel();
            this.validateActiveConfig();
        } else {
            this.resetFields();
            this.checkAllConfigs();
        }
    }

    private void initComponents() {
        this.configScrollPane = new JScrollPane();
        this.configList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.separator = new JSeparator();
        this.configurationPanelScrollPane = new JScrollPane();
        this.configurationPanelHolder = new JPanel();
        this.testConnectionButton = new JButton();
        this.setFocusTraversalPolicy(null);
        this.configList.setSelectionMode(0);
        this.configScrollPane.setViewportView(this.configList);
        this.configList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configList.AccessibleContext.accessibleName"));
        this.configList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Remove"));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Name"));
        this.nameTextField.setEditable(false);
        this.configurationPanelScrollPane.setBorder(null);
        this.configurationPanelHolder.setLayout(new BorderLayout());
        this.configurationPanelScrollPane.setViewportView(this.configurationPanelHolder);
        this.configurationPanelHolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.detailsPanel.AccessibleContext.accessibleName"));
        this.configurationPanelHolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.detailsPanel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.testConnectionButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_TestConnection"));
        this.testConnectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnectionsPanel.this.testConnectionButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton)).add((Component)this.configScrollPane, -1, 172, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.separator, -1, 500, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.nameTextField, -1, 450, Short.MAX_VALUE)).add((Component)this.testConnectionButton).add((Component)this.configurationPanelScrollPane, -1, 500, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.removeButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.configScrollPane, -1, 318, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameTextField, -2, -1, -2)).addPreferredGap(1).add((Component)this.separator, -2, 10, -2).add(6, 6, 6).add((Component)this.configurationPanelScrollPane, -1, 271, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.testConnectionButton)).addContainerGap()));
        this.configScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configScrollPane.AccessibleContext.accessibleName"));
        this.configScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configScrollPane.AccessibleContext.accessibleDescription"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.addButton.AccessibleContext.accessibleName"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.addButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.removeButton.AccessibleContext.accessibleDescription"));
        this.nameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameLabel.AccessibleContext.accessibleName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameTextField.AccessibleContext.accessibleName"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameTextField.AccessibleContext.accessibleDescription"));
        this.separator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.separator.AccessibleContext.accessibleName"));
        this.separator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.separator.AccessibleContext.accessibleDescription"));
        this.configurationPanelScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configurationPanelScrollPane.AccessibleContext.accessibleName"));
        this.configurationPanelScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configurationPanelScrollPane.AccessibleContext.accessibleDescription"));
        this.testConnectionButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.testConnectionButton.AccessibleContext.accessibleName"));
        this.testConnectionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.testConnectionButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void testConnectionButtonActionPerformed(ActionEvent actionEvent) {
        this.testConnectionTask.schedule(0);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ConfigManager.Configuration configuration = this.getSelectedConfiguration();
        if (configuration != null) {
            this.validateActiveConfig();
            this.storeActiveConfig(configuration);
        }
        this.refreshConfigList();
    }

    private static final class EmptyConfigurationPanel
    implements RemoteConfigurationPanel {
        private static final JPanel PANEL = new JPanel();

        private EmptyConfigurationPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public JComponent getComponent() {
            return PANEL;
        }

        public boolean isValidConfiguration() {
            return true;
        }

        public String getError() {
            return null;
        }

        public String getWarning() {
            return null;
        }

        public void read(ConfigManager.Configuration configuration) {
        }

        public void store(ConfigManager.Configuration configuration) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -1945188556310432557L;
        private final List<ConfigManager.Configuration> data = new ArrayList<ConfigManager.Configuration>();

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public ConfigManager.Configuration getElementAt(int n) {
            return this.data.get(n);
        }

        public boolean addElement(ConfigManager.Configuration configuration) {
            assert (configuration != null);
            if (!this.data.add(configuration)) {
                return false;
            }
            Collections.sort(this.data, ConfigManager.getConfigurationComparator());
            int n = this.indexOf(configuration);
            this.fireIntervalAdded(this, n, n);
            return true;
        }

        public int indexOf(ConfigManager.Configuration configuration) {
            return this.data.indexOf(configuration);
        }

        public boolean removeElement(ConfigManager.Configuration configuration) {
            int n = this.indexOf(configuration);
            if (n == -1) {
                return false;
            }
            boolean bl = this.data.remove(configuration);
            assert (bl);
            this.fireIntervalRemoved(this, n, n);
            return true;
        }

        public List<ConfigManager.Configuration> getElements() {
            return Collections.unmodifiableList(this.data);
        }

        public void setElements(List<ConfigManager.Configuration> list) {
            int n = this.data.size();
            this.data.clear();
            if (n > 0) {
                this.fireIntervalRemoved(this, 0, n - 1);
            }
            if (list.size() > 0) {
                this.data.addAll(list);
                Collections.sort(this.data, ConfigManager.getConfigurationComparator());
                this.fireIntervalAdded(this, 0, this.data.size() - 1);
            }
        }

        public ConfigManager.Configuration getElement(String string) {
            assert (string != null);
            for (ConfigManager.Configuration configuration : this.data) {
                if (!string.equals(configuration.getName())) continue;
                return configuration;
            }
            return null;
        }
    }

    public static class ConfigListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 3196531352192214602L;

        public ConfigListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            Color color = UIManager.getColor("nb.errorForeground");
            boolean bl3 = true;
            if (object != null) {
                assert (object instanceof ConfigManager.Configuration);
                ConfigManager.Configuration configuration = (ConfigManager.Configuration)object;
                this.setText(configuration.getDisplayName());
                bl3 = configuration.isValid();
            }
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(bl3 ? jList.getSelectionForeground() : color);
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(bl3 ? jList.getForeground() : color);
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

