/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.EventQueue;
import java.io.File;
import java.util.List;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.SwitchTo;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchToAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Switch";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean enable(Node[] nodeArray) {
        return super.enable(nodeArray) && nodeArray.length == 1;
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        File[] fileArray = SvnUtils.getActionRoots(context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file = fileArray.length == 1 ? fileArray[0] : SvnUtils.getPrimaryFile(fileArray[0]);
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, sVNUrl, SVNRevision.HEAD);
        boolean bl = Subversion.getInstance().getStatusCache().containsFiles(context, 6612, true);
        RequestProcessor requestProcessor = this.createRequestProcessor(nodeArray);
        SwitchTo switchTo = new SwitchTo(repositoryFile, file, bl);
        this.performSwitch(switchTo, requestProcessor, nodeArray, fileArray);
    }

    private void performSwitch(final SwitchTo switchTo, final RequestProcessor requestProcessor, final Node[] nodeArray, final File[] fileArray) {
        if (!switchTo.showDialog()) {
            return;
        }
        requestProcessor.post(new Runnable(){

            public void run() {
                if (!SwitchToAction.this.validateInput(fileArray[0], switchTo.getRepositoryFile())) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SwitchToAction.this.performSwitch(switchTo, requestProcessor, nodeArray, fileArray);
                        }
                    });
                } else {
                    ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(SwitchToAction.this, nodeArray){

                        public void perform() {
                            for (File file : fileArray) {
                                RepositoryFile repositoryFile = switchTo.getRepositoryFile();
                                if (file.isFile() && fileArray.length > 1) {
                                    repositoryFile = repositoryFile.replaceLastSegment(file.getName(), 0);
                                }
                                SwitchToAction.performSwitch(repositoryFile, file, this);
                            }
                        }
                    };
                    progressSupport.start(requestProcessor);
                }
            }
        });
    }

    private boolean validateInput(File file, RepositoryFile repositoryFile) {
        boolean bl = false;
        try {
            SvnClient svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
            ISVNInfo iSVNInfo = svnClient.getInfo(repositoryFile.getFileUrl());
            if (iSVNInfo.getNodeKind() == SVNNodeKind.DIR && file.isFile()) {
                SvnClientExceptionHandler.annotate(NbBundle.getMessage(SwitchToAction.class, (String)"LBL_SwitchFileToFolderError"));
                bl = false;
            } else if (iSVNInfo.getNodeKind() == SVNNodeKind.FILE && file.isDirectory()) {
                SvnClientExceptionHandler.annotate(NbBundle.getMessage(SwitchToAction.class, (String)"LBL_SwitchFolderToFileError"));
                bl = false;
            } else {
                bl = true;
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return bl;
        }
        return bl;
    }

    static void performSwitch(RepositoryFile repositoryFile, File file, SvnProgressSupport svnProgressSupport) {
        File[][] fileArray = Utils.splitFlatOthers((File[])new File[]{file});
        boolean bl = fileArray[0].length <= 0;
        try {
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            svnClient.switchToUrl(file, repositoryFile.getFileUrl(), repositoryFile.getRevision(), bl);
            List<File> list = SvnUtils.listRecursively(file);
            File[] fileArray2 = list.toArray(new File[list.size()]);
            Subversion.getInstance().getStatusCache().getLabelsCache().flushFileLabels(fileArray2);
            Subversion.getInstance().refreshAnnotations(fileArray2);
            Subversion.getInstance().versionedFilesChanged();
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }
}

