/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FileChooserUI;
import org.netbeans.swing.dirchooser.DelegatingChooserUI;
import org.openide.modules.ModuleInstall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends ModuleInstall {
    private static final String KEY = "FileChooserUI";
    private static Class<? extends FileChooserUI> originalImpl;
    private static PropertyChangeListener pcl;
    private static final String QUICK_CHOOSER_NAME = "org.netbeans.modules.quickfilechooser.ChooserComponentUI";
    private static final String FORCE_STANDARD_CHOOSER = "standard-file-chooser";

    public void restored() {
        Module.install();
    }

    public void uninstalled() {
        Module.uninstall();
    }

    public static void install() {
        if (Module.isStandardChooserForced()) {
            return;
        }
        final UIDefaults uIDefaults = UIManager.getDefaults();
        originalImpl = uIDefaults.getUIClass(KEY);
        Class<DelegatingChooserUI> clazz = DelegatingChooserUI.class;
        final String string = clazz.getName();
        if (!Module.isQuickFileChooser(uIDefaults.get(KEY))) {
            uIDefaults.put(KEY, string);
            uIDefaults.put(string, clazz);
        }
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string2 = propertyChangeEvent.getPropertyName();
                Object object = uIDefaults.get(Module.KEY);
                if ((string2.equals(Module.KEY) || string2.equals("UIDefaults")) && !string.equals(object) && !Module.isQuickFileChooser(object)) {
                    uIDefaults.put(Module.KEY, string);
                }
            }
        };
        uIDefaults.addPropertyChangeListener(pcl);
    }

    public static void uninstall() {
        if (Module.isInstalled()) {
            assert (pcl != null);
            UIDefaults uIDefaults = UIManager.getDefaults();
            uIDefaults.removePropertyChangeListener(pcl);
            pcl = null;
            String string = originalImpl.getName();
            uIDefaults.put(KEY, string);
            uIDefaults.put(string, originalImpl);
            originalImpl = null;
        }
    }

    public static boolean isInstalled() {
        return originalImpl != null;
    }

    static Class<? extends FileChooserUI> getOrigChooser() {
        return originalImpl;
    }

    private static boolean isQuickFileChooser(Object object) {
        return QUICK_CHOOSER_NAME.equals(object);
    }

    private static boolean isStandardChooserForced() {
        return Boolean.getBoolean(FORCE_STANDARD_CHOOSER);
    }
}

