/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.db.sql.editor.SQLSyntax;
import org.netbeans.modules.db.sql.editor.SQLSyntaxSupport;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.modules.editor.NbEditorKit;

public class SQLEditorKit
extends NbEditorKit {
    public static final String MIME_TYPE = "text/x-sql";

    public Syntax createSyntax(Document document) {
        return new SQLSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new SQLSyntaxSupport(baseDocument);
    }

    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        Action[] actionArray2 = new Action[]{new SQLDefaultKeyTypedAction(), new ExtKit.ToggleCommentAction("--")};
        return TextAction.augmentList(actionArray, actionArray2);
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    public static class SQLDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            if ((c == '\"' || c == '\'') && SQLDefaultKeyTypedAction.canCompleteQuote(baseDocument, n)) {
                super.insertString(baseDocument, n, caret, String.valueOf(c) + c, bl);
                caret.setDot(n + 1);
                return;
            }
            super.insertString(baseDocument, n, caret, string, bl);
        }

        private static boolean canCompleteQuote(BaseDocument baseDocument, int n) {
            SQLCompletionEnv sQLCompletionEnv = SQLCompletionEnv.forDocument((Document)baseDocument, n);
            TokenSequence<SQLTokenId> tokenSequence = sQLCompletionEnv.getTokenSequence();
            if (tokenSequence.move(n) == 0 && tokenSequence.movePrevious()) {
                switch ((SQLTokenId)tokenSequence.token().id()) {
                    case WHITESPACE: 
                    case DOT: {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

