/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstNodeUtils {
    private static final String INDENT = "   ";

    public static String dumpTree(AstNode astNode) {
        StringBuffer stringBuffer = new StringBuffer();
        AstNodeUtils.dumpTree(astNode, stringBuffer);
        System.out.println(stringBuffer.toString());
        return stringBuffer.toString();
    }

    public static void dumpTree(AstNode astNode, StringBuffer stringBuffer) {
        AstNodeUtils.dump(astNode, "", stringBuffer);
    }

    private static void dump(AstNode astNode, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string + astNode.toString());
        stringBuffer.append('\n');
        for (AstNode astNode2 : astNode.children()) {
            AstNodeUtils.dump(astNode2, string + INDENT, stringBuffer);
        }
    }

    public static AstNode getRoot(AstNode astNode) {
        while (astNode.parent() != null) {
            astNode = astNode.parent();
        }
        return astNode;
    }

    public static List<AstNode> getAncestors(AstNode astNode, AstNode.NodeFilter nodeFilter) {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        AstNode astNode2 = astNode;
        do {
            if (!nodeFilter.accepts(astNode2)) continue;
            arrayList.add(astNode2);
        } while ((astNode2 = astNode2.parent()) != null);
        return arrayList;
    }

    public static List<AstNode> getChildrenRecursivelly(AstNode astNode, AstNode.NodeFilter nodeFilter, boolean bl) {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        AstNodeUtils.getChildrenRecursivelly(arrayList, astNode, nodeFilter, bl);
        return arrayList;
    }

    private static void getChildrenRecursivelly(List<AstNode> list, AstNode astNode, AstNode.NodeFilter nodeFilter, boolean bl) {
        for (AstNode astNode2 : astNode.children()) {
            if (nodeFilter.accepts(astNode2)) {
                list.add(astNode2);
                AstNodeUtils.getChildrenRecursivelly(list, astNode2, nodeFilter, bl);
                continue;
            }
            if (bl) continue;
            AstNodeUtils.getChildrenRecursivelly(list, astNode2, nodeFilter, bl);
        }
    }

    public static AstNode findDescendant(AstNode astNode, int n) {
        return AstNodeUtils.findDescendant(astNode, n, false);
    }

    public static AstNode findDescendant(AstNode astNode, int n, boolean bl) {
        int[] nArray = astNode.getLogicalRange();
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n < n2 || n > n3) {
            return astNode;
        }
        if (bl) {
            ++n2;
        }
        if (n >= n2 && n < n3 && astNode.children().isEmpty()) {
            return astNode;
        }
        for (AstNode astNode2 : astNode.children()) {
            int[] nArray2 = astNode2.getLogicalRange();
            int n4 = nArray2[0];
            if (bl) {
                ++n4;
            }
            int n5 = nArray2[1];
            if (n < n4 || n >= n5) continue;
            return AstNodeUtils.findDescendant(astNode2, n, bl);
        }
        return astNode;
    }

    public static AstNode findDescendantTag(AstNode astNode, int n, boolean bl, boolean bl2) {
        int n2;
        int n3 = bl ? astNode.logicalStartOffset() : astNode.startOffset();
        int n4 = n2 = bl ? astNode.logicalEndOffset() : astNode.endOffset();
        if (bl2 ? n >= n3 && n < n2 && astNode.children().isEmpty() : n > n3 && n <= n2 && astNode.children().isEmpty()) {
            return astNode;
        }
        for (AstNode astNode2 : astNode.children()) {
            AstNode astNode3;
            int n5 = astNode2.logicalStartOffset();
            int n6 = astNode2.logicalEndOffset();
            if (bl2) {
                if (n < n5 || n >= n6) continue;
                if (n < astNode2.endOffset()) {
                    return astNode2;
                }
                astNode3 = AstNodeUtils.findDescendantTag(astNode2, n, bl, bl2);
                if (astNode3 == null) continue;
                return astNode3;
            }
            if (n <= n5 || n > n6) continue;
            if (n <= astNode2.endOffset()) {
                return astNode2;
            }
            astNode3 = AstNodeUtils.findDescendantTag(astNode2, n, bl, bl2);
            if (astNode3 == null) continue;
            return astNode3;
        }
        return null;
    }

    public static AstNode getTagNode(AstNode astNode, int n) {
        if (astNode.type() == AstNode.NodeType.OPEN_TAG) {
            if (n >= astNode.startOffset() && n < astNode.endOffset()) {
                return astNode;
            }
            AstNode astNode2 = astNode.getMatchingTag();
            if (astNode2 != null && astNode2.type() == AstNode.NodeType.ENDTAG && n >= astNode2.startOffset() && n < astNode2.endOffset()) {
                return astNode2;
            }
            return null;
        }
        return astNode;
    }

    public static AstNode query(AstNode astNode, String string) {
        return AstNodeUtils.query(astNode, string, false);
    }

    public static AstNode query(AstNode astNode, String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        AstNode astNode2 = astNode;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(124);
            String string4 = string2 = n >= 0 ? string3.substring(0, n) : string3;
            if (bl) {
                string2 = string2.toLowerCase(Locale.ENGLISH);
            }
            String string5 = n >= 0 ? string3.substring(n + 1, string3.length()) : "0";
            int n2 = Integer.parseInt(string5);
            int n3 = 0;
            AstNode astNode3 = null;
            for (AstNode astNode4 : astNode2.children()) {
                String string6 = astNode4.name();
                if (astNode4.type() != AstNode.NodeType.OPEN_TAG || !(bl ? (string6 = string6.toLowerCase(Locale.ENGLISH)) : string6).equals(string2) || n3++ != n2) continue;
                astNode3 = astNode4;
                break;
            }
            if (astNode3 != null) {
                astNode2 = astNode3;
                if (stringTokenizer.hasMoreTokens()) continue;
                assert (astNode2.name().equals(string2));
                return astNode2;
            }
            return null;
        }
        return null;
    }

    public static Collection<DTD.Element> getPossibleOpenTagElements(AstNode astNode, int n) {
        HashSet<DTD.Element> hashSet = new HashSet<DTD.Element>();
        assert (astNode.type() == AstNode.NodeType.ROOT);
        AstNode astNode2 = AstNodeUtils.findDescendant(astNode, n, true);
        while (astNode2.getDTDElement() == null && astNode2.type() != AstNode.NodeType.ROOT) {
            astNode2 = astNode2.parent();
        }
        assert (astNode2 != null);
        if (astNode2 == astNode) {
            return astNode.getAllPossibleElements();
        }
        if (astNode2.startOffset() <= n && astNode2.endOffset() > n) {
            return Collections.EMPTY_LIST;
        }
        assert (astNode2.type() == AstNode.NodeType.OPEN_TAG);
        DTD.ContentModel contentModel = astNode2.getDTDElement().getContentModel();
        DTD.Content content = contentModel.getContent();
        for (AstNode astNode3 : astNode2.children()) {
            DTD.Content content2;
            if (astNode3.startOffset() >= n) break;
            if (astNode3.type() != AstNode.NodeType.OPEN_TAG || (content2 = content.reduce(astNode3.getDTDElement().getName())) == null) continue;
            content = content2;
        }
        if (!astNode2.needsToHaveMatchingTag() && astNode2.parent().type() != AstNode.NodeType.ROOT) {
            hashSet.addAll(AstNodeUtils.getPossibleOpenTagElements(astNode, astNode2.startOffset()));
        }
        hashSet.addAll(content.getPossibleElements());
        hashSet.addAll(contentModel.getIncludes());
        hashSet.removeAll(contentModel.getExcludes());
        return hashSet;
    }

    public static boolean hasForbiddenEndTag(AstNode astNode) {
        return astNode.getDTDElement() != null ? astNode.getDTDElement().isEmpty() : false;
    }

    public static void visitChildren(AstNode astNode, AstNodeVisitor astNodeVisitor, AstNode.NodeType nodeType) {
        for (AstNode astNode2 : astNode.children()) {
            if (nodeType == null || astNode2.type() == nodeType) {
                astNodeVisitor.visit(astNode2);
            }
            AstNodeUtils.visitChildren(astNode2, astNodeVisitor, nodeType);
        }
    }

    public static void visitChildren(AstNode astNode, AstNodeVisitor astNodeVisitor) {
        AstNodeUtils.visitChildren(astNode, astNodeVisitor, null);
    }

    public static void visitAncestors(AstNode astNode, AstNodeVisitor astNodeVisitor) {
        AstNode astNode2 = astNode.parent();
        if (astNode2 != null) {
            astNodeVisitor.visit(astNode2);
            AstNodeUtils.visitAncestors(astNode2, astNodeVisitor);
        }
    }
}

