/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(ParserResult parserResult, int n, String[] stringArray) {
        Node node;
        Node node2 = AstUtilities.getRoot((Parser.Result)parserResult);
        if (node2 == null) {
            stringArray[0] = NbBundle.getMessage(RubyRenameHandler.class, (String)"NoRenameWithErrors");
            return false;
        }
        int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
        if (n2 == -1) {
            return false;
        }
        AstPath astPath = new AstPath(node2, n2);
        Node node3 = astPath.leaf();
        if (node3 == null) {
            return false;
        }
        if (node3.getNodeType() == NodeType.LOCALVARNODE || node3.getNodeType() == NodeType.LOCALASGNNODE || node3.getNodeType() == NodeType.DVARNODE || node3.getNodeType() == NodeType.DASGNNODE || node3.getNodeType() == NodeType.BLOCKARGNODE) {
            return true;
        }
        if (node3.getNodeType() == NodeType.ARGUMENTNODE && (node = astPath.leafParent()) != null && !(node instanceof MethodDefNode)) {
            return true;
        }
        switch (node3.getNodeType()) {
            case INSTASGNNODE: 
            case INSTVARNODE: 
            case CLASSVARDECLNODE: 
            case CLASSVARNODE: 
            case CLASSVARASGNNODE: 
            case GLOBALASGNNODE: 
            case GLOBALVARNODE: 
            case CONSTDECLNODE: 
            case CONSTNODE: 
            case DEFNNODE: 
            case DEFSNODE: 
            case FCALLNODE: 
            case CALLNODE: 
            case VCALLNODE: 
            case ARGUMENTNODE: 
            case COLON2NODE: 
            case COLON3NODE: 
            case ALIASNODE: 
            case SYMBOLNODE: {
                return true;
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult parserResult, int n) {
        Node node = AstUtilities.getRoot((Parser.Result)parserResult);
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
        int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
        if (n2 == -1) {
            return Collections.emptySet();
        }
        AstPath astPath = new AstPath(node, n2);
        Node node2 = astPath.leaf();
        if (node2 == null) {
            return Collections.emptySet();
        }
        if (node2 instanceof LocalVarNode || node2 instanceof LocalAsgnNode) {
            String string = ((INameNode)node2).getName();
            Node node3 = AstUtilities.findLocalScope(node2, astPath);
            if (node3 == null) {
                node3 = astPath.leafParent();
                if (node3.getNodeType() == NodeType.NEWLINENODE) {
                    node3 = astPath.leafGrandParent();
                }
                if (node3 == null) {
                    node3 = node2;
                }
            }
            this.addLocals(parserResult, node3, string, hashSet);
        } else if (node2.getNodeType() == NodeType.DVARNODE || node2.getNodeType() == NodeType.DASGNNODE) {
            String string = ((INameNode)node2).getName();
            List<Node> list = AstUtilities.getApplicableBlocks(astPath, true);
            for (Node node4 : list) {
                this.addDynamicVars(parserResult, node4, string, hashSet);
            }
        } else if (node2.getNodeType() == NodeType.ARGUMENTNODE || node2.getNodeType() == NodeType.BLOCKARGNODE) {
            String string = ((INameNode)node2).getName();
            Node node5 = astPath.leafParent();
            if (node5 != null && !(node5 instanceof MethodDefNode)) {
                MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
                if (methodDefNode == null) {
                    methodDefNode = AstUtilities.findBlock(astPath);
                }
                if (methodDefNode == null) {
                    methodDefNode = astPath.leafParent();
                    if (methodDefNode.getNodeType() == NodeType.NEWLINENODE) {
                        methodDefNode = astPath.leafGrandParent();
                    }
                    if (methodDefNode == null) {
                        methodDefNode = node2;
                    }
                }
                this.addLocals(parserResult, (Node)methodDefNode, string, hashSet);
            }
        }
        return hashSet;
    }

    private void addLocals(ParserResult parserResult, Node node, String string, Set<OffsetRange> set) {
        Object object;
        Object object2;
        Object object3;
        if (node.getNodeType() == NodeType.LOCALVARNODE) {
            if (((INameNode)node).getName().equals(string)) {
                object3 = AstUtilities.getRange(node);
                if ((object3 = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)object3)) != OffsetRange.NONE) {
                    set.add((OffsetRange)object3);
                }
            }
        } else if (node.getNodeType() == NodeType.LOCALASGNNODE) {
            if (((INameNode)node).getName().equals(string)) {
                object3 = AstUtilities.getRange(node);
                object3 = new OffsetRange(object3.getStart(), object3.getStart() + string.length());
                if ((object3 = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)object3)) != OffsetRange.NONE) {
                    set.add((OffsetRange)object3);
                }
            }
        } else if (node.getNodeType() == NodeType.ARGSNODE) {
            Node node2;
            object3 = (ArgsNode)node;
            if (object3.getRequiredCount() > 0) {
                object2 = object3.childNodes();
                object = object2.iterator();
                while (object.hasNext()) {
                    node2 = (Node)object.next();
                    if (!(node2 instanceof ListNode)) continue;
                    List list = node2.childNodes();
                    for (Node node3 : list) {
                        OffsetRange offsetRange;
                        if (node3.getNodeType() == NodeType.ARGUMENTNODE) {
                            if (!((ArgumentNode)node3).getName().equals(string)) continue;
                            offsetRange = AstUtilities.getRange(node3);
                            if ((offsetRange = LexUtilities.getLexerOffsets((Parser.Result)parserResult, offsetRange)) == OffsetRange.NONE) continue;
                            set.add(offsetRange);
                            continue;
                        }
                        if (node3.getNodeType() != NodeType.LOCALASGNNODE || !((LocalAsgnNode)node3).getName().equals(string)) continue;
                        offsetRange = AstUtilities.getRange(node3);
                        offsetRange = new OffsetRange(offsetRange.getStart(), offsetRange.getStart() + string.length());
                        if ((offsetRange = LexUtilities.getLexerOffsets((Parser.Result)parserResult, offsetRange)) == OffsetRange.NONE) continue;
                        set.add(offsetRange);
                    }
                }
            }
            if (object3.getRest() != null && (object2 = object3.getRest()).getName().equals(string)) {
                object = object2.getPosition();
                node2 = new OffsetRange(object.getStartOffset() + 1, object.getEndOffset());
                if ((node2 = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)node2)) != OffsetRange.NONE) {
                    set.add((OffsetRange)node2);
                }
            }
            if (object3.getBlock() != null && (object2 = object3.getBlock()).getName().equals(string)) {
                object = object2.getPosition();
                node2 = new OffsetRange(object.getStartOffset() + 1, object.getEndOffset());
                if ((node2 = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)node2)) != OffsetRange.NONE) {
                    set.add((OffsetRange)node2);
                }
            }
        }
        object3 = node.childNodes();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (object.isInvisible()) continue;
            this.addLocals(parserResult, (Node)object, string, set);
        }
    }

    private void addDynamicVars(ParserResult parserResult, Node node, String string, Set<OffsetRange> set) {
        List list;
        switch (node.getNodeType()) {
            case DVARNODE: {
                if (!((INameNode)node).getName().equals(string)) break;
                list = AstUtilities.getRange(node);
                if ((list = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)list)) == OffsetRange.NONE) break;
                set.add((OffsetRange)list);
                break;
            }
            case DASGNNODE: {
                if (!((INameNode)node).getName().equals(string)) break;
                list = AstUtilities.getRange(node);
                list = new OffsetRange(list.getStart(), list.getStart() + string.length());
                if ((list = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)list)) == OffsetRange.NONE) break;
                set.add((OffsetRange)list);
            }
        }
        list = node.childNodes();
        block7: for (Node node2 : list) {
            if (node2.isInvisible()) continue;
            switch (node2.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: 
                case ITERNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    continue block7;
                }
            }
            this.addDynamicVars(parserResult, node2, string, set);
        }
    }
}

