/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Set;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyBaseDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RubyConstantDeclarationFinder
extends RubyBaseDeclarationFinder<IndexedConstant> {
    private final Node constantNode;

    RubyConstantDeclarationFinder(ParserResult parserResult, Node node, AstPath astPath, RubyIndex rubyIndex, Node node2) {
        super(parserResult, node, astPath, rubyIndex);
        this.constantNode = node2;
    }

    DeclarationFinder.DeclarationLocation findConstantDeclaration() {
        Set<? extends IndexedConstant> set;
        String string;
        if (this.constantNode instanceof Colon2Node) {
            string = AstUtilities.getFqn((Colon2Node)this.constantNode);
            set = this.index.getConstants(string);
        } else {
            string = AstUtilities.getFqnName(this.path);
            set = this.index.getConstants(string, this.getConstantName());
        }
        string = this.getElementDeclaration(set, this.constantNode);
        if (string != DeclarationFinder.DeclarationLocation.NONE) {
            return string;
        }
        return RubyConstantDeclarationFinder.fix(this.findLocal(this.root), this.info);
    }

    @Override
    IndexedConstant findBestMatchHelper(Set<? extends IndexedConstant> set) {
        return set.isEmpty() ? null : set.iterator().next();
    }

    private String getConstantName() {
        return ((INameNode)this.constantNode).getName();
    }

    private DeclarationFinder.DeclarationLocation findLocal(Node node) {
        if (node instanceof ConstDeclNode && ((ConstDeclNode)node).getName().equals(this.getConstantName())) {
            return RubyConstantDeclarationFinder.getLocation(this.info, node);
        }
        for (Node node2 : node.childNodes()) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            if (node2.isInvisible() || (declarationLocation = this.findLocal(node2)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }
}

