/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import org.openide.awt.HtmlLabelUI;
import org.openide.awt.HtmlRenderer;

class HtmlRendererImpl
extends JLabel
implements HtmlRenderer.Renderer {
    private static final Rectangle bounds = new Rectangle();
    private static final boolean swingRendering = Boolean.getBoolean("nb.useSwingHtmlRendering");
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static boolean noCacheGraphics = Boolean.getBoolean("nb.renderer.nocache");
    private static Reference<Graphics> scratchGraphics = null;
    private boolean centered = false;
    private boolean parentFocused = false;
    private Boolean html = null;
    private int indent = 0;
    private Border border = null;
    private boolean selected = false;
    private boolean leadSelection = false;
    private Dimension prefSize = null;
    private Type type = Type.UNKNOWN;
    private int renderStyle = 0;
    private boolean enabled = true;

    HtmlRendererImpl() {
    }

    public void reset() {
        this.parentFocused = false;
        this.setCentered(false);
        this.html = null;
        this.indent = 0;
        this.border = null;
        this.setIcon(null);
        this.setOpaque(false);
        this.selected = false;
        this.leadSelection = false;
        this.prefSize = null;
        this.type = Type.UNKNOWN;
        this.renderStyle = 0;
        this.setFont(UIManager.getFont("controlFont"));
        this.setIconTextGap(3);
        this.setEnabled(true);
        this.border = null;
        HtmlRendererImpl.EMPTY_INSETS.top = 0;
        HtmlRendererImpl.EMPTY_INSETS.left = 0;
        HtmlRendererImpl.EMPTY_INSETS.right = 0;
        HtmlRendererImpl.EMPTY_INSETS.bottom = 0;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        this.configureFrom(object, jTable, bl, bl2);
        this.type = Type.TABLE;
        if (swingRendering && bl) {
            this.setBackground(jTable.getSelectionBackground());
            this.setForeground(jTable.getSelectionForeground());
            this.setOpaque(true);
        }
        return this;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.reset();
        this.configureFrom(object, jTree, bl, bl4);
        this.type = Type.TREE;
        if (swingRendering && bl) {
            if (HtmlLabelUI.isGTK()) {
                this.setBackground(HtmlLabelUI.getBackgroundFor(this));
                this.setForeground(HtmlLabelUI.getForegroundFor(this));
            }
            this.setOpaque(true);
        }
        return this;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.reset();
        this.configureFrom(object, jList, bl, bl2);
        this.type = Type.LIST;
        if (swingRendering && bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
            this.setOpaque(true);
        }
        if (HtmlLabelUI.isGTK()) {
            if (n == -1) {
                Color color = UIManager.getColor("controlShadow");
                color = color == null ? Color.GRAY : color;
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), BorderFactory.createEmptyBorder(3, 2, 3, 2)));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
        }
        return this;
    }

    private void configureFrom(Object object, JComponent jComponent, boolean bl, boolean bl2) {
        if (object == null) {
            object = "";
        }
        this.setText(object == null ? "" : object.toString());
        this.setSelected(bl);
        if (bl) {
            this.setParentFocused(this.checkFocused(jComponent));
        } else {
            this.setParentFocused(false);
        }
        this.setEnabled(jComponent.isEnabled());
        this.setLeadSelection(bl2);
        this.setFont(jComponent.getFont());
    }

    private boolean checkFocused(JComponent jComponent) {
        boolean bl;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl2 = bl = jComponent == component;
        if (!bl) {
            bl = jComponent.isAncestorOf(component);
        }
        return bl;
    }

    public void addNotify() {
        if (swingRendering) {
            super.addNotify();
        }
    }

    public void removeNotify() {
        if (swingRendering) {
            super.removeNotify();
        }
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setParentFocused(boolean bl) {
        this.parentFocused = bl;
    }

    public void setLeadSelection(boolean bl) {
        this.leadSelection = bl;
    }

    public void setCentered(boolean bl) {
        this.centered = bl;
        if (bl) {
            this.setIconTextGap(5);
        }
        if (swingRendering) {
            if (bl) {
                this.setVerticalTextPosition(3);
                this.setHorizontalAlignment(0);
                this.setHorizontalTextPosition(0);
            } else {
                this.setVerticalTextPosition(0);
                this.setHorizontalAlignment(10);
                this.setHorizontalTextPosition(11);
            }
        }
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void setHtml(boolean bl) {
        Boolean bl2 = this.html;
        String string = this.getText();
        Boolean bl3 = this.html = bl ? Boolean.TRUE : Boolean.FALSE;
        if (swingRendering && this.html != bl2) {
            this.firePropertyChange("text", string, this.getText());
        }
    }

    public void setRenderStyle(int n) {
        this.renderStyle = n;
    }

    int getRenderStyle() {
        return this.renderStyle;
    }

    boolean isLeadSelection() {
        return this.leadSelection;
    }

    boolean isCentered() {
        return this.centered;
    }

    boolean isParentFocused() {
        return this.parentFocused;
    }

    boolean isHtml() {
        if (this.html == null) {
            String string = this.getText();
            this.html = this.checkHtml(string);
        }
        return this.html;
    }

    private Boolean checkHtml(String string) {
        Boolean bl = string == null ? Boolean.FALSE : (string.startsWith("<html") || string.startsWith("<HTML") ? Boolean.TRUE : Boolean.FALSE);
        return bl;
    }

    boolean isSelected() {
        return this.selected;
    }

    int getIndent() {
        return this.indent;
    }

    Type getType() {
        return this.type;
    }

    public Dimension getPreferredSize() {
        if (!swingRendering) {
            if (this.prefSize == null) {
                this.prefSize = this.getUI().getPreferredSize(this);
            }
            return this.prefSize;
        }
        return super.getPreferredSize();
    }

    public String getText() {
        String string = super.getText();
        if (swingRendering && Boolean.TRUE.equals(this.html)) {
            string = this.ensureHtmlTags(string);
        } else if (swingRendering && this.html == null) {
            this.html = this.checkHtml(super.getText());
            if (Boolean.TRUE.equals(this.html)) {
                string = this.ensureHtmlTags(string);
            }
        }
        return string;
    }

    private String ensureHtmlTags(String string) {
        if (!(string = HtmlRendererImpl.ensureLegalFontColorTags(string)).startsWith("<HTML") && !string.startsWith("<html")) {
            string = "<html>" + string + "</html>";
        }
        return string;
    }

    private static String ensureLegalFontColorTags(String string) {
        String string2 = string.toUpperCase();
        int n = 0;
        int n2 = string2.indexOf("<FONT", n);
        StringBuffer stringBuffer = null;
        if (n2 != -1 && n2 <= string.length()) {
            while (n2 != -1 && n2 <= string.length()) {
                int n3;
                int n4;
                int n5 = string2.indexOf("COLOR", n);
                int n6 = string2.indexOf(62, n);
                n = n6 + 1;
                if (n6 == -1) break;
                if (n5 != -1 && n5 < n6 && (n4 = string2.indexOf(61, n5)) != -1 && (n3 = string2.indexOf(33, n4)) != -1 && n3 < n6) {
                    int n7 = n3 + 1;
                    int n8 = n6;
                    for (int i = n7; i < n6; ++i) {
                        char c = string.charAt(i);
                        if (Character.isLetter(c)) continue;
                        n8 = i;
                        break;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string);
                    }
                    String string3 = string.substring(n7, n8);
                    String string4 = HtmlRendererImpl.convertToStandardColor(string3);
                    stringBuffer.replace(n3, n8, string4);
                    string = stringBuffer.toString();
                    string2 = string.toUpperCase();
                }
                n = n2 = string2.indexOf("<FONT", n);
            }
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static String convertToStandardColor(String string) {
        Color color = UIManager.getColor(string);
        if (color == null) {
            color = Color.BLACK;
        }
        StringBuffer stringBuffer = new StringBuffer(7);
        stringBuffer.append('#');
        stringBuffer.append(HtmlRendererImpl.hexString(color.getRed()));
        stringBuffer.append(HtmlRendererImpl.hexString(color.getGreen()));
        stringBuffer.append(HtmlRendererImpl.hexString(color.getBlue()));
        return stringBuffer.toString();
    }

    private static String hexString(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            string = '0' + string;
        }
        return string;
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (swingRendering) {
            if ("text".equals(string) && this.isHtml()) {
                object2 = this.getText();
            }
            super.firePropertyChange(string, object, object2);
        }
    }

    public Border getBorder() {
        Border border = this.indent != 0 && swingRendering ? BorderFactory.createEmptyBorder(0, this.indent, 0, 0) : this.border;
        return border;
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        if (swingRendering) {
            this.firePropertyChange("border", border2, border);
        }
    }

    public Insets getInsets() {
        Border border = this.getBorder();
        Insets insets = border == null ? EMPTY_INSETS : border.getBorderInsets(this);
        return insets;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (swingRendering) {
            super.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void updateUI() {
        if (swingRendering) {
            super.updateUI();
        } else {
            this.setUI(HtmlLabelUI.createUI(this));
        }
    }

    public Graphics getGraphics() {
        Graphics graphics = null;
        if (this.isDisplayable()) {
            graphics = super.getGraphics();
        }
        if (graphics == null) {
            graphics = HtmlRendererImpl.scratchGraphics();
        }
        return graphics;
    }

    private static final Graphics scratchGraphics() {
        Graphics graphics = null;
        if (scratchGraphics != null && (graphics = scratchGraphics.get()) != null) {
            graphics.setClip(null);
        }
        if (graphics == null) {
            graphics = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1).getGraphics();
            if (!noCacheGraphics) {
                scratchGraphics = new SoftReference<Graphics>(graphics);
            }
        }
        return graphics;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (swingRendering) {
            super.setBounds(n, n2, n3, n4);
        }
        bounds.setBounds(n, n2, n3, n4);
    }

    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        if (swingRendering) {
            super.reshape(n, n2, n3, n4);
        }
    }

    public int getWidth() {
        return HtmlRendererImpl.bounds.width;
    }

    public int getHeight() {
        return HtmlRendererImpl.bounds.height;
    }

    public Point getLocation() {
        return bounds.getLocation();
    }

    public void validate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint() {
    }

    public void invalidate() {
    }

    public void revalidate() {
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        if (swingRendering) {
            super.addAncestorListener(ancestorListener);
        }
    }

    public void addComponentListener(ComponentListener componentListener) {
        if (swingRendering) {
            super.addComponentListener(componentListener);
        }
    }

    public void addContainerListener(ContainerListener containerListener) {
        if (swingRendering) {
            super.addContainerListener(containerListener);
        }
    }

    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        if (swingRendering) {
            super.addHierarchyListener(hierarchyListener);
        }
    }

    public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        if (swingRendering) {
            super.addHierarchyBoundsListener(hierarchyBoundsListener);
        }
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        if (swingRendering) {
            super.addInputMethodListener(inputMethodListener);
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        if (swingRendering) {
            super.addFocusListener(focusListener);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (swingRendering) {
            super.addMouseListener(mouseListener);
        }
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (swingRendering) {
            super.addMouseWheelListener(mouseWheelListener);
        }
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (swingRendering) {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (swingRendering) {
            super.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (swingRendering) {
            super.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (swingRendering) {
            super.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        UNKNOWN,
        TREE,
        LIST,
        TABLE;

    }
}

