/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.javahelp.CopyLinkLocationAction;
import org.netbeans.modules.javahelp.Installer;
import org.netbeans.modules.javahelp.Utils;

public class HyperlinkEventProcessor
extends MouseAdapter
implements HyperlinkListener,
CopyLinkLocationAction.LinkOwner {
    private boolean isInsideHyperlink = false;
    private URL url;
    private JEditorPane pane;
    private JPopupMenu popupMenu;

    private HyperlinkEventProcessor(JEditorPane jEditorPane) {
        this.pane = jEditorPane;
        this.popupMenu = HyperlinkEventProcessor.getPopupMenu(new CopyLinkLocationAction(this));
    }

    static JPopupMenu getPopupMenu(CopyLinkLocationAction copyLinkLocationAction) {
        JMenuItem jMenuItem = new JMenuItem(copyLinkLocationAction);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public static void addTo(JEditorPane jEditorPane) {
        assert (jEditorPane != null);
        HyperlinkEventProcessor hyperlinkEventProcessor = new HyperlinkEventProcessor(jEditorPane);
        jEditorPane.addHyperlinkListener(hyperlinkEventProcessor);
        jEditorPane.addMouseListener(hyperlinkEventProcessor);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        this.url = hyperlinkEvent.getURL();
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (eventType == HyperlinkEvent.EventType.ENTERED) {
            this.isInsideHyperlink = true;
            this.pane.setToolTipText(this.getURLExternalForm());
        } else if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            this.isInsideHyperlink = false;
            this.pane.setToolTipText(null);
        } else if (eventType == HyperlinkEvent.EventType.EXITED) {
            this.isInsideHyperlink = false;
            this.pane.setToolTipText(null);
        } else {
            Installer.log.log(Level.SEVERE, "Unknown hyperlinkEvent: " + hyperlinkEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isInsideHyperlink && Utils.isMouseRightClick(mouseEvent)) {
            Utils.showPopupMenu(mouseEvent, this.popupMenu, this.pane);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public String getURLExternalForm() {
        return this.url == null ? null : this.url.toExternalForm();
    }

    public Clipboard getClipboard() {
        return this.pane.getToolkit().getSystemClipboard();
    }
}

