/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.utils.Autos;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbLocalVariable;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbCallStackFrame
extends CallStackFrame {
    public static boolean enableMacros = Boolean.getBoolean("gdb.autos.macros");
    private final GdbDebugger debugger;
    private final int lineNumber;
    private final String func;
    private final String file;
    private final String fullname;
    private final String resolvedName;
    private final int frameNumber;
    private final String address;
    private final String from;
    private AbstractVariable[] cachedLocalVariables = null;
    private AbstractVariable[] cachedAutos = null;
    private final String LOCALS_LOCK = new String("Locals lock");
    private final String AUTOS_LOCK = new String("Autos lock");
    private boolean destroyed = false;
    private Collection<GdbVariable> arguments = null;
    private StyledDocument document = null;
    private int offset = -1;

    public GdbCallStackFrame(GdbDebugger gdbDebugger, String string, String string2, String string3, String string4, String string5, int n, String string6) {
        this.debugger = gdbDebugger;
        this.func = string;
        this.file = string2;
        this.fullname = string3;
        this.resolvedName = string3 != null ? gdbDebugger.getPathMap().getLocalPath(gdbDebugger.getOSPath(string3)) : null;
        this.address = string5;
        this.frameNumber = n;
        this.from = string6;
        int n2 = -1;
        if (string4 != null) {
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
        } else {
            n2 = -1;
        }
        this.lineNumber = n2;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFunctionName() {
        return this.func;
    }

    public String getFrom() {
        return this.from;
    }

    public String getFileName() {
        return this.file;
    }

    public String getFullname() {
        return this.resolvedName;
    }

    public String getOriginalFullName() {
        return this.fullname;
    }

    public String getAddr() {
        return this.address;
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public boolean isValid() {
        return this.getFileName() != null && this.getOriginalFullName() != null && this.getFunctionName() != null;
    }

    public void popFrame() {
        this.debugger.getGdbProxy().exec_finish();
    }

    public Collection<GdbVariable> getArguments() {
        return this.arguments;
    }

    public void setArguments(Collection<GdbVariable> collection) {
        this.arguments = collection;
    }

    public StyledDocument getDocument() {
        File file;
        if (this.document == null && this.resolvedName != null && this.resolvedName.length() > 0 && (file = new File(this.resolvedName)).exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file));
            this.document = (StyledDocument)CsmUtilities.getDocument((FileObject)fileObject);
        }
        return this.document;
    }

    public int getOffset() {
        if (this.offset < 0 && this.lineNumber >= 0 && this.getDocument() != null) {
            this.offset = NbDocument.findLineOffset((StyledDocument)this.document, (int)(this.lineNumber - 1));
        }
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVariable[] getLocalVariables() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        assert (!SwingUtilities.isEventDispatchThread());
        String string = this.LOCALS_LOCK;
        synchronized (string) {
            if (this.destroyed) {
                return new AbstractVariable[0];
            }
            if (this.cachedLocalVariables == null) {
                List<GdbVariable> list = this.debugger.getLocalVariables();
                int n = list.size();
                AbstractVariable[] abstractVariableArray = new AbstractVariable[n];
                for (int i = 0; i < n; ++i) {
                    abstractVariableArray[i] = new GdbLocalVariable(this.debugger, list.get(i));
                }
                this.cachedLocalVariables = abstractVariableArray;
            }
            return this.cachedLocalVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVariable[] getAutos() {
        String string = this.AUTOS_LOCK;
        synchronized (string) {
            if (this.destroyed) {
                return new AbstractVariable[0];
            }
            if (this.cachedAutos == null) {
                Set set = Autos.get((StyledDocument)this.getDocument(), (int)(this.lineNumber - 1));
                AbstractVariable[] abstractVariableArray = new AbstractVariable[set.size()];
                int n = 0;
                for (String string2 : set) {
                    abstractVariableArray[n++] = new GdbLocalVariable(this.debugger, string2);
                }
                this.cachedAutos = abstractVariableArray;
            }
            return this.cachedAutos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        String string = this.LOCALS_LOCK;
        synchronized (string) {
            this.destroyed = true;
            if (this.cachedLocalVariables != null) {
                for (AbstractVariable abstractVariable : this.cachedLocalVariables) {
                    abstractVariable.destroy();
                }
            }
        }
        string = this.AUTOS_LOCK;
        synchronized (string) {
            if (this.cachedAutos != null) {
                for (AbstractVariable abstractVariable : this.cachedAutos) {
                    abstractVariable.destroy();
                }
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

