/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.ui.log.DiffResultsViewForLine;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryAction;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryTopComponent;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;

public class LogAction
extends SearchHistoryAction {
    public LogAction(String string, VCSContext vCSContext) {
        super(vCSContext);
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        this.openHistory(NbBundle.getMessage(LogAction.class, (String)"MSG_Log_TabTitle", (Object)Utils.getContextDisplayName((VCSContext)this.getContext())));
    }

    private void openHistory(String string) {
        File file = this.getRepositoryRoot();
        File[] fileArray = this.getFiles();
        if (fileArray == null) {
            return;
        }
        LogAction.outputSearchContextTab(file, fileArray, "MSG_Log_Title");
        SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(fileArray);
        searchHistoryTopComponent.setDisplayName(string);
        searchHistoryTopComponent.open();
        searchHistoryTopComponent.requestActive();
        if (fileArray != null && (fileArray.length == 1 && fileArray[0].isFile() || fileArray.length > 1 && Utils.shareCommonDataObject((File[])fileArray))) {
            searchHistoryTopComponent.search();
        }
    }

    public static void openSearch(File file, final int n) {
        SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(file, new SearchHistoryTopComponent.DiffResultsViewFactory(){

            @Override
            DiffResultsView createDiffResultsView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
                return new DiffResultsViewForLine(searchHistoryPanel, list, n);
            }
        });
        String string = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)file.getName());
        searchHistoryTopComponent.setDisplayName(string);
        searchHistoryTopComponent.open();
        searchHistoryTopComponent.requestActive();
    }
}

