/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.mercurial.options.PropertiesTableModel;
import org.netbeans.modules.mercurial.ui.properties.HgPropertiesNode;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.util.NbBundle;

public class PropertiesTable
implements AncestorListener,
TableModelListener {
    public static final String[] PROPERTIES_COLUMNS = new String[]{"name", "value"};
    private PropertiesTableModel tableModel;
    private JTable table;
    private TableSorter sorter;
    private JComponent component;
    private String[] columns;
    private String[] sortByColumns;

    public PropertiesTable(JLabel jLabel, String[] stringArray, String[] stringArray2) {
        this.init(jLabel, stringArray, null);
        this.sortByColumns = stringArray2;
        this.setSortingStatus();
    }

    public PropertiesTable(JLabel jLabel, String[] stringArray, TableSorter tableSorter) {
        this.init(jLabel, stringArray, tableSorter);
    }

    private void init(JLabel jLabel, String[] stringArray, TableSorter tableSorter) {
        this.tableModel = new PropertiesTableModel(stringArray);
        this.tableModel.addTableModelListener(this);
        if (tableSorter == null) {
            tableSorter = new TableSorter((TableModel)this.tableModel);
        }
        this.sorter = tableSorter;
        this.table = new SortedTable(this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new PropertiesTableCellRenderer());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setRowHeight(this.table.getRowHeight());
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 30);
        this.component.setPreferredSize(new Dimension(340, 150));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesTable.class, (String)"ACSD_PropertiesTable"));
        jLabel.setLabelFor(this.table);
        this.setColumns(stringArray);
    }

    public void setColumns(String[] stringArray) {
        if (Arrays.equals(this.columns, stringArray)) {
            return;
        }
        this.columns = stringArray;
        this.tableModel.setColumns(stringArray);
        this.setDefaultColumnSize();
    }

    public JTable getTable() {
        return this.table;
    }

    private void setDefaultColumnSize() {
        int n = this.table.getWidth();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (this.columns == null || tableColumnModel == null) {
            return;
        }
        if (tableColumnModel.getColumnCount() != this.columns.length) {
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String string = this.columns[i];
            this.sorter.setColumnComparator(i, null);
            if (string.equals("name")) {
                tableColumnModel.getColumn(i).setPreferredWidth(n * 20 / 100);
                continue;
            }
            if (!string.equals("value")) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(n * 40 / 100);
        }
    }

    private void setSortingStatus() {
        block0: for (int i = 0; i < this.sortByColumns.length; ++i) {
            String string = this.sortByColumns[i];
            for (int j = 0; j < this.columns.length; ++j) {
                String string2 = this.columns[j];
                if (!string2.equals(string)) continue;
                this.sorter.setSortingStatus(j, string2.equals(string) ? 1 : 0);
                continue block0;
            }
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    void dataChanged() {
        int n = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (n != -1) {
            this.table.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public int getModelIndex(int n) {
        return this.sorter.modelIndex(n);
    }

    public int[] getSelectedItems() {
        return this.table.getSelectedRows();
    }

    public HgPropertiesNode[] getNodes() {
        return this.tableModel.getNodes();
    }

    public void setNodes(HgPropertiesNode[] hgPropertiesNodeArray) {
        this.tableModel.setNodes(hgPropertiesNodeArray);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSize();
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.table.repaint();
    }

    public class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl2, n, n2);
            if (component instanceof JComponent) {
                String string = PropertiesTable.this.tableModel.getNode(PropertiesTable.this.sorter.modelIndex(n)).getValue();
                ((JComponent)component).setToolTipText(string);
            }
            this.setToolTipText(object.toString());
            return component;
        }
    }
}

