/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.modules.mercurial.HgMail;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String PROP_RUN_VERSION = "runVersion";
    public static final String KEY_EXECUTABLE_BINARY = "hgExecBinary";
    public static final String KEY_EXPORT_FILENAME = "hgExportFilename";
    public static final String KEY_EXPORT_FOLDER = "hgExportFolder";
    public static final String KEY_IMPORT_FOLDER = "hgImportFolder";
    public static final String KEY_ANNOTATION_FORMAT = "annotationFormat";
    public static final String SAVE_PASSWORD = "savePassword";
    public static final String KEY_BACKUP_ON_REVERTMODS = "backupOnRevert";
    public static final String KEY_SHOW_HITORY_MERGES = "showHistoryMerges";
    private static final String KEY_SHOW_FILE_INFO = "showFileInfo";
    private static final String AUTO_OPEN_OUTPUT_WINDOW = "autoOpenOutput";
    private static final String CONFIRM_BEFORE_COMMIT_AFTER_MERGE = "confirmBeforeCommitAfterMerge";
    private static final String KEY_INTERNAL_MERGE_TOOL_ENABLED = "hgmerge.internalTool.enabled";
    private static final String RECENT_URL = "repository.recentURL";
    private static final String SHOW_CLONE_COMPLETED = "cloneCompleted.showCloneCompleted";
    private static final String SET_MAIN_PROJECT = "cloneCompleted.setMainProject";
    private static final String URL_EXP = "annotator.urlExp";
    private static final String ANNOTATION_EXP = "annotator.annotationExp";
    public static final String TEXT_ANNOTATIONS_FORMAT_DEFAULT = "{DEFAULT}";
    private static final String DEFAULT_EXPORT_FILENAME = "%b_%r_%h";
    private static final HgModuleConfig INSTANCE = new HgModuleConfig();
    private static String userName;
    private Set<String> exclusions;
    private TableSorter importTableSorter;
    private TableSorter commitTableSorter;

    public static HgModuleConfig getDefault() {
        return INSTANCE;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(HgModuleConfig.class);
    }

    public boolean getShowCloneCompleted() {
        return this.getPreferences().getBoolean(SHOW_CLONE_COMPLETED, true);
    }

    public boolean getSetMainProject() {
        return this.getPreferences().getBoolean(SET_MAIN_PROJECT, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return HgModuleConfig.getDefaultFilePatterns();
    }

    public boolean getShowFileInfo() {
        return this.getPreferences().getBoolean(KEY_SHOW_FILE_INFO, false);
    }

    public boolean isExcludedFromCommit(String string) {
        return this.getCommitExclusions().contains(string);
    }

    public void addExclusionPaths(Collection<String> collection) {
        Set<String> set = this.getCommitExclusions();
        if (set.addAll(collection)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(set));
        }
    }

    public void removeExclusionPaths(Collection<String> collection) {
        Set<String> set = this.getCommitExclusions();
        if (set.removeAll(collection)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(set));
        }
    }

    public String getExecutableBinaryPath() {
        return this.getPreferences().get(KEY_EXECUTABLE_BINARY, "");
    }

    public boolean getBackupOnRevertModifications() {
        return this.getPreferences().getBoolean(KEY_BACKUP_ON_REVERTMODS, true);
    }

    public void setBackupOnRevertModifications(boolean bl) {
        this.getPreferences().putBoolean(KEY_BACKUP_ON_REVERTMODS, bl);
    }

    public boolean getShowHistoryMerges() {
        return this.getPreferences().getBoolean(KEY_SHOW_HITORY_MERGES, true);
    }

    public void setShowHistoryMerges(boolean bl) {
        this.getPreferences().putBoolean(KEY_SHOW_HITORY_MERGES, bl);
    }

    public void setShowFileInfo(boolean bl) {
        this.getPreferences().putBoolean(KEY_SHOW_FILE_INFO, bl);
    }

    public void setExecutableBinaryPath(String string) {
        if (Utilities.isWindows() && string.endsWith("hg.exe")) {
            string = string.substring(0, string.length() - "hg.exe".length());
        } else if (string.endsWith("hg")) {
            string = string.substring(0, string.length() - "hg".length());
        }
        this.getPreferences().put(KEY_EXECUTABLE_BINARY, string);
    }

    public String getExportFolder() {
        return this.getPreferences().get(KEY_EXPORT_FOLDER, System.getProperty("user.home"));
    }

    public void setExportFolder(String string) {
        this.getPreferences().put(KEY_EXPORT_FOLDER, string);
    }

    public String getImportFolder() {
        return this.getPreferences().get(KEY_IMPORT_FOLDER, System.getProperty("user.home"));
    }

    public void setImportFolder(String string) {
        this.getPreferences().put(KEY_IMPORT_FOLDER, string);
    }

    public String getExportFilename() {
        String string = this.getPreferences().get(KEY_EXPORT_FILENAME, "");
        if (string.trim().length() == 0) {
            string = DEFAULT_EXPORT_FILENAME;
        }
        return string;
    }

    public void setExportFilename(String string) {
        this.getPreferences().put(KEY_EXPORT_FILENAME, string);
    }

    public boolean getAutoOpenOutput() {
        return this.getPreferences().getBoolean(AUTO_OPEN_OUTPUT_WINDOW, true);
    }

    public void setAutoOpenOutput(boolean bl) {
        this.getPreferences().putBoolean(AUTO_OPEN_OUTPUT_WINDOW, bl);
    }

    public boolean getConfirmCommitAfterMerge() {
        return this.getPreferences().getBoolean(CONFIRM_BEFORE_COMMIT_AFTER_MERGE, false);
    }

    public void setConfirmCommitAfterMerge(boolean bl) {
        this.getPreferences().putBoolean(CONFIRM_BEFORE_COMMIT_AFTER_MERGE, bl);
    }

    public String getSysUserName() {
        userName = HgConfigFiles.getSysInstance().getSysUserName();
        if (userName.length() == 0) {
            String string;
            String string2 = System.getProperty("user.name");
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string = "localhost";
            }
            userName = string2 + "@" + string;
        }
        return userName;
    }

    public String getSysPushPath() {
        return HgConfigFiles.getSysInstance().getSysPushPath();
    }

    public String getSysPullPath() {
        return HgConfigFiles.getSysInstance().getSysPullPath();
    }

    public void addHgkExtension() throws IOException {
        HgConfigFiles hgConfigFiles = HgConfigFiles.getSysInstance();
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": Cannot set hgext.hgk property");
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            throw hgConfigFiles.getException();
        }
        hgConfigFiles.setProperty("hgext.hgk", "");
    }

    public void setUserName(String string) throws IOException {
        HgConfigFiles hgConfigFiles = HgConfigFiles.getSysInstance();
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": Cannot set username property");
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            throw hgConfigFiles.getException();
        }
        hgConfigFiles.setUserName(string);
    }

    public Boolean isUserNameValid(String string) {
        if (userName == null) {
            this.getSysUserName();
        }
        if (string.equals(userName)) {
            return true;
        }
        if (string.length() == 0) {
            return true;
        }
        return HgMail.isUserNameValid(string);
    }

    public Boolean isExecPathValid(String string) {
        if (string.length() == 0) {
            return true;
        }
        File file = new File(string, "hg");
        if (file.exists() && file.isFile()) {
            return true;
        }
        if (Utilities.isWindows()) {
            for (String string2 : HgCommand.HG_WINDOWS_EXECUTABLES) {
                file = new File(string, string2);
                if (!file.exists() || !file.isFile()) continue;
                return true;
            }
        }
        return false;
    }

    public Properties getProperties(File file) {
        Properties properties = new Properties();
        HgConfigFiles hgConfigFiles = new HgConfigFiles(file);
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot load configuration file");
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            HgModuleConfig.notifyParsingError();
            return null;
        }
        String string = hgConfigFiles.getUserName(false);
        if (string.length() == 0) {
            string = this.getSysUserName();
        }
        if (string.length() > 0) {
            properties.setProperty("username", string);
        } else {
            properties.setProperty("username", "");
        }
        string = hgConfigFiles.getDefaultPull(false);
        if (string.length() == 0) {
            string = this.getSysPullPath();
        }
        if (string.length() > 0) {
            properties.setProperty("default-pull", string);
        } else {
            properties.setProperty("default-pull", "");
        }
        string = hgConfigFiles.getDefaultPush(false);
        if (string.length() == 0) {
            string = this.getSysPushPath();
        }
        if (string.length() > 0) {
            properties.setProperty("default-push", string);
        } else {
            properties.setProperty("default-push", "");
        }
        return properties;
    }

    public void clearProperties(File file, String string) throws IOException {
        HgConfigFiles hgConfigFiles = this.getHgConfigFiles(file);
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot clear properties for {0}", new File[]{file});
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            throw hgConfigFiles.getException();
        }
        hgConfigFiles.clearProperties(string);
    }

    public void removeProperty(File file, String string, String string2) throws IOException {
        HgConfigFiles hgConfigFiles = this.getHgConfigFiles(file);
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot remove property {0} for {1}", new Object[]{string2, file});
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            throw hgConfigFiles.getException();
        }
        hgConfigFiles.removeProperty(string, string2);
    }

    public void setProperty(File file, String string, String string2) throws IOException {
        HgConfigFiles hgConfigFiles = this.getHgConfigFiles(file);
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot set property {0}:{1} for {2}", new Object[]{string, string2, file});
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            throw hgConfigFiles.getException();
        }
        hgConfigFiles.setProperty(string, string2);
    }

    public void setProperty(File file, String string, String string2, String string3, boolean bl) throws IOException {
        HgConfigFiles hgConfigFiles = this.getHgConfigFiles(file);
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot set property {0}:{1} for {2}", new Object[]{string2, string3, file});
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            throw hgConfigFiles.getException();
        }
        hgConfigFiles.setProperty(string, string2, string3, bl);
    }

    public void setProperty(File file, String string, String string2, String string3) throws IOException {
        HgConfigFiles hgConfigFiles = this.getHgConfigFiles(file);
        if (hgConfigFiles.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot set property {0}:{1} for {2}", new Object[]{string2, string3, file});
            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
            throw hgConfigFiles.getException();
        }
        hgConfigFiles.setProperty(string, string2, string3);
    }

    public Properties getProperties(File file, String string) {
        return this.getHgConfigFiles(file).getProperties(string);
    }

    private HgConfigFiles getHgConfigFiles(File file) {
        if (file == null) {
            return HgConfigFiles.getSysInstance();
        }
        return new HgConfigFiles(file);
    }

    public String getAnnotationFormat() {
        return this.getPreferences().get(KEY_ANNOTATION_FORMAT, this.getDefaultAnnotationFormat());
    }

    public String getDefaultAnnotationFormat() {
        return "[{status} {folder}]";
    }

    public void setAnnotationFormat(String string) {
        this.getPreferences().put(KEY_ANNOTATION_FORMAT, string);
    }

    public boolean isInternalMergeToolEnabled() {
        return this.getPreferences().getBoolean(KEY_INTERNAL_MERGE_TOOL_ENABLED, true);
    }

    public void setInternalMergeToolEnabled(boolean bl) {
        this.getPreferences().putBoolean(KEY_INTERNAL_MERGE_TOOL_ENABLED, bl);
    }

    public boolean getSavePassword() {
        return this.getPreferences().getBoolean(SAVE_PASSWORD, true);
    }

    public void setSavePassword(boolean bl) {
        this.getPreferences().putBoolean(SAVE_PASSWORD, bl);
    }

    public void setShowCloneCompleted(boolean bl) {
        this.getPreferences().putBoolean(SHOW_CLONE_COMPLETED, bl);
    }

    public void setSetMainProject(boolean bl) {
        this.getPreferences().putBoolean(SET_MAIN_PROJECT, bl);
    }

    public void insertRecentUrl(RepositoryConnection repositoryConnection) {
        Preferences preferences = this.getPreferences();
        for (String string : Utils.getStringList((Preferences)preferences, (String)RECENT_URL)) {
            RepositoryConnection repositoryConnection2;
            try {
                repositoryConnection2 = RepositoryConnection.parse(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.global.throwing(this.getClass().getName(), "insertRecentUrl", uRISyntaxException);
                continue;
            }
            if (!repositoryConnection2.equals(repositoryConnection)) continue;
            Utils.removeFromArray((Preferences)preferences, (String)RECENT_URL, (String)string);
        }
        Utils.insert((Preferences)preferences, (String)RECENT_URL, (String)RepositoryConnection.getString(repositoryConnection), (int)-1);
    }

    public void setRecentUrls(List<RepositoryConnection> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = 0;
        Object object = list.iterator();
        while (object.hasNext()) {
            ++n;
            RepositoryConnection repositoryConnection = object.next();
            arrayList.add(RepositoryConnection.getString(repositoryConnection));
        }
        object = this.getPreferences();
        Utils.put((Preferences)object, (String)RECENT_URL, arrayList);
    }

    public List<RepositoryConnection> getRecentUrls() {
        Preferences preferences = this.getPreferences();
        List list = Utils.getStringList((Preferences)preferences, (String)RECENT_URL);
        ArrayList<RepositoryConnection> arrayList = new ArrayList<RepositoryConnection>(list.size());
        for (String string : list) {
            try {
                arrayList.add(RepositoryConnection.parse(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.global.throwing(this.getClass().getName(), "getRecentUrls", uRISyntaxException);
            }
        }
        return arrayList;
    }

    public TableSorter getImportTableSorter() {
        return this.importTableSorter;
    }

    public void setImportTableSorter(TableSorter tableSorter) {
        this.importTableSorter = tableSorter;
    }

    public TableSorter getCommitTableSorter() {
        return this.commitTableSorter;
    }

    public void setCommitTableSorter(TableSorter tableSorter) {
        this.commitTableSorter = tableSorter;
    }

    public static void notifyParsingError() {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(HgModuleConfig.class, (String)"MSG_ParsingError"), NbBundle.getMessage(HgModuleConfig.class, (String)"LBL_ParsingError"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
        if (EventQueue.isDispatchThread()) {
            DialogDisplayer.getDefault().notify(notifyDescriptor);
        } else {
            DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
        }
    }

    synchronized Set<String> getCommitExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>(Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS));
        }
        return this.exclusions;
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }
}

