/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.DiskMapTurboProvider;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatusCache {
    public static final String PROP_FILE_STATUS_CHANGED = "status.changed";
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final FileStatus REPOSITORY_STATUS_UNKNOWN = null;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE = new FileInformation(8, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final FileInformation FILE_INFORMATION_NEWLOCALLY = new FileInformation(4, false);
    public static final FileInformation FILE_INFORMATION_CONFLICT = new FileInformation(64, false);
    public static final FileInformation FILE_INFORMATION_REMOVEDLOCALLY = new FileInformation(256, false);
    private PropertyChangeSupport listenerSupport = new PropertyChangeSupport(this);
    private final Turbo turbo;
    private final String FILE_STATUS_MAP = "mercurial.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private Mercurial hg = Mercurial.getInstance();

    FileStatusCache() {
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
    }

    public File[] listFiles(File file) {
        Set<File> set = this.getScannedFiles(file, null).keySet();
        return set.toArray(new File[set.size()]);
    }

    public boolean containsFileOfStatus(VCSContext vCSContext, int n, boolean bl, boolean bl2) {
        Map<File, FileInformation> map;
        Map<File, FileInformation> map2 = map = bl2 ? this.cacheProvider.getCachedValues() : this.cacheProvider.getAllModifiedValues();
        if (map == null) {
            Mercurial.LOG.log(Level.FINE, "containsFileOfStatus(): allFiles == null");
            return false;
        }
        Set set = vCSContext.getRootFiles();
        Set set2 = vCSContext.getExclusions();
        boolean bl3 = set2 != null && set2.size() > 0;
        boolean bl4 = false;
        for (Map.Entry<File, FileInformation> entry : map.entrySet()) {
            File file = entry.getKey();
            FileInformation fileInformation = entry.getValue();
            if ((fileInformation.getStatus() & n) == 0) continue;
            for (File file2 : set) {
                if (VersioningSupport.isFlat((File)file2)) {
                    if (!file.equals(file2) && !file.getParentFile().equals(file2)) continue;
                    bl4 = true;
                    break;
                }
                if (!Utils.isAncestorOrEqual((File)file2, (File)file)) continue;
                File file3 = this.hg.getRepositoryRoot(file);
                File file4 = this.hg.getRepositoryRoot(file2);
                if (file4 == null || !file4.equals(file3)) continue;
                bl4 = true;
                break;
            }
            if (bl4 && bl3) {
                for (File file2 : set2) {
                    if (Utils.isAncestorOrEqual((File)file2, (File)file)) continue;
                    return true;
                }
                continue;
            }
            if (!bl4) continue;
            return true;
        }
        return false;
    }

    public File[] listFiles(VCSContext vCSContext, int n) {
        Serializable serializable;
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        if (map == null) {
            Mercurial.LOG.log(Level.FINE, "FileStatusCache: listFiles(): allFiles == null");
            return new File[0];
        }
        block0: for (Map.Entry<File, FileInformation> object2 : map.entrySet()) {
            object = object2.getKey();
            serializable = object2.getValue();
            if ((serializable.getStatus() & n) == 0) continue;
            Set set = vCSContext.getRootFiles();
            for (File file : set) {
                if (VersioningSupport.isFlat((File)file)) {
                    if (!((File)object).equals(file) && !((File)object).getParentFile().equals(file)) continue;
                    hashSet.add(object);
                    continue block0;
                }
                if (!Utils.isAncestorOrEqual((File)file, (File)object)) continue;
                File file2 = this.hg.getRepositoryRoot((File)object);
                File file3 = this.hg.getRepositoryRoot(file);
                if (file3 == null || !file3.equals(file2)) continue;
                hashSet.add(object);
                continue block0;
            }
        }
        if (vCSContext.getExclusions().size() > 0) {
            for (File file : vCSContext.getExclusions()) {
                object = hashSet.iterator();
                while (object.hasNext()) {
                    serializable = (File)object.next();
                    if (!Utils.isAncestorOrEqual((File)file, (File)serializable)) continue;
                    object.remove();
                }
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public File[] listFiles(File[] fileArray, int n) {
        HashSet<File> hashSet = new HashSet<File>();
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        block0: for (Map.Entry<File, FileInformation> entry : map.entrySet()) {
            File file = entry.getKey();
            FileInformation fileInformation = entry.getValue();
            if ((fileInformation.getStatus() & n) == 0) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (VersioningSupport.isFlat((File)file2)) {
                    if (!file.getParentFile().equals(file2)) continue;
                    hashSet.add(file);
                    continue block0;
                }
                if (!Utils.isAncestorOrEqual((File)file2, (File)file)) continue;
                hashSet.add(file);
                continue block0;
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public FileInformation getStatus(File file) {
        if (file.isDirectory() && (HgUtils.isAdministrative(file) || HgUtils.isIgnored(file))) {
            return FILE_INFORMATION_EXCLUDED_DIRECTORY;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2, null);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        if (fileInformation != null) {
            return fileInformation;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
        return new FileInformation(8, false);
    }

    public FileInformation getCachedStatus(File file) {
        FileInformation fileInformation;
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map map = (Map)this.turbo.readEntry((Object)file2, "mercurial.STATUS_MAP");
        FileInformation fileInformation2 = fileInformation = map != null ? (FileInformation)map.get(file) : null;
        if (fileInformation != null) {
            return fileInformation;
        }
        if (file.isDirectory()) {
            return FILE_INFORMATION_UPTODATE_DIRECTORY;
        }
        return fileInformation;
    }

    private FileInformation refresh(File file, FileStatus fileStatus, boolean bl) {
        Mercurial.LOG.log(Level.FINE, "refresh(): {0}", file);
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2, null);
        if (map == NOT_MANAGED_MAP && fileStatus == REPOSITORY_STATUS_UNKNOWN) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        FileInformation fileInformation2 = this.createFileInformation(file);
        if (FileStatusCache.equivalent(fileInformation2, fileInformation)) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, fileInformation2);
            }
            return fileInformation2;
        }
        if (fileInformation == null && !fileInformation2.isDirectory() && fileInformation2.getStatus() == 8) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, fileInformation2);
            }
            return fileInformation2;
        }
        file = FileUtil.normalizeFile((File)file);
        file2 = FileUtil.normalizeFile((File)file2);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map);
        if (fileInformation2.getStatus() == 0) {
            hashMap.remove(file);
            this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", null);
        } else if (fileInformation2.getStatus() == 8 && file.isFile()) {
            hashMap.remove(file);
        } else {
            hashMap.put(file, fileInformation2);
        }
        this.turbo.writeEntry((Object)file2, "mercurial.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
        if (file.isDirectory() && this.needRecursiveRefresh(fileInformation2, fileInformation)) {
            File[] fileArray = this.listFiles(file);
            for (int i = 0; i < fileArray.length; ++i) {
                this.refresh(fileArray[i], REPOSITORY_STATUS_UNKNOWN);
            }
        }
        this.fireFileStatusChanged(file, fileInformation, fileInformation2);
        return fileInformation2;
    }

    private FileInformation createFileInformation(File file) {
        return this.createFileInformation(file, true);
    }

    private FileInformation createFileInformation(File file, Boolean bl) {
        FileInformation fileInformation;
        Mercurial.LOG.log(Level.FINE, "createFileInformation(): {0} {1}", new Object[]{file, bl});
        if (file == null) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (HgUtils.isAdministrative(file)) {
            return FILE_INFORMATION_EXCLUDED_DIRECTORY;
        }
        File file2 = this.hg.getRepositoryRoot(file);
        if (file2 == null) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            if (HgUtils.isIgnored(file)) {
                return FILE_INFORMATION_EXCLUDED_DIRECTORY;
            }
            return FILE_INFORMATION_UPTODATE_DIRECTORY;
        }
        if (!bl.booleanValue()) {
            if (HgUtils.isIgnored(file)) {
                return FILE_INFORMATION_EXCLUDED;
            }
            return null;
        }
        try {
            fileInformation = HgCommand.getSingleStatus(file2, file.getParent(), file.getName());
        }
        catch (HgException hgException) {
            Mercurial.LOG.log(Level.FINE, "createFileInformation() file: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
            return FILE_INFORMATION_UNKNOWN;
        }
        return fileInformation;
    }

    public FileInformation refresh(File file, FileStatus fileStatus) {
        return this.refresh(file, fileStatus, false);
    }

    public Map<File, FileInformation> getScannedFiles(File file, Map<File, FileInformation> map) {
        Map<File, FileInformation> map2 = (Map<File, FileInformation>)this.turbo.readEntry((Object)file, "mercurial.STATUS_MAP");
        if (map2 != null) {
            return map2;
        }
        if (this.isNotManagedByDefault(file) && map == null) {
            return NOT_MANAGED_MAP;
        }
        map2 = this.scanFolder(file = FileUtil.normalizeFile((File)file), map);
        this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", map2.size() == 0 ? null : map2);
        for (Map.Entry<File, FileInformation> entry : map2.entrySet()) {
            File file2 = entry.getKey();
            FileInformation fileInformation = entry.getValue();
            if ((fileInformation.getStatus() & 0x19D6) == 0) continue;
            this.fireFileStatusChanged(file2, null, fileInformation);
        }
        return map2;
    }

    public void refreshFileStatus(File file, FileInformation fileInformation, Map<File, FileInformation> map) {
        this.refreshFileStatus(file, fileInformation, map, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void refreshFileStatus(File file, FileInformation fileInformation, Map<File, FileInformation> map, boolean bl) {
        FileInformation fileInformation2;
        Map<File, FileInformation> map2;
        File file2;
        block19: {
            if (file == null || fileInformation == null) {
                return;
            }
            file2 = file.getParentFile();
            if (file2 == null) {
                return;
            }
            map2 = this.getScannedFiles(file2, map);
            if (map2 == null || map2 == NOT_MANAGED_MAP) {
                return;
            }
            fileInformation2 = map2.get(file);
            if (FileStatusCache.equivalent(fileInformation, fileInformation2)) {
                if (FileStatusCache.equivalent(FILE_INFORMATION_NEWLOCALLY, fileInformation)) {
                    if (HgUtils.isIgnored(file)) {
                        Mercurial.LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is NotSharable", file.getAbsolutePath());
                        fileInformation = FILE_INFORMATION_EXCLUDED;
                        break block19;
                    } else {
                        if (bl) {
                            this.fireFileStatusChanged(file, null, fileInformation);
                        }
                        return;
                    }
                }
                if (!FileStatusCache.equivalent(FILE_INFORMATION_REMOVEDLOCALLY, fileInformation)) {
                    if (bl) {
                        this.fireFileStatusChanged(file, null, fileInformation);
                    }
                    return;
                }
            }
        }
        if (FileStatusCache.equivalent(FILE_INFORMATION_NEWLOCALLY, fileInformation)) {
            if (FileStatusCache.equivalent(FILE_INFORMATION_EXCLUDED, fileInformation2)) {
                Mercurial.LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is Excluded", file.getAbsolutePath());
                if (bl) {
                    this.fireFileStatusChanged(file, null, fileInformation);
                }
                return;
            }
            if (fileInformation2 == null && HgUtils.isIgnored(file)) {
                Mercurial.LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but current is null and is not NotSharable", file.getAbsolutePath());
                fileInformation = FILE_INFORMATION_EXCLUDED;
            }
        }
        file = FileUtil.normalizeFile((File)file);
        file2 = FileUtil.normalizeFile((File)file2);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map2);
        if (fileInformation.getStatus() == 0) {
            hashMap.remove(file);
            this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", null);
        } else if (fileInformation.getStatus() == 8 && file.isFile()) {
            hashMap.remove(file);
        } else {
            hashMap.put(file, fileInformation);
        }
        assert (!hashMap.containsKey(file2));
        this.turbo.writeEntry((Object)file2, "mercurial.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
        this.fireFileStatusChanged(file, fileInformation2, fileInformation);
    }

    private static boolean equivalent(FileInformation fileInformation, FileInformation fileInformation2) {
        FileStatus fileStatus;
        if (fileInformation2 == null || fileInformation.getStatus() != fileInformation2.getStatus() || fileInformation.isDirectory() != fileInformation2.isDirectory()) {
            return false;
        }
        FileStatus fileStatus2 = fileInformation.getStatus(null);
        return fileStatus2 == (fileStatus = fileInformation2.getStatus(null)) || fileStatus2 == null || fileStatus == null || FileStatusCache.equal(fileStatus2, fileStatus);
    }

    private static boolean equal(FileStatus fileStatus, FileStatus fileStatus2) {
        return true;
    }

    private boolean needRecursiveRefresh(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation.getStatus() == 2 || fileInformation2 != null && fileInformation2.getStatus() == 2) {
            return true;
        }
        return fileInformation.getStatus() == 1 || fileInformation2 != null && fileInformation2.getStatus() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshAll(File file) {
        if (file.isDirectory()) {
            File file2 = Mercurial.getInstance().getRepositoryRoot(file);
            if (file2 == null) {
                return;
            }
            Map map = (Map)this.turbo.readEntry((Object)file, "mercurial.STATUS_MAP");
            try {
                File file3;
                Map<File, FileInformation> map2 = HgCommand.getInterestingStatus(file2, Collections.singletonList(file));
                for (Map.Entry<File, FileInformation> entry : map2.entrySet()) {
                    file3 = entry.getKey();
                    FileInformation fileInformation = entry.getValue();
                    Mercurial.LOG.log(Level.FINE, "refreshAll() file: {0} {1} ", new Object[]{file3.getAbsolutePath(), fileInformation});
                    this.refreshFileStatus(file3, fileInformation, map2);
                }
                if (map == null) return;
                for (Map.Entry<File, FileInformation> entry : map.entrySet()) {
                    file3 = entry.getKey();
                    if (!file3.isFile() && file3.exists() || map2.containsKey(file3)) continue;
                    Mercurial.LOG.log(Level.FINE, "refreshAll() uninteresting file: {0} {1}", new Object[]{file3, entry.getValue()});
                    this.refresh(file3, REPOSITORY_STATUS_UNKNOWN);
                }
                return;
            }
            catch (HgException hgException) {
                Mercurial.LOG.log(Level.FINE, "refreshAll() file: {0} {1} { 2} ", new Object[]{file2.getAbsolutePath(), file.getAbsolutePath(), hgException.toString()});
                return;
            }
        } else {
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    public void refreshAllRoots(Map<File, Set<File>> map) {
        for (Map.Entry<File, Set<File>> entry : map.entrySet()) {
            File file = entry.getKey();
            for (File file2 : entry.getValue()) {
                if (Mercurial.LOG.isLoggable(Level.FINE)) {
                    Mercurial.LOG.log(Level.FINE, "refreshAllRoots() root: {0}, repositoryRoot: {1} ", new Object[]{file2.getAbsolutePath(), file.getAbsolutePath()});
                }
                Map<File, FileInformation> map2 = this.getAllModifiedFiles();
                try {
                    FileInformation fileInformation;
                    File file3;
                    Map<File, FileInformation> map3 = HgCommand.getInterestingStatus(file, Collections.singletonList(file2));
                    for (Map.Entry<File, FileInformation> entry2 : map3.entrySet()) {
                        file3 = entry2.getKey();
                        fileInformation = entry2.getValue();
                        Mercurial.LOG.log(Level.FINE, "refreshAllRoots() file: {0} {1} ", new Object[]{file3.getAbsolutePath(), fileInformation});
                        this.refreshFileStatus(file3, fileInformation, map3);
                    }
                    for (Map.Entry<File, FileInformation> entry2 : map2.entrySet()) {
                        file3 = entry2.getKey();
                        fileInformation = entry2.getValue();
                        boolean bl = file3.exists();
                        if (map3.containsKey(file3) || !Utils.isAncestorOrEqual((File)file2, (File)file3) || ((fileInformation.getStatus() & 2) == 0 || bl) && ((fileInformation.getStatus() & 2) != 0 || bl && !file3.isFile())) continue;
                        Mercurial.LOG.log(Level.FINE, "refreshAllRoots() uninteresting file: {0} {1}", new Object[]{file3, fileInformation});
                        if (HgCommand.existsConflictFile(file3.getAbsolutePath())) {
                            this.refreshFileStatus(file3, FILE_INFORMATION_CONFLICT, map3);
                            continue;
                        }
                        this.refreshFileStatus(file3, FILE_INFORMATION_UNKNOWN, map3);
                    }
                }
                catch (HgException hgException) {
                    Mercurial.LOG.log(Level.FINE, "refreshAll() file: {0} {1} {2} ", new Object[]{file.getAbsolutePath(), file2.getAbsolutePath(), hgException.toString()});
                }
            }
        }
    }

    public void refreshCached(File file) {
        if (file.isDirectory()) {
            File file2 = Mercurial.getInstance().getRepositoryRoot(file);
            if (file2 == null) {
                return;
            }
            File[] fileArray = new File[]{file};
            File[] fileArray2 = this.listFiles(fileArray, -1);
            if (fileArray2.length == 0) {
                return;
            }
            try {
                Map<File, FileInformation> map = HgCommand.getAllStatus(file2, file);
                for (int i = 0; i < fileArray2.length; ++i) {
                    File file3 = fileArray2[i];
                    FileInformation fileInformation = map.get(file3);
                    if (fileInformation == null) {
                        File file4 = file3.getParentFile();
                        Map map2 = (Map)this.turbo.readEntry((Object)file4, "mercurial.STATUS_MAP");
                        if (map2 != null) {
                            HashMap hashMap = new HashMap(map2);
                            hashMap.remove(file3);
                            this.turbo.writeEntry((Object)file4, "mercurial.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
                        } else {
                            this.turbo.writeEntry((Object)file4, "mercurial.STATUS_MAP", null);
                        }
                        fileInformation = map2 != null ? (FileInformation)map2.get(file3) : null;
                        this.fireFileStatusChanged(file3, fileInformation, FILE_INFORMATION_UNKNOWN);
                        continue;
                    }
                    this.refreshFileStatus(file3, fileInformation, null);
                }
            }
            catch (HgException hgException) {
                Mercurial.LOG.log(Level.FINE, "refreshCached() file: {0} {1} { 2} ", new Object[]{file2.getAbsolutePath(), file.getAbsolutePath(), hgException.toString()});
            }
        } else {
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    public void refreshCached(VCSContext vCSContext) {
        for (File file : vCSContext.getRootFiles()) {
            this.refreshCached(file);
        }
    }

    public void addToCache(Set<File> set) {
        HashMap<File, FileInformation> hashMap;
        File file;
        FileInformation fileInformation = new FileInformation(4, null, false);
        HashMap<File, HashMap<File, FileInformation>> hashMap2 = new HashMap<File, HashMap<File, FileInformation>>(set.size());
        for (File file2 : set) {
            file = file2.getParentFile();
            File object = FileUtil.normalizeFile((File)file2);
            hashMap = (HashMap<File, FileInformation>)hashMap2.get(file = FileUtil.normalizeFile((File)file));
            if (hashMap == null) {
                hashMap = new HashMap<File, FileInformation>(20);
                hashMap2.put(file, hashMap);
            }
            hashMap.put(object, fileInformation);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            file = FileUtil.normalizeFile((File)((File)entry.getKey()));
            hashMap = (Map)entry.getValue();
            this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", hashMap);
        }
    }

    Map<File, FileInformation> getAllModifiedFiles() {
        return this.cacheProvider.getAllModifiedValues();
    }

    Map<File, FileInformation> getAllModifiedFilesCached(boolean[] blArray) {
        blArray[0] = this.cacheProvider.modifiedFilesChanged();
        return this.cacheProvider.getCachedValues();
    }

    private boolean isNotManagedByDefault(File file) {
        return !file.exists();
    }

    private Map<File, FileInformation> scanFolder(File file, Map<File, FileInformation> map) {
        Cloneable cloneable;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (map == null) {
                fileArray = new File[]{};
            } else {
                cloneable = new HashSet(15);
                for (File fileArray2 : map.keySet()) {
                    if (!file.equals(fileArray2.getParentFile())) continue;
                    cloneable.add(fileArray2);
                }
                fileArray = cloneable.toArray(new File[cloneable.size()]);
            }
        }
        cloneable = new HashMap(fileArray.length);
        Mercurial.LOG.log(Level.FINE, "scanFolder(): {0}", file);
        if (HgUtils.isAdministrative(file)) {
            cloneable.put(file, FILE_INFORMATION_EXCLUDED_DIRECTORY);
            return cloneable;
        }
        File file2 = this.hg.getRepositoryRoot(file);
        if (file2 == null) {
            for (File file3 : fileArray) {
                if (!file3.isDirectory() || this.hg.getRepositoryRoot(file3) == null) continue;
                if (HgUtils.isAdministrative(file3) || HgUtils.isIgnored(file3)) {
                    Mercurial.LOG.log(Level.FINE, "scanFolder NotMng Ignored Dir {0}: exclude SubDir: {1}", new Object[]{file.getAbsolutePath(), file3.getName()});
                    cloneable.put(file3, FILE_INFORMATION_EXCLUDED_DIRECTORY);
                    continue;
                }
                Mercurial.LOG.log(Level.FINE, "scanFolder NotMng Dir {0}: up to date Dir: {1}", new Object[]{file.getAbsolutePath(), file3.getName()});
                cloneable.put(file3, FILE_INFORMATION_UPTODATE_DIRECTORY);
            }
            return cloneable;
        }
        boolean bl = HgUtils.isIgnored(file);
        if (bl) {
            for (File file5 : fileArray) {
                if (HgUtils.isPartOfMercurialMetadata(file5)) continue;
                if (file5.isDirectory()) {
                    cloneable.put(file5, FILE_INFORMATION_EXCLUDED_DIRECTORY);
                    Mercurial.LOG.log(Level.FINE, "scanFolder Mng Ignored Dir {0}: exclude SubDir: {1}", new Object[]{file.getAbsolutePath(), file5.getName()});
                    continue;
                }
                Mercurial.LOG.log(Level.FINE, "scanFolder Mng Ignored Dir {0}: exclude File: {1}", new Object[]{file.getAbsolutePath(), file5.getName()});
                cloneable.put(file5, FILE_INFORMATION_EXCLUDED);
            }
            return cloneable;
        }
        if (!Mercurial.getInstance().isAvailable()) {
            return cloneable;
        }
        if (map == null) {
            try {
                long hgException = 0L;
                if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
                    hgException = System.currentTimeMillis();
                    Mercurial.STATUS_LOG.fine("scanFolder: start for " + file.getAbsolutePath());
                }
                map = HgCommand.getInterestingStatus(file2, Collections.singletonList(file));
                if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
                    Mercurial.STATUS_LOG.fine("scanFolder: finishes for " + file.getAbsolutePath() + " after " + (System.currentTimeMillis() - hgException));
                }
            }
            catch (HgException hgException) {
                Mercurial.LOG.log(Level.FINE, "scanFolder() getInterestingStatus Exception: dir: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
                return cloneable;
            }
        }
        if (map == null) {
            return cloneable;
        }
        for (File file4 : fileArray) {
            if (HgUtils.isPartOfMercurialMetadata(file4)) continue;
            if (file4.isDirectory()) {
                if (HgUtils.isAdministrative(file4) || HgUtils.isIgnored(file4)) {
                    Mercurial.LOG.log(Level.FINE, "scanFolder Mng Dir {0}: exclude Dir: {1}", new Object[]{file.getAbsolutePath(), file4.getName()});
                    cloneable.put(file4, FILE_INFORMATION_EXCLUDED_DIRECTORY);
                    continue;
                }
                Mercurial.LOG.log(Level.FINE, "scanFolder Mng Dir {0}: up to date Dir: {1}", new Object[]{file.getAbsolutePath(), file4.getName()});
                cloneable.put(file4, FILE_INFORMATION_UPTODATE_DIRECTORY);
                continue;
            }
            FileInformation fileInformation = map.get(file4);
            if (fileInformation == null) {
                fileInformation = this.createFileInformation(file4, false);
            }
            if (fileInformation == null || fileInformation.getStatus() == 8) continue;
            cloneable.put(file4, fileInformation);
        }
        return cloneable;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireFileStatusChanged(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        this.listenerSupport.firePropertyChange(PROP_FILE_STATUS_CHANGED, null, new ChangedEvent(file, fileInformation, fileInformation2));
    }

    public void notifyFileChanged(File file) {
        this.fireFileStatusChanged(file, null, FILE_INFORMATION_UPTODATE);
    }

    public static class ChangedEvent {
        private File file;
        private FileInformation oldInfo;
        private FileInformation newInfo;

        public ChangedEvent(File file, FileInformation fileInformation, FileInformation fileInformation2) {
            this.file = file;
            this.oldInfo = fileInformation;
            this.newInfo = fileInformation2;
        }

        public File getFile() {
            return this.file;
        }

        public FileInformation getOldInfo() {
            return this.oldInfo;
        }

        public FileInformation getNewInfo() {
            return this.newInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set<Map.Entry<File, FileInformation>> entrySet() {
            return Collections.emptySet();
        }
    }
}

