/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.Resource;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.Network;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.friends.chat.ChatFrame;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatFriendRenderer;
import org.limewire.ui.swing.friends.chat.ChatModel;
import org.limewire.ui.swing.friends.chat.ConversationPanel;
import org.limewire.ui.swing.table.GlazedJXTable;
import org.limewire.ui.swing.table.TablePopupHandler;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.Objects;

@LazySingleton
class ChatFriendList
extends GlazedJXTable {
    @Resource
    private Color backgroundColor;
    @Resource
    private Color tooltipBackground;
    private TablePopupHandler popupHandler;
    final FilterList<ChatFriend> filter;
    private final Provider<ChatFrame> chatFrame;

    @Inject
    public ChatFriendList(ChatModel chatModel, ConversationPanel conversationPanel, Provider<ChatFrame> chatFrame) {
        this.chatFrame = chatFrame;
        GuiUtils.assignResources(this);
        this.initialize();
        ObservableElementList<ChatFriend> observableList = GlazedListsFactory.observableElementList(chatModel.getChatFriendList(), GlazedLists.beanConnector(ChatFriend.class));
        SortedList<ChatFriend> sortedFriends = GlazedListsFactory.sortedList(observableList, new AvailableComparator());
        TextMatcherEditor<ChatFriend> editor = new TextMatcherEditor<ChatFriend>(new FriendFilterator());
        this.filter = GlazedListsFactory.filterList(sortedFriends, editor);
        this.setModel(new DefaultEventTableModel<ChatFriend>(this.filter, new ChatTableFormat()));
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(new ChatFriendRenderer(conversationPanel));
    }

    private void initialize() {
        this.setBackground(this.backgroundColor);
        this.setFillsViewportHeight(true);
        this.setSelectionMode(0);
        this.setShowGrid(false, false);
        this.setTableHeader(null);
        this.setRowHeight(18);
    }

    @Inject
    void register() {
        CloseListener listener = new CloseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger() && ChatFriendList.this.popupHandler != null) {
                    int col = ChatFriendList.this.columnAtPoint(e.getPoint());
                    int row = ChatFriendList.this.rowAtPoint(e.getPoint());
                    if (row >= 0 && col >= 0) {
                        ChatFriendList.this.getSelectionModel().setSelectionInterval(row, row);
                        ChatFriendList.this.popupHandler.maybeShowPopup(e.getComponent(), e.getX(), e.getY());
                        TableCellEditor editor = ChatFriendList.this.getCellEditor();
                        if (editor != null) {
                            editor.cancelCellEditing();
                        }
                    }
                }
            }
        });
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip tooltip = super.createToolTip();
        tooltip.setBackground(this.tooltipBackground);
        return tooltip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point mousePoint = event.getPoint();
        int row = this.rowAtPoint(mousePoint);
        if (row == -1) {
            return null;
        }
        ChatFriend chatFriend = (ChatFriend)this.filter.get(row);
        if (chatFriend.isChatting() && this.isOverClose(mousePoint)) {
            return I18n.tr("Close Conversation");
        }
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html>").append("<head>").append("<style>body { margin: 2px 10px 2px 4px;}</style>").append("</head>").append("<body>").append("<img src=\"").append(this.getIconURL(chatFriend.getMode())).append("\"/>&nbsp;").append("<b>").append(chatFriend.getName());
        if (chatFriend.getFriend().getNetwork().getType() != Network.Type.FACEBOOK) {
            tooltip.append(" &lt;").append(chatFriend.getID()).append("&gt;");
        }
        tooltip.append("</b><br/>");
        String status = chatFriend.getStatus();
        if (status != null && status.length() > 0) {
            tooltip.append("<div>").append("<b>" + I18n.tr("Status: ") + "</b>").append(status).append("</div>");
        }
        tooltip.append("</body>").append("</html>");
        return tooltip.toString();
    }

    public ChatFriend getSelectedFriend() {
        int selectedIndex = this.getSelectedRow();
        if (selectedIndex >= 0 && selectedIndex < this.getRowCount()) {
            return (ChatFriend)this.filter.get(selectedIndex);
        }
        return null;
    }

    public void setPopupHandler(TablePopupHandler popupHandler) {
        this.popupHandler = popupHandler;
    }

    private boolean isOverClose(Point mousePosition) {
        return mousePosition.x > 2 && mousePosition.x < 10;
    }

    private String getIconURL(FriendPresence.Mode mode) {
        switch (mode) {
            case available: {
                return this.getURL("/org/limewire/ui/swing/mainframe/resources/icons/friends/available.png");
            }
            case dnd: {
                return this.getURL("/org/limewire/ui/swing/mainframe/resources/icons/friends/doNotDisturb.png");
            }
        }
        return this.getURL("/org/limewire/ui/swing/mainframe/resources/icons/friends/away.png");
    }

    private String getURL(String path) {
        URL resource = ChatFriendList.class.getResource(path);
        return resource != null ? resource.toExternalForm() : "";
    }

    private class CloseListener
    extends MouseAdapter {
        private CloseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = ChatFriendList.this.rowAtPoint(e.getPoint());
            if (row >= 0) {
                ChatFriend friend = (ChatFriend)ChatFriendList.this.filter.get(row);
                if (friend.isChatting() && ChatFriendList.this.isOverClose(e.getPoint())) {
                    ChatFriendList.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    ChatFriendList.this.setCursor(Cursor.getDefaultCursor());
                }
            } else {
                ChatFriendList.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ChatFriend friend;
            int row = ChatFriendList.this.rowAtPoint(e.getPoint());
            if (row >= 0 && (friend = (ChatFriend)ChatFriendList.this.filter.get(row)).isChatting() && ChatFriendList.this.isOverClose(e.getPoint()) && e.getClickCount() == 1 && e.getButton() == 1) {
                ((ChatFrame)ChatFriendList.this.chatFrame.get()).closeConversation(friend);
                ChatFriendList.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ChatFriendList.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class FriendFilterator
    implements TextFilterator<ChatFriend> {
        private FriendFilterator() {
        }

        @Override
        public void getFilterStrings(List<String> baseList, ChatFriend element) {
            baseList.add(element.getName());
        }
    }

    private class AvailableComparator
    implements Comparator<ChatFriend> {
        private AvailableComparator() {
        }

        @Override
        public int compare(ChatFriend friend1, ChatFriend friend2) {
            int friend2ModeIndex;
            boolean friend2IsChatting;
            boolean friend1IsChatting = friend1.isChatting() || friend1.hasUnviewedMessages();
            boolean bl = friend2IsChatting = friend2.isChatting() || friend2.hasUnviewedMessages();
            if (friend1IsChatting && friend2IsChatting) {
                return friend1.getChatStartTime() < friend2.getChatStartTime() ? -1 : (friend1.getChatStartTime() == friend2.getChatStartTime() ? 0 : 1);
            }
            if (friend1IsChatting) {
                return -1;
            }
            if (friend2IsChatting) {
                return 1;
            }
            int friend1ModeIndex = friend1.getMode().getOrder();
            if (friend1ModeIndex > (friend2ModeIndex = friend2.getMode().getOrder())) {
                return 1;
            }
            if (friend2ModeIndex > friend1ModeIndex) {
                return -1;
            }
            return Objects.compareToNullIgnoreCase(friend1.getName(), friend2.getName(), false);
        }
    }

    private static class ChatTableFormat
    implements TableFormat<ChatFriend> {
        private ChatTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Object getColumnValue(ChatFriend chatFriend, int column) {
            return chatFriend;
        }
    }
}

