/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import javax.swing.JTextField;
import org.limewire.ui.swing.components.FilteredDocument;
import org.limewire.ui.swing.components.TextFieldClipboardControl;

public class NumericTextField
extends JTextField {
    public NumericTextField(int columns) {
        this(columns, 0, Integer.MAX_VALUE);
    }

    public NumericTextField(int columns, int minValue, int maxValue) {
        super(columns);
        this.addIntegerWithMaxValueFilter(minValue, maxValue);
        TextFieldClipboardControl.install(this);
    }

    public int getValue(int defaultValue) {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            this.setValue(defaultValue);
            return defaultValue;
        }
    }

    public void setValue(int value) {
        this.setText(String.valueOf(value));
    }

    private void addIntegerWithMaxValueFilter(int minValue, int maxValue) {
        FilteredDocument document = new FilteredDocument();
        document.setMinBound(minValue);
        document.setMaxBound(maxValue);
        this.setDocument(document);
    }
}

