/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.UDPSelectionKey;
import org.limewire.rudp.UDPSocketChannel;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.SynMessage;

public class UDPMultiplexor
extends AbstractSelector {
    private static final Log LOG = LogFactory.getLog(UDPMultiplexor.class);
    public static final byte UNASSIGNED_SLOT = 0;
    private volatile UDPSocketChannel[] _channels;
    private final List<SelectableChannel> channelsToRemove = new LinkedList<SelectableChannel>();
    private Set<SelectionKey> selectedKeys = new HashSet<SelectionKey>(256);
    private int _lastConnectionID;
    private final RUDPContext context;

    UDPMultiplexor(SelectorProvider provider, RUDPContext context) {
        super(provider);
        this.context = context;
        this._channels = new UDPSocketChannel[256];
        this._lastConnectionID = 0;
    }

    public boolean isConnectedTo(InetAddress host) {
        UDPSocketChannel[] array = this._channels;
        if (this._lastConnectionID == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            UDPSocketChannel channel = array[i];
            if (channel == null || !host.equals(channel.getRemoteSocketAddress().getAddress())) continue;
            return true;
        }
        return false;
    }

    public void routeMessage(RUDPMessage msg, InetSocketAddress addr) {
        UDPSocketChannel[] array = this._channels;
        int connID = msg.getConnectionID() & 0xFF;
        UDPSocketChannel channel = null;
        if (connID == 0 && msg instanceof SynMessage) {
            LOG.debugf("route sym: {0}", (Object)msg);
            for (int i = 1; i < array.length; ++i) {
                channel = array[i];
                if (channel == null) continue;
                LOG.debugf("non-empty index: {0}, addr: {1}", (Object)i, (Object)channel.getRemoteSocketAddress());
                if (!channel.isConnectionPending() || !channel.isForMe(addr, (SynMessage)msg)) continue;
                LOG.debugf("found index: {0}, sender id: {1}", (Object)i, (Object)((SynMessage)msg).getSenderConnectionID());
                channel.getProcessor().handleMessage(msg);
                break;
            }
        } else if (array[connID] != null) {
            channel = array[connID];
            if (msg instanceof SynMessage) {
                LOG.debugf("already assigned syn: {0}", (Object)msg);
            }
            if (channel.getRemoteSocketAddress().equals(addr)) {
                channel.getProcessor().handleMessage(msg);
            }
        } else {
            LOG.debugf("message for non-existing connection: {0}", (Object)msg);
        }
        if (channel != null && channel.getProcessor().readyOps() != 0) {
            this.context.getTransportListener().eventPending();
        }
    }

    @Override
    protected void implCloseSelector() throws IOException {
        throw new IllegalStateException("should never be closed.");
    }

    @Override
    protected synchronized SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        int i;
        if (!(ch instanceof UDPSocketChannel)) {
            throw new IllegalSelectorException();
        }
        UDPSocketChannel channel = (UDPSocketChannel)ch;
        UDPSocketChannel[] copy = new UDPSocketChannel[this._channels.length];
        for (i = 0; i < this._channels.length; ++i) {
            copy[i] = this._channels[i];
        }
        for (i = 1; i <= copy.length; ++i) {
            int connID = (this._lastConnectionID + i) % 256;
            if (connID == 0 || copy[connID] != null) continue;
            this._lastConnectionID = connID;
            copy[connID] = channel;
            channel.getProcessor().setConnectionId((byte)connID);
            this._channels = copy;
            return new UDPSelectionKey(this, att, ch, ops);
        }
        LOG.warn("Attempting to add over connection limit");
        this.channelsToRemove.add(ch);
        return new UDPSelectionKey(this, att, ch, ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SelectionKey> keys() {
        UDPSocketChannel[] channels = this._channels;
        HashSet<SelectionKey> keys = new HashSet<SelectionKey>();
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i] == null) continue;
            keys.add(channels[i].keyFor(this));
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            for (SelectableChannel channel : this.channelsToRemove) {
                keys.add(channel.keyFor(this));
            }
        }
        return keys;
    }

    @Override
    public int select() throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    @Override
    public int select(long timeout) throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.selectedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectNow() throws IOException {
        UDPSocketChannel[] array = this._channels;
        UDPSocketChannel[] removed = null;
        this.selectedKeys.clear();
        for (int i = 0; i < array.length; ++i) {
            UDPSelectionKey key;
            UDPSocketChannel channel = array[i];
            if (channel == null || (key = (UDPSelectionKey)channel.keyFor(this)) == null) continue;
            if (key.isValid() && channel.isOpen()) {
                int currentOps = channel.getProcessor().readyOps();
                int readyOps = currentOps & key.interestOps();
                if (readyOps == 0) continue;
                key.setReadyOps(readyOps);
                this.selectedKeys.add(key);
                continue;
            }
            if (removed == null) {
                removed = new UDPSocketChannel[array.length];
            }
            removed[i] = channel;
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            if (removed != null) {
                UDPSocketChannel[] copy = new UDPSocketChannel[this._channels.length];
                for (int i = 0; i < this._channels.length; ++i) {
                    copy[i] = this._channels[i] == removed[i] ? null : this._channels[i];
                }
                this._channels = copy;
            }
            if (!this.channelsToRemove.isEmpty()) {
                for (SelectableChannel next : this.channelsToRemove) {
                    UDPSelectionKey key = (UDPSelectionKey)next.keyFor(this);
                    key.cancel();
                    key.setReadyOps(0);
                    this.selectedKeys.add(key);
                }
                this.channelsToRemove.clear();
            }
        }
        return this.selectedKeys.size();
    }

    @Override
    public Selector wakeup() {
        return this;
    }
}

