/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.exceptions.DHTNoSuchElementException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.util.DatabaseUtils;

public class GetValueResponseHandler
extends AbstractResponseHandler<FindValueResult> {
    private static final Log LOG = LogFactory.getLog(GetValueResponseHandler.class);
    private final EntityKey lookupKey;

    public GetValueResponseHandler(Context context, EntityKey lookupKey) {
        super(context);
        this.lookupKey = lookupKey;
    }

    @Override
    protected void start() throws DHTException {
        Contact node = this.lookupKey.getContact();
        KUID primaryKey = this.lookupKey.getPrimaryKey();
        KUID secondaryKey = this.lookupKey.getSecondaryKey();
        DHTValueType valueType = this.lookupKey.getDHTValueType();
        FindValueRequest request = this.context.getMessageHelper().createFindValueRequest(node.getContactAddress(), primaryKey, Collections.singleton(secondaryKey), valueType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("start looking for: " + request);
        }
        try {
            this.context.getMessageDispatcher().send(node, (RequestMessage)request, (ResponseHandler)this);
        }
        catch (IOException err) {
            throw new DHTException(err);
        }
    }

    @Override
    protected void response(ResponseMessage message, long time) throws IOException {
        if (message instanceof FindValueResponse) {
            FindValueResponse response = (FindValueResponse)message;
            if (LOG.isDebugEnabled()) {
                LOG.debug("received response: " + response);
            }
            Collection<? extends DHTValueEntity> entities = DatabaseUtils.filter(this.lookupKey.getDHTValueType(), response.getDHTValueEntities());
            Map path = Collections.emptyMap();
            Set entityKeys = Collections.emptySet();
            FindValueResult result = new FindValueResult(this.lookupKey, path, entities, entityKeys, time, 1);
            this.setReturnValue(result);
        } else {
            this.setException(new DHTNoSuchElementException(message, this.lookupKey.toString()));
        }
    }

    @Override
    protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
        this.fireTimeoutException(nodeId, dst, message, time);
    }

    @Override
    protected void error(KUID nodeId, SocketAddress dst, RequestMessage message, IOException e) {
        this.setException(new DHTBackendException(nodeId, dst, message, e));
    }
}

