/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.impl.DatabaseImpl;
import org.limewire.mojito.settings.DatabaseSettings;

public class DHTValueEntityBag
implements Serializable {
    private static final long serialVersionUID = -439172537233232473L;
    private static final float SMOOTHING_FACTOR = DatabaseSettings.VALUE_REQUEST_LOAD_SMOOTHING_FACTOR.getValue();
    private static final int LOAD_NULLING_DELAY = DatabaseSettings.VALUE_REQUEST_LOAD_NULLING_DELAY.getValue();
    private final DatabaseImpl database;
    private final KUID primaryKey;
    private final Map<KUID, DHTValueEntity> values = new HashMap<KUID, DHTValueEntity>();
    private transient float requestLoad = 0.0f;
    private transient long lastRequestTime;

    DHTValueEntityBag(DatabaseImpl database, KUID primaryKey) {
        this.database = database;
        this.primaryKey = primaryKey;
    }

    public Database getDatabase() {
        return this.database;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public float getRequestLoad(boolean incrementLoad) {
        if (incrementLoad) {
            this.incrementRequestLoad();
        }
        return this.requestLoad;
    }

    public float incrementRequestLoad() {
        long now = System.currentTimeMillis();
        if (this.lastRequestTime == 0L) {
            this.lastRequestTime = now;
            this.requestLoad = 0.0f;
            return this.requestLoad;
        }
        float delay = Math.max((float)(now - this.lastRequestTime) / 1000.0f, 0.01f);
        if (delay <= 0.0f || delay > (float)LOAD_NULLING_DELAY) {
            this.lastRequestTime = now;
            this.requestLoad = 0.0f;
            return this.requestLoad;
        }
        this.requestLoad += SMOOTHING_FACTOR * (1.0f / delay - this.requestLoad);
        this.lastRequestTime = now;
        return this.requestLoad;
    }

    public boolean add(DHTValueEntity entity) {
        if (entity == null) {
            throw new NullPointerException("DHTValueEntity is null");
        }
        if (!this.primaryKey.equals(entity.getPrimaryKey())) {
            throw new IllegalArgumentException();
        }
        this.values.put(entity.getSecondaryKey(), entity);
        return true;
    }

    public DHTValueEntity get(KUID secondaryKey) {
        return this.values.get(secondaryKey);
    }

    public DHTValueEntity remove(KUID secondaryKey) {
        return this.values.remove(secondaryKey);
    }

    public boolean contains(KUID secondaryKey) {
        return this.values.containsKey(secondaryKey);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int hashCode() {
        return this.primaryKey.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DHTValueEntityBag)) {
            return false;
        }
        return this.primaryKey.equals(((DHTValueEntityBag)o).primaryKey);
    }

    public Map<KUID, DHTValueEntity> getValues(boolean copy) {
        if (copy) {
            return Collections.unmodifiableMap(new HashMap<KUID, DHTValueEntity>(this.values));
        }
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Bag: ").append(this.getPrimaryKey()).append("\n");
        buffer.append("Load: ").append(this.getRequestLoad(false)).append("\n");
        buffer.append("Values:").append("\n");
        for (DHTValueEntity entity : this.values.values()) {
            buffer.append(entity).append("\n");
        }
        return buffer.toString();
    }
}

