/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeServices;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import java.util.Properties;
import org.limewire.core.settings.ApplicationSettings;

public final class LeafHandshakeResponder
extends DefaultHandshakeResponder {
    private final HeadersFactory headersFactory;
    private final HandshakeServices handshakeServices;

    LeafHandshakeResponder(String host, HeadersFactory headersFactory, HandshakeServices handshakeServices) {
        super(host);
        this.headersFactory = headersFactory;
        this.handshakeServices = handshakeServices;
    }

    @Override
    protected HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        if (!response.isUltrapeer()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse(HandshakeStatus.WE_ARE_LEAVES);
        }
        if (this.getLocalePreferencing() && !ApplicationSettings.LANGUAGE.get().equals(response.getLocalePref())) {
            return HandshakeResponse.createLeafRejectLocaleOutgoingResponse();
        }
        HandshakeStatus status = this.handshakeServices.getHandshakeStatusForResponse(response);
        if (!status.isAcceptable()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse(status);
        }
        Properties ret = new Properties();
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    @Override
    protected HandshakeResponse respondToIncoming(HandshakeResponse hr) {
        if (hr.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse(this.handshakeServices);
        }
        if (!hr.isUltrapeer()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse(HandshakeStatus.WE_ARE_LEAVES);
        }
        Properties ret = this.headersFactory.createLeafHeaders(this.getRemoteIP());
        HandshakeStatus status = this.handshakeServices.getHandshakeStatusForResponse(hr);
        if (!status.isAcceptable()) {
            return HandshakeResponse.createLeafRejectIncomingResponse(hr, status, this.handshakeServices);
        }
        if (hr.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(hr, ret, this.handshakeServices);
    }
}

