/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.browser.ExternalControl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.FileLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.NetworkSettings;
import org.limewire.io.ByteReader;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class ActiveLimeWireCheck {
    private static final Log LOG = LogFactory.getLog(ActiveLimeWireCheck.class);
    private static final ActiveLimeWireCheck instance = new ActiveLimeWireCheck();
    private volatile RandomAccessFile file = null;
    private volatile FileLock lock = null;

    public static ActiveLimeWireCheck instance() {
        return instance;
    }

    public boolean checkForActiveLimeWire(String[] args) throws ActiveLimeWireException {
        if (!OSUtils.isWindows() && !OSUtils.isLinux()) {
            return this.testForLimeWire(null);
        }
        if (args == null || args.length == 0) {
            return this.testForLimeWire(null);
        }
        return this.testForLimeWire(ExternalControl.preprocessArgs(args));
    }

    public void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.release();
                this.file.close();
                LOG.trace("Released lock");
            }
            catch (IOException e) {
                LOG.debug("Failed to release lock", e);
            }
        }
    }

    private boolean testForLimeWire(String arg) throws ActiveLimeWireException {
        try {
            File f = new File(CommonUtils.getUserSettingsDir(), "lock");
            f.createNewFile();
            this.file = new RandomAccessFile(f, "rw");
            this.lock = this.file.getChannel().tryLock();
        }
        catch (IOException e) {
            LOG.error("Failed to access lock file", e);
            return true;
        }
        if (this.lock == null) {
            LOG.trace("Could not acquire lock");
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < 300000L) {
                if (this.tryToContactRunningLimeWire(arg)) {
                    LOG.trace("Contacted existing instance");
                    return true;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {}
            }
            LOG.trace("Could not contact existing instance");
            throw new ActiveLimeWireException();
        }
        LOG.trace("Acquired lock");
        if (this.tryToContactRunningLimeWire(arg)) {
            LOG.trace("Contacted existing instance");
            this.releaseLock();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToContactRunningLimeWire(String arg) {
        Socket socket = null;
        boolean contacted = false;
        int port = NetworkSettings.PORT.getValue();
        if (!NetworkUtils.isValidPort(port)) {
            LOG.trace("Invalid port");
            return false;
        }
        String type = ExternalControl.isTorrentRequest(arg) ? "TORRENT" : "MAGNET";
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Connecting to port " + port);
            }
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", port), 10000);
            LOG.trace("Connected");
            InputStream istream = socket.getInputStream();
            socket.setSoTimeout(10000);
            ByteReader byteReader = new ByteReader(istream);
            OutputStream os = socket.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            BufferedWriter out = new BufferedWriter(osw);
            out.write(type + " " + arg + " ");
            out.write("\r\n");
            out.flush();
            String str = byteReader.readLine();
            if (str == null) {
                LOG.trace("Null response");
                contacted = false;
            } else if (!str.startsWith(CommonUtils.getUserName())) {
                LOG.trace("Invalid response");
                contacted = false;
            } else {
                LOG.trace("Valid response");
                contacted = true;
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to contact existing instance", e);
        }
        finally {
            LOG.trace("Closing socket");
            IOUtils.close(socket);
        }
        return contacted;
    }

    public static class ActiveLimeWireException
    extends Exception {
    }
}

