/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video;

import com.sun.media.BasicCodec;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class VideoCodec
extends BasicCodec {
    private static final Logger logger = LoggerSingleton.logger;
    protected String PLUGIN_NAME;
    protected VideoFormat[] defaultOutputFormats;
    protected VideoFormat[] supportedInputFormats;
    protected VideoFormat[] supportedOutputFormats;
    protected VideoFormat inputFormat;
    protected VideoFormat outputFormat;
    protected final boolean DEBUG = true;
    private static final boolean TRACE = false;

    public String getName() {
        return this.PLUGIN_NAME;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format setInputFormat(Format format) {
        if (!(format instanceof VideoFormat)) {
            return null;
        }
        for (int i = 0; i < this.supportedInputFormats.length; ++i) {
            if (!format.matches(this.supportedInputFormats[i])) continue;
            this.inputFormat = (VideoFormat)format;
            return this.inputFormat;
        }
        return null;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat)) {
            return null;
        }
        Format[] formats = this.getMatchingOutputFormats(this.inputFormat);
        for (int i = 0; i < formats.length; ++i) {
            if (!format.matches(formats[i])) continue;
            this.outputFormat = (VideoFormat)format;
            return this.outputFormat;
        }
        return null;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        return new Format[0];
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.defaultOutputFormats;
        }
        ArrayList<Format> result = new ArrayList<Format>();
        for (int i = 0; i < this.supportedInputFormats.length; ++i) {
            if (!in.matches(this.supportedInputFormats[i])) continue;
            this.inputFormat = (VideoFormat)in;
            Format[] matching = this.getMatchingOutputFormats(in);
            for (int j = 0; j < matching.length; ++j) {
                result.add(matching[j]);
            }
        }
        Format[] arrayResult = new Format[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            arrayResult[i] = (Format)result.get(i);
        }
        return arrayResult;
    }

    public boolean checkFormat(Format format) {
        if (!((VideoFormat)format).getSize().equals(this.outputFormat.getSize())) {
            this.videoResized();
        }
        return true;
    }

    protected void videoResized() {
    }

    protected void updateOutput(Buffer outputBuffer, Format format, int length, int offset) {
        outputBuffer.setFormat(format);
        outputBuffer.setLength(length);
        outputBuffer.setOffset(offset);
    }
}

