/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TXMLReader {
    private Document config;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder;
    private boolean ready = false;

    public TXMLReader(String resPath) {
        try {
            this.builder = this.factory.newDocumentBuilder();
            InputStream stream = null;
            if (resPath != null) {
                stream = TXMLReader.class.getResourceAsStream(resPath);
            }
            if (stream == null) {
                try {
                    stream = new FileInputStream("src" + resPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (stream != null) {
                this.config = this.builder.parse(stream);
                this.ready = true;
            }
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception oe) {
            oe.printStackTrace();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public NodeList getNodes(String name) {
        return this.config.getElementsByTagName(name);
    }

    private Element getFirstElement(Element element, String name) {
        NodeList nl = element.getElementsByTagName(name);
        if (nl.getLength() < 1) {
            throw new RuntimeException("Element: " + element + " does not contain: " + name);
        }
        return (Element)nl.item(0);
    }

    public String getSimpleElementText(Element node, String name) {
        Element namedElement = this.getFirstElement(node, name);
        return this.getSimpleElementText(namedElement);
    }

    public String getSimpleElementText(Element node) {
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Text)) continue;
            sb.append(child.getNodeValue().trim());
        }
        return sb.toString();
    }

    public int readIntegerAttribute(Element node, String attrName, int defaultValue) {
        String data;
        int back = defaultValue;
        if (node != null && (data = node.getAttribute(attrName)) != null && data.length() > 0) {
            try {
                back = Integer.parseInt(data);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return back;
    }

    public String readStringAttribute(Element node, String attrName, String defaultValue) {
        String data;
        if (node != null && (data = node.getAttribute(attrName)) != null && data.length() > 0) {
            return data;
        }
        return defaultValue;
    }

    public double readDoubleAttribute(Element node, String attrName, double defaultValue) {
        String data;
        if (node != null && (data = node.getAttribute(attrName)) != null && data.length() > 0) {
            return Double.parseDouble(data);
        }
        return defaultValue;
    }
}

