/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;
import net.sf.jabref.Globals;
import net.sf.jabref.util.CaseChanger;

public class CaseChangeMenu
extends JMenu
implements ActionListener {
    static CaseChanger cc = new CaseChanger();
    JMenuItem[] changeCaseItems;
    private JTextComponent parent;

    public CaseChangeMenu(JTextComponent opener) {
        super(Globals.lang("Change case"));
        this.parent = opener;
        int m = CaseChanger.getNumModes();
        this.changeCaseItems = new JMenuItem[m];
        for (int i = 0; i < m; ++i) {
            this.changeCaseItems[i] = new JMenuItem(Globals.lang(CaseChanger.getModeName(i)));
            this.changeCaseItems[i].addActionListener(this);
            this.add(this.changeCaseItems[i]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int m = CaseChanger.getNumModes();
        for (int i = 0; i < m; ++i) {
            if (source != this.changeCaseItems[i]) continue;
            this.caseChange(i);
            break;
        }
    }

    private void caseChange(int mode) {
        this.parent.setText(CaseChanger.changeCase(this.parent.getText(), mode));
    }
}

