/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.TreeSet;
import java.util.Vector;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;

public class TextAnalyzer {
    BibtexEntry be = null;

    public TextAnalyzer(String text) {
        this.guessBibtexFields(text);
    }

    public BibtexEntry getEntry() {
        return this.be;
    }

    public void guessBibtexFields(String text) {
        int pos;
        TreeSet<Substring> usedParts = new TreeSet<Substring>();
        text = "  " + text + "  ";
        String[] split = null;
        String year = null;
        String yearRx = "(\\s|\\()\\d\\d\\d\\d(\\.|,|\\))";
        String[] cand = this.getMatches(text, yearRx);
        if (cand.length == 1) {
            year = this.clean(cand[0]);
            int pos2 = text.indexOf(year);
            usedParts.add(new Substring("year", pos2, pos2 + year.length()));
            Util.pr("Guessing 'year': '" + year + "'");
        } else if (cand.length > 1) {
            int good = -1;
            int yearFound = -1;
            for (int i = 0; i < cand.length; ++i) {
                int number = Integer.parseInt(cand[i].trim());
                if (number == yearFound || number >= 2500) continue;
                if (good == -1) {
                    good = i;
                    yearFound = number;
                    continue;
                }
                if (yearFound < Globals.FUTURE_YEAR && number < Globals.FUTURE_YEAR) {
                    good = -1;
                    break;
                }
                if (yearFound < Globals.FUTURE_YEAR || number >= Globals.FUTURE_YEAR) continue;
                good = i;
                yearFound = number;
            }
            if (good >= 0) {
                year = this.clean(cand[good]);
                pos = text.indexOf(year);
                usedParts.add(new Substring("year", pos, pos + year.length()));
                Util.pr("Guessing 'year': '" + year + "'");
            }
        }
        String pages = null;
        String pagesRx = "\\s(\\d{1,4})( ??)-( ??)(\\d{1,4})(\\.|,|\\s)";
        cand = this.getMatches(text, pagesRx);
        if (cand.length == 1) {
            pages = this.clean(cand[0].replaceAll("-|( - )", "--"));
            pos = text.indexOf(cand[0]);
            usedParts.add(new Substring("pages", pos, pos + year.length()));
            Util.pr("Guessing 'pages': '" + pages + "'");
        } else if (cand.length > 1) {
            int found = -1;
            for (int i = 0; i < cand.length; ++i) {
                split = this.clean(cand[i].replaceAll("\\s", "")).split("-");
                int first = Integer.parseInt(split[0]);
                int second = Integer.parseInt(split[1]);
                if (second - first <= 3) continue;
                found = i;
                break;
            }
            if (found >= 0) {
                pages = this.clean(cand[found].replaceAll("-|( - )", "--"));
                int pos3 = text.indexOf(cand[found]);
                Util.pr("Guessing 'pages': '" + pages + "'");
                usedParts.add(new Substring("pages", pos3, pos3 + pages.length()));
            }
        }
        String journal = null;
        String volume = null;
        String journalRx = "(,|\\.|\\n)\\s??([a-zA-Z\\. ]{8,30}+)((.){0,2})((vol\\.|Vol\\.|Volume|volume))??\\s??(\\d{1,3})(\\.|,|\\s|:)";
        cand = this.getMatches(text, journalRx);
        if (cand.length > 0) {
            cand[0] = cand[0].trim();
            int pos4 = cand[0].lastIndexOf(32);
            if (pos4 > 0) {
                String last;
                volume = this.clean(cand[0].substring(pos4 + 1));
                Util.pr("Guessing 'volume': '" + volume + "'");
                journal = this.clean(cand[0].substring(0, pos4));
                pos4 = journal.lastIndexOf(32);
                if (pos4 > 0 && ((last = journal.substring(pos4 + 1).toLowerCase()).equals("volume") || last.equals("vol") || last.equals("v"))) {
                    journal = this.clean(journal.substring(0, pos4));
                }
                pos4 = text.indexOf(journal);
                usedParts.add(new Substring("journal", pos4, pos4 + journal.length()));
                Util.pr("Guessing 'journal': '" + journal + "'");
            }
        } else {
            journalRx = "(,|\\.|\\n)\\s??([a-zA-Z\\. ]{8,30}+)((.){0,2})\\s??(\\d{1,3})(\\.|,|\\s|:)";
        }
        Vector<String> free = new Vector<String>();
        int piv = 0;
        for (Substring ss : usedParts) {
            if (ss.begin() - piv > 10) {
                Util.pr("... " + text.substring(piv, ss.begin()));
                free.add(this.clean(text.substring(piv, ss.begin())));
            }
            piv = ss.end();
        }
        if (text.length() - piv > 10) {
            free.add(this.clean(text.substring(piv)));
        }
        Util.pr("Free parts:");
        for (String s : free) {
            Util.pr(": '" + s + "'");
        }
    }

    public String[] getMatches(String text, String regexp) {
        int piv = 0;
        String[] test = text.split(regexp);
        if (test.length < 2) {
            return new String[0];
        }
        String[] out = new String[test.length - 1];
        for (int i = 0; i < out.length; ++i) {
            String[] curr = text.split(regexp, i + 2);
            out[i] = text.substring(piv + curr[i].length(), text.length() - curr[i + 1].length());
            piv += curr[i].length() + out[i].length();
        }
        return out;
    }

    private String clean(String s) {
        char c;
        boolean found = false;
        int left = 0;
        int right = s.length() - 1;
        while (!found && left < s.length()) {
            c = s.charAt(left);
            if (Character.isWhitespace(c) || c == '.' || c == ',' || c == '(' || c == ':' || c == ')') {
                ++left;
                continue;
            }
            found = true;
        }
        found = false;
        while (!found && right > left) {
            c = s.charAt(right);
            if (Character.isWhitespace(c) || c == '.' || c == ',' || c == ')' || c == ':' || c == '(') {
                --right;
                continue;
            }
            found = true;
        }
        return s.substring(left, Math.min(right + 1, s.length()));
    }

    private class Substring
    implements Comparable<Substring> {
        int begin;
        int end;

        public Substring(String name, int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int begin() {
            return this.begin;
        }

        public int end() {
            return this.end;
        }

        @Override
        public int compareTo(Substring other) {
            return new Integer(this.begin).compareTo(new Integer(other.begin()));
        }
    }
}

