/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.help.MyEditorKit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HelpContent
extends JTextPane {
    static Log log = LogFactory.getLog(HelpContent.class);
    JScrollPane pane = new JScrollPane(this, 20, 30);
    private Stack<URL> history;
    private Stack<URL> forw;
    JabRefPreferences prefs;

    public HelpContent(JabRefPreferences prefs_) {
        this.pane.setDoubleBuffered(true);
        this.prefs = prefs_;
        this.history = new Stack();
        this.forw = new Stack();
        this.setEditorKitForContentType("text/html", new MyEditorKit());
        this.setContentType("text/html");
        this.setText("");
        this.setEditable(false);
        HyperlinkListener hyperLinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getDescription().startsWith("#")) {
                    HelpContent.this.scrollToReference(e.getDescription().substring(1));
                }
            }
        };
        this.addHyperlinkListener(hyperLinkListener);
    }

    public boolean back() {
        if (!this.history.empty()) {
            URL prev = this.history.pop();
            this.forw.push(this.getPage());
            this.setPageOnly(prev);
        }
        return !this.history.empty();
    }

    public boolean forward() {
        if (!this.forw.empty()) {
            URL next = this.forw.pop();
            this.history.push(this.getPage());
            this.setPageOnly(next);
        }
        return !this.forw.empty();
    }

    public void reset() {
        this.forw.removeAllElements();
        this.history.removeAllElements();
    }

    public void setPage(String filename, Class resourceOwner) {
        String reference;
        String file;
        int indexOf = filename.indexOf(35);
        if (indexOf != -1) {
            file = filename.substring(0, indexOf);
            reference = filename.substring(indexOf + 1);
        } else {
            file = filename;
            reference = "";
        }
        String middle = this.prefs.get("language") + "/";
        if (middle.equals("en/")) {
            middle = "";
        }
        URL old = this.getPage();
        try {
            URL resource = resourceOwner.getResource(GUIGlobals.helpPre + middle + file);
            if (resource == null) {
                resource = resourceOwner.getResource(GUIGlobals.helpPre + file);
            }
            if (resource == null) {
                log.error("Could not find html-help for file '" + file + "'.");
                return;
            }
            this.setPageOnly(new URL(resource.toString() + "#" + reference));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.forw.removeAllElements();
        if (old != null) {
            this.history.push(old);
        }
    }

    @Override
    public void setPage(URL url) {
        File f = new File(url.getPath());
        this.setPage(f.getName(), JabRef.class);
    }

    private void setPageOnly(URL url) {
        try {
            super.setPage(url);
        }
        catch (IOException ex) {
            if (url == null) {
                System.out.println("Error: Help file not set");
            }
            System.out.println("Error: Help file not found '" + url.getFile() + "'");
        }
    }

    public JComponent getPane() {
        return this.pane;
    }
}

