/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.external.ConfirmCloseFileListEntryEditor;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.net.URLDownload;

public class DownloadExternalFile {
    private JabRefFrame frame;
    private MetaData metaData;
    private String bibtexKey;
    private FileListEntryEditor editor;
    private boolean downloadFinished = false;
    private boolean dontShowDialog = false;

    public DownloadExternalFile(JabRefFrame frame, MetaData metaData, String bibtexKey) {
        this.frame = frame;
        this.metaData = metaData;
        this.bibtexKey = bibtexKey;
    }

    public void download(DownloadCallback callback) throws IOException {
        this.dontShowDialog = false;
        String res = JOptionPane.showInputDialog(this.frame, (Object)Globals.lang("Enter URL to download"));
        if (res == null || res.trim().length() == 0) {
            return;
        }
        URL url = null;
        try {
            url = new URL(res);
        }
        catch (MalformedURLException ex1) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Invalid URL"), Globals.lang("Download file"), 0);
            return;
        }
        this.download(url, callback);
    }

    public void download(URL url, DownloadCallback callback) throws IOException {
        String suffix;
        String res = url.toString();
        URLDownload udl = null;
        File tmp = File.createTempFile("jabref_download", "tmp");
        tmp.deleteOnExit();
        try {
            udl = new URLDownload(this.frame, url, tmp);
            udl.openConnectionOnly();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Invalid URL") + ": " + ex.getMessage(), Globals.lang("Download file"), 0);
            Globals.logger("Error while downloading '" + res + "'");
            return;
        }
        final URL urlF = url;
        final URLDownload udlF = udl;
        new Thread(){

            @Override
            public void run() {
                try {
                    udlF.download();
                }
                catch (IOException e2) {
                    DownloadExternalFile.this.dontShowDialog = true;
                    if (DownloadExternalFile.this.editor != null && DownloadExternalFile.this.editor.isVisible()) {
                        DownloadExternalFile.this.editor.setVisible(false, false);
                    }
                    JOptionPane.showMessageDialog(DownloadExternalFile.this.frame, Globals.lang("Invalid URL") + ": " + e2.getMessage(), Globals.lang("Download file"), 0);
                    Globals.logger("Error while downloading '" + urlF.toString() + "'");
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DownloadExternalFile.this.downloadFinished();
                    }
                });
            }
        }.start();
        ExternalFileType suggestedType = null;
        if (udl.getMimeType() != null) {
            System.out.println("mimetype:" + udl.getMimeType());
            suggestedType = Globals.prefs.getExternalFileTypeByMimeType(udl.getMimeType());
        }
        if (suggestedType != null) {
            suffix = suggestedType.getExtension();
        } else {
            suffix = this.getSuffix(res);
            suggestedType = Globals.prefs.getExternalFileTypeByExt(suffix);
        }
        String suggestedName = this.bibtexKey != null ? this.getSuggestedFileName(suffix) : "";
        String[] fDirectory = this.getFileDirectory(res);
        final String directory = fDirectory.length == 0 ? null : fDirectory[0];
        String suggestDir = directory != null ? directory : System.getProperty("user.home");
        File file = new File(new File(suggestDir), suggestedName);
        FileListEntry entry = new FileListEntry("", this.bibtexKey != null ? file.getCanonicalPath() : "", suggestedType);
        this.editor = new FileListEntryEditor(this.frame, entry, true, false, this.metaData);
        this.editor.getProgressBar().setIndeterminate(true);
        this.editor.setOkEnabled(false);
        this.editor.setExternalConfirm(new ConfirmCloseFileListEntryEditor(){

            @Override
            public boolean confirmClose(FileListEntry entry) {
                File f;
                File file = f = directory != null ? DownloadExternalFile.this.expandFilename(directory, entry.getLink()) : new File(entry.getLink());
                if (f.isDirectory()) {
                    JOptionPane.showMessageDialog(DownloadExternalFile.this.frame, Globals.lang("Target file cannot be a directory."), Globals.lang("Download file"), 0);
                    return false;
                }
                if (f.exists()) {
                    return JOptionPane.showConfirmDialog(DownloadExternalFile.this.frame, "'" + f.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Download file"), 2) == 0;
                }
                return true;
            }
        });
        if (this.dontShowDialog) {
            return;
        }
        this.editor.setVisible(true, false);
        if (this.editor.okPressed()) {
            File toFile;
            File file2 = toFile = directory != null ? this.expandFilename(directory, entry.getLink()) : new File(entry.getLink());
            String dirPrefix = directory != null ? (!directory.endsWith(System.getProperty("file.separator")) ? directory + System.getProperty("file.separator") : directory) : null;
            try {
                boolean success = Util.copyFile(tmp, toFile, true);
                if (!success) {
                    System.out.println("File already exists! DownloadExternalFile.download()");
                }
                if (directory != null && entry.getLink().startsWith(directory) && entry.getLink().length() > dirPrefix.length()) {
                    entry.setLink(entry.getLink().substring(dirPrefix.length()));
                }
                callback.downloadComplete(entry);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            tmp.delete();
        } else if (this.downloadFinished) {
            tmp.delete();
        }
    }

    private File expandFilename(String directory, String link) {
        File toFile = new File(link);
        String dirPrefix = directory + System.getProperty("file.separator");
        if (!toFile.isAbsolute()) {
            toFile = new File(dirPrefix + link);
        }
        return toFile;
    }

    public void downloadFinished() {
        this.downloadFinished = true;
        this.editor.getProgressBar().setVisible(false);
        this.editor.getProgressBarLabel().setVisible(false);
        this.editor.setOkEnabled(true);
        this.editor.getProgressBar().setValue(this.editor.getProgressBar().getMaximum());
    }

    public String getSuggestedFileName(String suffix) {
        String plannedName = this.bibtexKey;
        if (suffix.length() > 0) {
            plannedName = plannedName + "." + suffix;
        }
        if (Globals.ON_WIN) {
            plannedName = plannedName.replaceAll("\\?|\\*|\\<|\\>|\\||\\\"|\\:|\\.$|\\[|\\]", "");
        } else if (Globals.ON_MAC) {
            plannedName = plannedName.replaceAll(":", "");
        }
        return plannedName;
    }

    public String getSuffix(String link) {
        String strippedLink = link;
        try {
            URL url = new URL(link);
            if (url.getQuery() != null && url.getQuery().length() < link.length() - 1) {
                strippedLink = link.substring(0, link.length() - url.getQuery().length() - 1);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        int index = strippedLink.lastIndexOf(46);
        String suffix = index <= 0 || index == strippedLink.length() - 1 ? null : strippedLink.substring(index + 1);
        if (Globals.prefs.getExternalFileTypeByExt(suffix) != null) {
            return suffix;
        }
        index = link.lastIndexOf(46);
        if (index <= 0 || index == strippedLink.length() - 1) {
            if (suffix.indexOf(47) > 0) {
                return "";
            }
            return suffix;
        }
        if (link.substring(index + 1).indexOf(47) > 0) {
            return "";
        }
        return link.substring(index + 1);
    }

    public String[] getFileDirectory(String link) {
        return this.metaData.getFileDirectory("file");
    }

    public static interface DownloadCallback {
        public void downloadComplete(FileListEntry var1);
    }
}

