/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.help.HelpAction;

public class PreviewPrefsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    JPanel pan = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JTextArea layout1 = new JTextArea("", 1, 1);
    JTextArea layout2 = new JTextArea("", 1, 1);
    JButton def1 = new JButton(Globals.lang("Default"));
    JButton def2 = new JButton(Globals.lang("Default"));
    JButton test1 = new JButton(Globals.lang("Test"));
    JButton test2 = new JButton(Globals.lang("Test"));
    JButton help;
    JPanel p1 = new JPanel();
    JPanel p2 = new JPanel();
    JPanel p3 = new JPanel(new BorderLayout());
    JScrollPane sp1 = new JScrollPane(this.layout1);
    JScrollPane sp2 = new JScrollPane(this.layout2);
    JCheckBox pdfPreview = new JCheckBox(Globals.lang("Enable PDF preview"));
    private static BibtexEntry entry;

    public PreviewPrefsTab(JabRefPreferences prefs) {
        this._prefs = prefs;
        this.p1.setLayout(this.gbl);
        this.p2.setLayout(this.gbl);
        this.setLayout(this.gbl);
        JLabel lab = new JLabel(Globals.lang("Preview") + " 1");
        this.con.anchor = 17;
        this.con.gridwidth = 0;
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.insets = new Insets(2, 2, 2, 2);
        this.gbl.setConstraints(lab, this.con);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.sp1, this.con);
        this.p1.add(this.sp1);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.con.weightx = 0.0;
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.test1, this.con);
        this.p1.add(this.test1);
        this.gbl.setConstraints(this.def1, this.con);
        this.p1.add(this.def1);
        this.con.gridwidth = 0;
        JPanel pan = new JPanel();
        this.con.weightx = 1.0;
        this.gbl.setConstraints(pan, this.con);
        this.p1.add(pan);
        lab = new JLabel(Globals.lang("Preview") + " 2");
        this.gbl.setConstraints(lab, this.con);
        this.con.weighty = 1.0;
        this.con.fill = 1;
        this.gbl.setConstraints(this.sp2, this.con);
        this.p2.add(this.sp2);
        this.con.weighty = 0.0;
        this.con.weightx = 0.0;
        this.con.fill = 0;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.test2, this.con);
        this.p2.add(this.test2);
        this.gbl.setConstraints(this.def2, this.con);
        this.p2.add(this.def2);
        this.con.gridwidth = 1;
        pan = new JPanel();
        this.con.weightx = 1.0;
        this.gbl.setConstraints(pan, this.con);
        this.p2.add(pan);
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.fill = 1;
        this.con.gridwidth = 0;
        lab = new JLabel(Globals.lang("Preview") + " 1");
        this.gbl.setConstraints(lab, this.con);
        this.add(lab);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.p1, this.con);
        this.add(this.p1);
        lab = new JLabel(Globals.lang("Preview") + " 2");
        this.con.weighty = 0.0;
        JSeparator sep = new JSeparator(0);
        this.gbl.setConstraints(sep, this.con);
        this.add(sep);
        this.gbl.setConstraints(lab, this.con);
        this.add(lab);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.p2, this.con);
        this.add(this.p2);
        this.p3.add((Component)this.pdfPreview, "West");
        HelpAction helpAction = new HelpAction(Globals.helpDiag, "PreviewHelp.html", Globals.lang("Help on Preview Settings"), GUIGlobals.getIconUrl("helpSmall"));
        JButton help = helpAction.getIconButton();
        this.p3.add((Component)help, "East");
        this.con.weighty = 0.0;
        this.gbl.setConstraints(this.p3, this.con);
        this.add(this.p3);
        this.def1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tmp = PreviewPrefsTab.this.layout1.getText().replaceAll("\n", "__NEWLINE__");
                PreviewPrefsTab.this._prefs.remove("preview0");
                PreviewPrefsTab.this.layout1.setText(PreviewPrefsTab.this._prefs.get("preview0").replaceAll("__NEWLINE__", "\n"));
                PreviewPrefsTab.this._prefs.put("preview0", tmp);
            }
        });
        this.def2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tmp = PreviewPrefsTab.this.layout2.getText().replaceAll("\n", "__NEWLINE__");
                PreviewPrefsTab.this._prefs.remove("preview1");
                PreviewPrefsTab.this.layout2.setText(PreviewPrefsTab.this._prefs.get("preview1").replaceAll("__NEWLINE__", "\n"));
                PreviewPrefsTab.this._prefs.put("preview1", tmp);
            }
        });
        this.test1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPrefsTab.getTestEntry();
                PreviewPanel testPanel = new PreviewPanel(null, entry, null, new MetaData(), PreviewPrefsTab.this.layout1.getText());
                testPanel.setPreferredSize(new Dimension(800, 350));
                JOptionPane.showMessageDialog(null, testPanel, Globals.lang("Preview"), -1);
            }
        });
        this.test2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPrefsTab.getTestEntry();
                PreviewPanel testPanel = new PreviewPanel(null, entry, null, new MetaData(), PreviewPrefsTab.this.layout2.getText());
                testPanel.setPreferredSize(new Dimension(800, 350));
                JOptionPane.showMessageDialog(null, new JScrollPane(testPanel), Globals.lang("Preview"), -1);
            }
        });
    }

    public static BibtexEntry getTestEntry() {
        if (entry != null) {
            return entry;
        }
        entry = new BibtexEntry(Util.createNeutralId(), BibtexEntryType.getType("article"));
        entry.setField("bibtexkey", "conceicao1997");
        entry.setField("author", "Luis E. C. Conceic{\\~a}o and Terje van der Meeren and Johan A. J. Verreth and M S. Evjen and D. F. Houlihan and H. J. Fyhn");
        entry.setField("title", "Amino acid metabolism and protein turnover in larval turbot (Scophthalmus maximus) fed natural zooplankton or Artemia");
        entry.setField("year", "1997");
        entry.setField("journal", "Marine Biology");
        entry.setField("month", "January");
        entry.setField("number", "2");
        entry.setField("volume", "123");
        entry.setField("pdf", "conceicao1997.pdf");
        entry.setField("pages", "255--265");
        entry.setField("keywords", "energetics, artemia, metabolism, amino acid, turbot");
        entry.setField("url", "http://ejournals.ebsco.com/direct.asp?ArticleID=TYY4NT82XA9H7R8PFPPV");
        entry.setField("abstract", "Abstract The present paper studied the influence of different food regimes on the free amino acid (FAA) pool, the rate of protein turnover, the flux of amino acids, and their relation to growth of larval turbot (Scophthalmus maximus L.) from first feeding until metamorphosis. The amino acid profile of protein was stable during the larval period although some small, but significant, differences were found. Turbot larvae had proteins which were rich in leucine and aspartate, and poor in glutamate, suggesting a high leucine requirement. The profile of the FAA pool was highly variable and quite different from the amino acid profile in protein. The proportion of essential FAA decreased with development. High contents of free tyrosine and phenylalanine were found on Day 3, while free taurine was present at high levels throughout the experimental period. Larval growth rates were positively correlated with taurine levels, suggesting a dietary dependency for taurine and/or sulphur amino acids.\n\nReduced growth rates in Artemia-fed larvae were associated with lower levels of free methionine, indicating that this diet is deficient in methionine for turbot larvae. Leucine might also be limiting turbot growth as the different diet organisms had lower levels of this amino acid in the free pool than was found in the larval protein. A previously presented model was used to describe the flux of amino acids in growing turbot larvae. The FAA pool was found to be small and variable. It was estimated that the daily dietary amino acid intake might be up to ten times the larval FAA pool. In addition, protein synthesis and protein degradation might daily remove and return, respectively, the equivalent of up to 20 and 10 times the size of the FAA pool. In an early phase (Day 11) high growth rates were associated with a relatively low protein turnover, while at a later stage (Day 17), a much higher turnover was observed.");
        return entry;
    }

    @Override
    public void setValues() {
        this.layout1.setText(this._prefs.get("preview0").replaceAll("__NEWLINE__", "\n"));
        this.layout2.setText(this._prefs.get("preview1").replaceAll("__NEWLINE__", "\n"));
        this.pdfPreview.setSelected(this._prefs.getBoolean("pdfPreview"));
    }

    @Override
    public void storeSettings() {
        this._prefs.put("preview0", this.layout1.getText().replaceAll("\n", "__NEWLINE__"));
        this._prefs.put("preview1", this.layout2.getText().replaceAll("\n", "__NEWLINE__"));
        this._prefs.putBoolean("pdfPreview", this.pdfPreview.isSelected());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Entry preview");
    }
}

