/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.TitleLabel;
import net.sf.jabref.Util;
import net.sf.jabref.export.LatexFieldFormatter;

public class DuplicateResolverDialog
extends JDialog {
    public static final int NOT_CHOSEN = -1;
    public static final int KEEP_BOTH = 0;
    public static final int KEEP_UPPER = 1;
    public static final int KEEP_LOWER = 2;
    public static final int AUTOREMOVE_EXACT = 3;
    public static final int BREAK = 5;
    public static final int IMPORT_AND_DELETE_OLD = 1;
    public static final int IMPORT_AND_KEEP_OLD = 0;
    public static final int DO_NOT_IMPORT = 2;
    public static final int DUPLICATE_SEARCH = 1;
    public static final int IMPORT_CHECK = 2;
    public static final int INSPECTION = 3;
    public static final int DUPLICATE_SEARCH_WITH_EXACT = 4;
    final Dimension DIM = new Dimension(650, 600);
    PreviewPanel p1;
    PreviewPanel p2;
    JTextArea ta1;
    JTextArea ta2;
    JTabbedPane tabbed = new JTabbedPane();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JButton first;
    JButton second;
    JButton both;
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JButton removeExact = null;
    JPanel options = new JPanel();
    JPanel main = new JPanel();
    JPanel source = new JPanel();
    int status = -1;
    boolean block = true;
    TitleLabel lab;

    public DuplicateResolverDialog(JFrame frame, BibtexEntry one, BibtexEntry two, int type) {
        super(frame, Globals.lang("Possible duplicate entries"), true);
        this.init(one, two, type);
        Util.placeDialog(this, frame);
    }

    public DuplicateResolverDialog(JDialog frame, BibtexEntry one, BibtexEntry two, int type) {
        super(frame, Globals.lang("Possible duplicate entries"), true);
        this.init(one, two, type);
        Util.placeDialog(this, frame);
    }

    private void init(BibtexEntry one, BibtexEntry two, int type) {
        switch (type) {
            case 1: {
                this.first = new JButton(Globals.lang("Keep upper"));
                this.second = new JButton(Globals.lang("Keep lower"));
                this.both = new JButton(Globals.lang("Keep both"));
                break;
            }
            case 3: {
                this.first = new JButton(Globals.lang("Remove old entry"));
                this.second = new JButton(Globals.lang("Remove entry from import"));
                this.both = new JButton(Globals.lang("Keep both"));
                break;
            }
            case 4: {
                this.first = new JButton(Globals.lang("Keep upper"));
                this.second = new JButton(Globals.lang("Keep lower"));
                this.both = new JButton(Globals.lang("Keep both"));
                this.removeExact = new JButton(Globals.lang("Automatically remove exact duplicates"));
                break;
            }
            default: {
                this.first = new JButton(Globals.lang("Import and remove old entry"));
                this.second = new JButton(Globals.lang("Do not import entry"));
                this.both = new JButton(Globals.lang("Import and keep old entry"));
            }
        }
        String layout = Globals.prefs.get("preview0");
        this.p1 = new PreviewPanel(null, one, null, new MetaData(), layout);
        this.p2 = new PreviewPanel(null, two, null, new MetaData(), layout);
        this.ta1 = new JTextArea();
        this.ta2 = new JTextArea();
        this.ta1.setEditable(false);
        this.ta2.setEditable(false);
        this.setSourceView(one, two);
        this.main.setLayout(this.gbl);
        this.source.setLayout(this.gbl);
        this.con.insets = new Insets(10, 10, 0, 10);
        this.con.fill = 1;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.lab = new TitleLabel(type == 1 ? "" : Globals.lang("Entry in current database"));
        this.gbl.setConstraints(this.lab, this.con);
        this.main.add(this.lab);
        this.con.weighty = 1.0;
        this.con.insets = new Insets(5, 10, 10, 10);
        JScrollPane sp = new JScrollPane(this.p1);
        this.gbl.setConstraints(sp, this.con);
        this.main.add(sp);
        this.con.weighty = 0.0;
        this.con.insets = new Insets(10, 10, 0, 10);
        this.lab = new TitleLabel(type == 1 ? "" : Globals.lang("Entry in import"));
        this.gbl.setConstraints(this.lab, this.con);
        this.main.add(this.lab);
        this.con.weighty = 1.0;
        this.con.insets = new Insets(5, 10, 10, 10);
        sp = new JScrollPane(this.ta1);
        this.gbl.setConstraints(sp, this.con);
        this.source.add(sp);
        sp = new JScrollPane(this.p2);
        this.gbl.setConstraints(sp, this.con);
        this.main.add(sp);
        sp = new JScrollPane(this.ta2);
        this.gbl.setConstraints(sp, this.con);
        this.source.add(sp);
        this.tabbed.add(Globals.lang("Short form"), this.main);
        this.tabbed.add(Globals.lang("Complete record"), this.source);
        if (this.removeExact != null) {
            this.options.add(this.removeExact);
        }
        this.options.add(this.first);
        this.options.add(this.second);
        this.options.add(this.both);
        if (type != 2) {
            this.options.add(Box.createHorizontalStrut(5));
            this.options.add(this.cancel);
        }
        this.first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateResolverDialog.this.status = 1;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        this.second.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateResolverDialog.this.status = 2;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        this.both.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateResolverDialog.this.status = 0;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        if (this.removeExact != null) {
            this.removeExact.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicateResolverDialog.this.status = 3;
                    DuplicateResolverDialog.this.block = false;
                    DuplicateResolverDialog.this.dispose();
                }
            });
        }
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateResolverDialog.this.status = 5;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.tabbed, "Center");
        this.getContentPane().add((Component)this.options, "South");
        this.pack();
        if (this.getHeight() > this.DIM.height) {
            this.setSize(new Dimension(this.getWidth(), this.DIM.height));
        }
        if (this.getWidth() > this.DIM.width) {
            this.setSize(new Dimension(this.DIM.width, this.getHeight()));
        }
        this.both.requestFocus();
    }

    private void setSourceView(BibtexEntry one, BibtexEntry two) {
        try {
            StringWriter sw = new StringWriter();
            one.write(sw, new LatexFieldFormatter(), false);
            this.ta1.setText(sw.getBuffer().toString());
            sw = new StringWriter();
            two.write(sw, new LatexFieldFormatter(), false);
            this.ta2.setText(sw.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEntries(BibtexEntry newOne, BibtexEntry newTwo) {
        this.setSourceView(newOne, newTwo);
        this.p1.setEntry(newOne);
        this.p2.setEntry(newTwo);
        this.status = -1;
        this.p1.revalidate();
        this.p1.repaint();
        this.block = true;
    }

    public boolean isBlocking() {
        return this.block;
    }

    public int getSelected() {
        return this.status;
    }

    public static int resolveDuplicate(JFrame frame, BibtexEntry one, BibtexEntry two) {
        DuplicateResolverDialog drd = new DuplicateResolverDialog(frame, one, two, 1);
        drd.setVisible(true);
        return drd.getSelected();
    }

    public static int resolveDuplicate(JDialog frame, BibtexEntry one, BibtexEntry two) {
        DuplicateResolverDialog drd = new DuplicateResolverDialog(frame, one, two, 1);
        drd.setVisible(true);
        return drd.getSelected();
    }

    public static int resolveDuplicateInImport(JabRefFrame frame, BibtexEntry existing, BibtexEntry imported) {
        DuplicateResolverDialog drd = new DuplicateResolverDialog(frame, existing, imported, 2);
        drd.setVisible(true);
        return drd.getSelected();
    }
}

