/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;

public class ContentSelectorDialog2
extends JDialog {
    ActionListener wordEditFieldListener = null;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JPanel fieldPan = new JPanel();
    JPanel wordPan = new JPanel();
    JPanel buttonPan = new JPanel();
    JPanel fieldNamePan = new JPanel();
    JPanel wordEditPan = new JPanel();
    final String WORD_EMPTY_TEXT = Globals.lang("<no field>");
    final String WORD_FIRSTLINE_TEXT = Globals.lang("<select word>");
    final String FIELD_FIRST_LINE = Globals.lang("<field name>");
    MetaData metaData;
    String currentField = null;
    TreeSet<String> fieldSet;
    TreeSet<String> wordSet;
    JabRefFrame frame;
    BasePanel panel;
    JButton help = new JButton(Globals.lang("Help"));
    JButton newField = new JButton(Globals.lang("New"));
    JButton removeField = new JButton(Globals.lang("Remove"));
    JButton newWord = new JButton(Globals.lang("New"));
    JButton removeWord = new JButton(Globals.lang("Remove"));
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton();
    JButton apply = new JButton(Globals.lang("Apply"));
    DefaultListModel fieldListModel = new DefaultListModel();
    DefaultListModel wordListModel = new DefaultListModel();
    JList fieldList = new JList(this.fieldListModel);
    JList wordList = new JList(this.wordListModel);
    JTextField fieldNameField = new JTextField("", 20);
    JTextField wordEditField = new JTextField("", 20);
    JScrollPane fPane = new JScrollPane(this.fieldList);
    JScrollPane wPane = new JScrollPane(this.wordList);
    HashMap<String, DefaultListModel> wordListModels = new HashMap();
    ArrayList<String> removedFields = new ArrayList();

    public ContentSelectorDialog2(Window owner, JabRefFrame frame, BasePanel panel, boolean modal, MetaData metaData, String fieldName) {
        super(owner, Globals.lang("Setup selectors"));
        this.setModal(modal);
        this.metaData = metaData;
        this.frame = frame;
        this.panel = panel;
        this.currentField = fieldName;
        this.initLayout();
        this.setupFieldSelector();
        this.setupWordSelector();
        this.setupActions();
        Util.bindCloseDialogKeyToCancelAction(this.rootPane, this.cancel.getAction());
        int fieldInd = this.fieldListModel.indexOf(this.currentField);
        if (fieldInd >= 0) {
            this.fieldList.setSelectedIndex(fieldInd);
        }
        this.pack();
    }

    private void setupActions() {
        this.wordList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ContentSelectorDialog2.this.wordEditField.setText((String)ContentSelectorDialog2.this.wordList.getSelectedValue());
                ContentSelectorDialog2.this.wordEditField.selectAll();
                new FocusRequester(ContentSelectorDialog2.this.wordEditField);
            }
        });
        this.newWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog2.this.newWordAction();
            }
        });
        this.wordEditFieldListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ContentSelectorDialog2.this.wordList.getSelectedIndex();
                String old = (String)ContentSelectorDialog2.this.wordList.getSelectedValue();
                String newVal = ContentSelectorDialog2.this.wordEditField.getText();
                if (newVal.equals("") || newVal.equals(old)) {
                    return;
                }
                if (ContentSelectorDialog2.this.wordListModel.contains(newVal)) {
                    index = ContentSelectorDialog2.this.wordListModel.indexOf(newVal);
                    ContentSelectorDialog2.this.wordList.ensureIndexIsVisible(index);
                    return;
                }
                int newIndex = ContentSelectorDialog2.this.findPos(ContentSelectorDialog2.this.wordListModel, newVal);
                if (index >= 0) {
                    ContentSelectorDialog2.this.wordListModel.remove(index);
                    if (newIndex > index) {
                        --newIndex;
                    }
                }
                ContentSelectorDialog2.this.wordListModel.add(newIndex, newVal);
                ContentSelectorDialog2.this.wordList.ensureIndexIsVisible(newIndex);
                ContentSelectorDialog2.this.wordEditField.selectAll();
            }
        };
        this.wordEditField.addActionListener(this.wordEditFieldListener);
        this.removeWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ContentSelectorDialog2.this.wordList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                ContentSelectorDialog2.this.wordListModel.remove(index);
                ContentSelectorDialog2.this.wordEditField.setText("");
                if (ContentSelectorDialog2.this.wordListModel.size() > 0) {
                    ContentSelectorDialog2.this.wordList.setSelectedIndex(Math.min(index, ContentSelectorDialog2.this.wordListModel.size() - 1));
                }
            }
        });
        this.fieldList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ContentSelectorDialog2.this.currentField = (String)ContentSelectorDialog2.this.fieldList.getSelectedValue();
                ContentSelectorDialog2.this.fieldNameField.setText("");
                ContentSelectorDialog2.this.setupWordSelector();
            }
        });
        this.newField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ContentSelectorDialog2.this.fieldListModel.get(0).equals(ContentSelectorDialog2.this.FIELD_FIRST_LINE)) {
                    ContentSelectorDialog2.this.fieldListModel.add(0, ContentSelectorDialog2.this.FIELD_FIRST_LINE);
                }
                ContentSelectorDialog2.this.fieldList.setSelectedIndex(0);
                ContentSelectorDialog2.this.fPane.getVerticalScrollBar().setValue(0);
                ContentSelectorDialog2.this.fieldNameField.setEnabled(true);
                ContentSelectorDialog2.this.fieldNameField.setText(ContentSelectorDialog2.this.currentField);
                ContentSelectorDialog2.this.fieldNameField.selectAll();
                new FocusRequester(ContentSelectorDialog2.this.fieldNameField);
            }
        });
        this.fieldNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog2.this.fieldNameField.transferFocus();
            }
        });
        this.fieldNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String s = ContentSelectorDialog2.this.fieldNameField.getText();
                ContentSelectorDialog2.this.fieldNameField.setText("");
                ContentSelectorDialog2.this.fieldNameField.setEnabled(false);
                if (!ContentSelectorDialog2.this.FIELD_FIRST_LINE.equals(s) && !"".equals(s)) {
                    int pos;
                    ContentSelectorDialog2.this.fieldListModel.remove(0);
                    if (ContentSelectorDialog2.this.fieldListModel.contains(s)) {
                        pos = ContentSelectorDialog2.this.fieldListModel.indexOf(s);
                    } else {
                        pos = ContentSelectorDialog2.this.findPos(ContentSelectorDialog2.this.fieldListModel, s);
                        ContentSelectorDialog2.this.fieldListModel.add(Math.max(0, pos), s);
                    }
                    ContentSelectorDialog2.this.fieldList.setSelectedIndex(pos);
                    ContentSelectorDialog2.this.fieldList.ensureIndexIsVisible(pos);
                    ContentSelectorDialog2.this.currentField = s;
                    ContentSelectorDialog2.this.setupWordSelector();
                    ContentSelectorDialog2.this.newWordAction();
                }
            }
        });
        this.removeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ContentSelectorDialog2.this.fieldList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                String fieldName = (String)ContentSelectorDialog2.this.fieldListModel.get(index);
                ContentSelectorDialog2.this.removedFields.add(fieldName);
                ContentSelectorDialog2.this.fieldListModel.remove(index);
                ContentSelectorDialog2.this.wordListModels.remove(fieldName);
                ContentSelectorDialog2.this.fieldNameField.setText("");
                if (ContentSelectorDialog2.this.fieldListModel.size() > 0) {
                    ContentSelectorDialog2.this.fieldList.setSelectedIndex(Math.min(index, ContentSelectorDialog2.this.wordListModel.size() - 1));
                }
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog2.this.frame.helpDiag.showPage("ContentSelectorHelp.html");
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog2.this.applyChanges();
                ContentSelectorDialog2.this.dispose();
            }
        });
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ContentSelectorDialog2.this.wordEditField.getText().equals("")) {
                    ContentSelectorDialog2.this.wordEditFieldListener.actionPerformed(null);
                }
                ContentSelectorDialog2.this.applyChanges();
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog2.this.dispose();
            }
        };
        cancelAction.putValue("Name", Globals.lang("Cancel"));
        this.cancel.setAction(cancelAction);
    }

    private void newWordAction() {
        if (this.wordListModel.size() == 0 || !this.wordListModel.get(0).equals(this.WORD_FIRSTLINE_TEXT)) {
            this.wordListModel.add(0, this.WORD_FIRSTLINE_TEXT);
        }
        this.wordList.setSelectedIndex(0);
        this.wPane.getVerticalScrollBar().setValue(0);
    }

    private void applyChanges() {
        boolean changedFieldSet = false;
        for (String fieldName : this.removedFields) {
            this.metaData.remove("selector_" + fieldName);
            changedFieldSet = true;
        }
        for (String fieldName : this.wordListModels.keySet()) {
            if (fieldName == null || this.FIELD_FIRST_LINE.equals(fieldName)) continue;
            DefaultListModel lm = this.wordListModels.get(fieldName);
            if (lm.size() > 0) {
                for (int start = 0; start < lm.size() && lm.get(start).equals(this.WORD_FIRSTLINE_TEXT); ++start) {
                }
            }
            Vector<String> data = this.metaData.getData("selector_" + fieldName);
            boolean newField = false;
            if (data == null) {
                newField = true;
                data = new Vector();
                changedFieldSet = true;
            } else {
                data.clear();
            }
            for (int wrd = start; wrd < lm.size(); ++wrd) {
                String word = (String)lm.get(wrd);
                data.add(word);
            }
            if (!newField) continue;
            this.metaData.putData("selector_" + fieldName, data);
        }
        this.panel.markNonUndoableBaseChanged();
        if (changedFieldSet) {
            this.panel.rebuildAllEntryEditors();
        } else {
            this.panel.updateAllContentSelectors();
        }
        this.panel.addContentSelectorValuesToAutoCompleters();
    }

    private void setupFieldSelector() {
        this.fieldListModel.clear();
        TreeSet<String> contents = new TreeSet<String>();
        for (String s : this.metaData) {
            if (!s.startsWith("selector_")) continue;
            contents.add(s.substring("selector_".length()));
        }
        if (contents.size() == 0) {
            this.fieldListModel.addElement("author");
            this.fieldListModel.addElement("journal");
            this.fieldListModel.addElement("keywords");
            this.fieldListModel.addElement("publisher");
        } else {
            for (String s : contents) {
                this.fieldListModel.addElement(s);
            }
        }
        if (this.currentField == null) {
            this.fieldList.setSelectedIndex(0);
        } else {
            int i = this.fieldListModel.indexOf(this.currentField);
            if (i != -1) {
                this.fieldList.setSelectedIndex(i);
            }
        }
    }

    private void setupWordSelector() {
        this.wordListModel = this.wordListModels.get(this.currentField);
        if (this.wordListModel != null) {
            this.wordList.setModel(this.wordListModel);
        } else {
            this.wordListModel = new DefaultListModel();
            this.wordList.setModel(this.wordListModel);
            this.wordListModels.put(this.currentField, this.wordListModel);
            Vector<String> items = this.metaData.getData("selector_" + this.currentField);
            if (items != null) {
                this.wordSet = new TreeSet<String>(items);
                int index = 0;
                for (String s : this.wordSet) {
                    this.wordListModel.add(index, s);
                    ++index;
                }
            }
        }
    }

    private int findPos(DefaultListModel lm, String item) {
        for (int i = 0; i < lm.size(); ++i) {
            String s = (String)lm.get(i);
            if (item.compareToIgnoreCase(s) >= 0) continue;
            return i;
        }
        return lm.size();
    }

    private void initLayout() {
        this.fieldNameField.setEnabled(false);
        this.fieldList.setVisibleRowCount(4);
        this.wordList.setVisibleRowCount(10);
        String VAL = "Uren luren himmelturen, ja Besseggen.";
        this.fieldList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.wordList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.fieldPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Field name")));
        this.wordPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Keyword")));
        this.fieldPan.setLayout(this.gbl);
        this.wordPan.setLayout(this.gbl);
        this.con.insets = new Insets(2, 2, 2, 2);
        this.con.fill = 1;
        this.con.gridwidth = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fPane, this.con);
        this.fieldPan.add(this.fPane);
        this.gbl.setConstraints(this.wPane, this.con);
        this.wordPan.add(this.wPane);
        this.con.gridwidth = 1;
        this.con.gridx = 2;
        this.con.gridheight = 2;
        this.gbl.setConstraints(this.fieldNamePan, this.con);
        this.fieldPan.add(this.fieldNamePan);
        this.gbl.setConstraints(this.wordEditPan, this.con);
        this.wordPan.add(this.wordEditPan);
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.newField, this.con);
        this.fieldPan.add(this.newField);
        this.gbl.setConstraints(this.newWord, this.con);
        this.wordPan.add(this.newWord);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.removeField, this.con);
        this.fieldPan.add(this.removeField);
        this.gbl.setConstraints(this.removeWord, this.con);
        this.wordPan.add(this.removeWord);
        this.con.anchor = 17;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldNameField, this.con);
        this.fieldNamePan.add(this.fieldNameField);
        this.gbl.setConstraints(this.wordEditField, this.con);
        this.wordEditPan.add(this.wordEditField);
        ButtonBarBuilder bsb = new ButtonBarBuilder(this.buttonPan);
        bsb.addGlue();
        bsb.addButton((JComponent)this.ok);
        bsb.addButton((JComponent)this.apply);
        bsb.addButton((JComponent)this.cancel);
        bsb.addRelatedGap();
        bsb.addButton((JComponent)this.help);
        bsb.addGlue();
        this.con.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.con.weightx = 1.0;
        this.con.weighty = 0.5;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldPan, this.con);
        this.getContentPane().add(this.fieldPan);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.wordPan, this.con);
        this.getContentPane().add(this.wordPan);
        this.con.weighty = 0.0;
        this.con.gridy = 2;
        this.con.insets = new Insets(12, 2, 2, 2);
        this.gbl.setConstraints(this.buttonPan, this.con);
        this.getContentPane().add(this.buttonPan);
    }
}

