/*
 * Decompiled with CFR 0.152.
 */
package mork;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mork.Dict;
import mork.Row;
import mork.ScopeTypes;
import mork.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private String tableId;
    private String scopeName;
    private List<Row> rows = new LinkedList<Row>();

    public Table(String content) {
        this(content, Dict.EMPTY_LIST);
    }

    public Table(String content, List<Dict> dicts) {
        Pattern pattern = Pattern.compile("\\{\\s*([-\\w]*):(\\w*)\\s*(\\[.*\\]\\s*)*\\}");
        Matcher matcher = pattern.matcher(content);
        String rowsContent = null;
        if (!matcher.matches()) {
            Pattern pattern1 = Pattern.compile("\\{\\s*([-\\w]*):\\^([0-9A-Z]*)\\s*(\\[.*\\]\\s*)*\\}");
            Matcher matcher1 = pattern1.matcher(content);
            if (!matcher1.matches()) {
                Pattern pattern0 = Pattern.compile("\\{\\s*([-\\w]*)\\s*(\\[.*\\]\\s*)*\\}");
                Matcher matcher0 = pattern0.matcher(content);
                if (!matcher0.matches()) {
                    Pattern pattern2 = Pattern.compile("\\{\\s*([-\\w]*):\\^([0-9A-Z]*)(.*)");
                    Matcher matcher2 = pattern2.matcher(StringUtils.removeNewlines(content));
                    if (!matcher2.matches()) {
                        throw new IllegalArgumentException("Table does not match any of the known formats: " + content);
                    }
                    this.tableId = matcher2.group(1);
                    this.scopeName = Dict.dereference("^" + matcher2.group(2), dicts, ScopeTypes.COLUMN_SCOPE);
                    rowsContent = matcher2.group(3);
                } else {
                    this.tableId = matcher0.group(1);
                    rowsContent = matcher0.group(2);
                }
            } else {
                this.tableId = matcher1.group(1);
                this.scopeName = Dict.dereference("^" + matcher1.group(2), dicts, ScopeTypes.COLUMN_SCOPE);
                rowsContent = matcher1.group(3);
            }
        } else {
            this.tableId = matcher.group(1);
            this.scopeName = matcher.group(2);
            rowsContent = matcher.group(3);
        }
        Pattern rowsPattern = Pattern.compile("\\[[^\\]]*\\]");
        Matcher rowsMatcher = rowsPattern.matcher(rowsContent);
        while (rowsMatcher.find()) {
            Row row = new Row(rowsMatcher.group(), dicts);
            this.rows.add(row);
        }
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(this.rows);
    }
}

